# دليل خطوات نشر النتائج على الموقع
## Guide for Publishing Results on Website

---

## 📋 جدول المحتويات

1. [المقدمة](#المقدمة)
2. [المتطلبات الأساسية](#المتطلبات-الأساسية)
3. [الخطوة 1: التحقق من قاعدة البيانات](#الخطوة-1-التحقق-من-قاعدة-البيانات)
4. [الخطوة 2: إدخال الدرجات](#الخطوة-2-إدخال-الدرجات)
5. [الخطوة 3: نشر النتائج](#الخطوة-3-نشر-النتائج)
6. [الخطوة 4: اختبار البحث عن النتائج](#الخطوة-4-اختبار-البحث-عن-النتائج)
7. [إدارة النتائج المنشورة](#إدارة-النتائج-المنشورة)
8. [إدارة نشاط الطلاب](#إدارة-نشاط-الطلاب)
9. [الأسئلة الشائعة](#الأسئلة-الشائعة)
10. [معلومات تقنية](#معلومات-تقنية)

---

## 📖 المقدمة

نظام نشر النتائج يسمح للطلاب بالبحث عن نتائجهم على الموقع باستخدام الرقم الجامعي فقط. النتائج تكون متاحة لفترة محددة (افتراضياً 7 أيام) ويمكن تجديدها أو إلغاء نشرها في أي وقت.

---

## ✅ المتطلبات الأساسية

قبل البدء، تأكد من:

- ✅ وجود حساب مسؤول (admin) أو مدير كلية (college_admin) أو مسجل (registrar)
- ✅ وجود طلاب مسجلين في النظام
- ✅ وجود فصول دراسية محددة
- ✅ وجود مواد مسجلة للطلاب
- ✅ وجود درجات مدخلة للطلاب

---

## 🔧 الخطوة 1: التحقق من قاعدة البيانات

### 1.1 التحقق التلقائي

الجدول `published_results` يتم إنشاؤه تلقائياً عند فتح صفحة النشر لأول مرة. لا حاجة لإجراءات يدوية.

### 1.2 التحقق اليدوي (اختياري)

إذا كنت تريد التحقق يدوياً:

1. افتح **phpMyAdmin** أو أي أداة إدارة قاعدة بيانات
2. اختر قاعدة البيانات `university_results`
3. تحقق من وجود الجدول التالي:

```sql
published_results
```

### 1.3 إنشاء الجدول يدوياً (إذا لم يتم إنشاؤه)

```sql
CREATE TABLE IF NOT EXISTS published_results (
    id INT PRIMARY KEY AUTO_INCREMENT,
    semester_id INT NOT NULL,
    published_by INT NOT NULL,
    published_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    FOREIGN KEY (semester_id) REFERENCES semesters(id) ON DELETE CASCADE,
    FOREIGN KEY (published_by) REFERENCES users(id) ON DELETE RESTRICT,
    UNIQUE KEY unique_semester_published (semester_id),
    INDEX idx_expires_at (expires_at),
    INDEX idx_is_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

### 1.4 التحقق من عمود `results_blocked` في جدول `students`

يتم إضافة هذا العمود تلقائياً، ولكن للتأكد:

```sql
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS results_blocked BOOLEAN DEFAULT FALSE AFTER status;
```

---

## 📝 الخطوة 2: إدخال الدرجات

قبل نشر النتائج، يجب إدخال جميع الدرجات للطلاب:

### 2.1 إدخال الدرجات بالطريقة البسيطة

1. سجل الدخول كمسؤول أو مسجل
2. اذهب إلى **لوحة التحكم**
3. اضغط على **📝 إدخال الدرجات**
4. اختر:
   - التخصص
   - الفصل الدراسي
   - المادة
5. أدخل الدرجات للطلاب
6. اضغط **حفظ**

### 2.2 إدخال الدرجات حسب التخصص والفصل (الطريقة المتقدمة)

1. سجل الدخول كمسؤول أو مسجل
2. اذهب إلى **لوحة التحكم**
3. اضغط على **📝 تعديل درجات الطلاب حسب التخصص والفصل**
4. اختر بشكل متتالي:
   - **الكلية**
   - **التخصص**
   - **الفصل الدراسي** (رقم الفصل)
   - **السنة الدراسية**
5. سيظهر جدول بجميع الطلاب وموادهم
6. أدخل أو عدل الدرجات
7. اضغط **✅ حفظ جميع التعديلات**

### 2.3 التحقق من الدرجات

1. اذهب إلى **📊 عرض درجات الطالب**
2. اختر طالب
3. تحقق من ظهور جميع الدرجات بشكل صحيح

---

## 🌐 الخطوة 3: نشر النتائج

### 3.1 الوصول إلى صفحة النشر

1. سجل الدخول كـ:
   - **Admin** (مدير عام)
   - **College Admin** (مدير كلية)
   - **Registrar** (مسجل)

2. اذهب إلى **لوحة التحكم (Dashboard)**

3. اضغط على **🌐 نشر النتائج على الموقع**

   أو

   افتح الرابط مباشرة:
   ```
   http://localhost/GUNS/publish_results.php
   ```

### 3.2 اختيار الفصل الدراسي للنشر

1. في صفحة **نشر النتائج**، ستجد قائمة بجميع الفصول الدراسية
2. لكل فصل ستظهر المعلومات التالية:
   - رقم الفصل الدراسي
   - العام الدراسي
   - التخصص
   - الكلية
   - عدد الدرجات المدخلة
   - حالة النشر (منشور / غير منشور / منتهي الصلاحية)

### 3.3 نشر الفصل الدراسي

1. ابحث عن الفصل الدراسي الذي تريد نشر نتائجه
2. إذا كان الفصل **غير منشور**:
   - أدخل عدد الأيام (افتراضياً: 7 أيام)
   - اضغط زر **نشر**
3. إذا كان الفصل **منشور بالفعل**:
   - يمكنك **إلغاء النشر** إذا أردت
   - أو يمكنك **تحديث النشر** بإعادة النشر لفترة جديدة

### 3.4 تحديد فترة النشر

- **الحد الأدنى:** 1 يوم
- **الحد الأقصى:** 30 يوم
- **الافتراضي:** 7 أيام

**مثال:**
- إذا نشرت الفصل لمدة 7 أيام في `2024-01-01 10:00`
- ستكون النتائج متاحة حتى `2024-01-08 10:00`
- بعد ذلك ستنتهي تلقائياً

---

## 🔍 الخطوة 4: اختبار البحث عن النتائج

### 4.1 الوصول إلى صفحة البحث

1. افتح المتصفح (يمكنك استخدام نافذة خاصة/خاصية)
2. اذهب إلى:
   ```
   http://localhost/GUNS/public_results.php
   ```

### 4.2 البحث عن النتائج

1. أدخل **الرقم الجامعي** للطالب
2. اضغط **بحث**
3. ستظهر النتائج المنشورة للطالب

### 4.3 ما الذي سيظهر للطالب؟

- معلومات الطالب (الاسم، الرقم الجامعي، التخصص، الكلية)
- جميع الفصول المنشورة للطالب
- درجات كل مادة في كل فصل
- المعدل الفصلي لكل فصل
- المعدل التراكمي
- إمكانية طباعة النتائج

---

## 🛠️ إدارة النتائج المنشورة

### 5.1 إلغاء نشر النتائج

1. اذهب إلى **صفحة نشر النتائج**
2. ابحث عن الفصل **المنشور**
3. اضغط **إلغاء النشر**
4. تأكد من العملية

**ملاحظة:** سيتم إيقاف النتائج فوراً، ولن يتمكن الطلاب من رؤيتها.

### 5.2 تجديد النشر

إذا انتهت صلاحية النتائج:

1. اذهب إلى **صفحة نشر النتائج**
2. ابحث عن الفصل **منتهي الصلاحية**
3. أدخل عدد الأيام الجديدة
4. اضغط **نشر**

### 5.3 تحديث النشر قبل انتهاء الصلاحية

1. اذهب إلى **صفحة نشر النتائج**
2. ابحث عن الفصل **المنشور**
3. اضغط **إلغاء النشر** أولاً
4. ثم أعد النشر لفترة جديدة

---

## 👥 إدارة نشاط الطلاب

### 6.1 حجب نتائج طالب معين

في بعض الحالات، قد ترغب في حجب نتائج طالب معين:

#### الخطوات:

1. في صفحة **نشر النتائج**، اذهب إلى قسم **إدارة نشاط الطلاب**
2. في صندوق البحث، أدخل:
   - الرقم الجامعي للطالب
   - أو الاسم الكامل للطالب
3. اضغط **بحث**
4. من النتائج، ستجد:
   - معلومات الطالب
   - حالة الطالب (نشط / موقوف)
   - حالة حجب النتائج (محجوبة / غير محجوبة)
5. اضغط **حجب النتائج**

**النتيجة:**
- لن تظهر نتائج هذا الطالب على صفحة البحث العامة
- سيظهر له رسالة: "نتائج هذا الطالب محجوبة حالياً"
- الطالب يبقى نشطاً في النظام

### 6.2 فك حجب نتائج طالب

1. ابحث عن الطالب
2. اضغط **فك الحجب**
3. ستظهر نتائجه مرة أخرى على الموقع

### 6.3 إيقاف نشاط طالب

إذا أردت إيقاف الطالب بالكامل:

1. ابحث عن الطالب
2. اضغط **إيقاف النشاط**

**الفرق بين إيقاف النشاط وحجب النتائج:**

| الميزة | إيقاف النشاط | حجب النتائج |
|--------|--------------|-------------|
| يمنع ظهور النتائج | ✅ | ✅ |
| يوقف الطالب في النظام | ✅ | ❌ |
| يمكن للطالب الدخول لحسابه | ❌ | ✅ |

### 6.4 تفعيل نشاط طالب

1. ابحث عن الطالب الموقوف
2. اضغط **تفعيل النشاط**
3. سيتم تفعيل الطالب وعودة جميع صلاحياته

---

## ❓ الأسئلة الشائعة

### س1: كيف أعرف أن النتائج منشورة بشكل صحيح؟

**ج:** 
- اذهب إلى `public_results.php`
- أدخل رقم جامعي لطالب له درجات في الفصل المنشور
- إذا ظهرت النتائج، فالنشر ناجح ✅

### س2: هل يمكن نشر أكثر من فصل في نفس الوقت؟

**ج:** نعم، يمكنك نشر أي عدد من الفصول في نفس الوقت. كل فصل له فترة نشر مستقلة.

### س3: ماذا يحدث عندما تنتهي صلاحية النتائج؟

**ج:** 
- النتائج تُعطل تلقائياً
- لا تظهر للطلاب على صفحة البحث
- يمكنك إعادة نشرها في أي وقت

### س4: هل يمكن للطلاب رؤية نتائج فصول سابقة؟

**ج:** 
- فقط الفصول **المنشورة** و**غير المنتهية الصلاحية**
- كل فصل يجب نشره بشكل منفصل

### س5: كيف أمنع طالب معين من رؤية نتائجه؟

**ج:** 
- استخدم قسم **إدارة نشاط الطلاب**
- ابحث عن الطالب
- اضغط **حجب النتائج**

### س6: ماذا أفعل إذا أردت تغيير درجة بعد النشر؟

**ج:** 
1. اذهب إلى صفحة تعديل الدرجات
2. عدل الدرجة
3. **لا حاجة لإعادة النشر** - التغييرات تظهر تلقائياً

### س7: هل يمكن للطلاب طباعة نتائجهم؟

**ج:** نعم، في صفحة النتائج العامة يوجد زر **طباعة** في أعلى الصفحة.

---

## 🔧 معلومات تقنية

### الجداول المستخدمة

1. **`published_results`**
   - يحفظ معلومات النشر لكل فصل
   - يحتوي على: `semester_id`, `published_by`, `published_at`, `expires_at`, `is_active`

2. **`students`**
   - يحتوي على عمود `results_blocked` لحجب نتائج طالب معين
   - يحتوي على عمود `status` لحالة الطالب (active, suspended, etc.)

3. **`semesters`**
   - يحتوي على معلومات الفصول الدراسية

4. **`grades`**
   - يحتوي على درجات الطلاب

### الملفات الرئيسية

1. **`publish_results.php`**
   - صفحة إدارية لنشر/إلغاء نشر النتائج
   - الوصول: Admin, College Admin, Registrar

2. **`public_results.php`**
   - صفحة عامة للطلاب للبحث عن نتائجهم
   - لا تحتاج تسجيل دخول

### الصلاحيات المطلوبة

- **نشر النتائج:** Admin, College Admin, Registrar
- **البحث عن النتائج:** عام (لا يحتاج تسجيل دخول)

### الأمان

✅ النتائج متاحة فقط للفصول المنشورة  
✅ النتائج تنتهي تلقائياً بعد المدة المحددة  
✅ الطلاب النشطون فقط (status = 'active')  
✅ الطلاب غير المحجوبة نتائجهم (results_blocked = 0)  
✅ يمكن للمسؤولين إلغاء النشر في أي وقت  

---

## 📞 الدعم

إذا واجهت أي مشاكل:

1. تحقق من سجلات الأخطاء في `logs/php-error.log`
2. تأكد من أن جميع الجداول موجودة
3. تأكد من وجود درجات مدخلة قبل النشر
4. تأكد من أن الطالب نشط وغير محجوبة نتائجه

---

## ✅ قائمة التحقق النهائية

قبل نشر النتائج، تأكد من:

- [ ] جميع الدرجات مدخلة للطلاب
- [ ] الفصل الدراسي موجود في النظام
- [ ] الطلاب نشطون (status = 'active')
- [ ] الطلاب غير محجوبة نتائجهم (results_blocked = 0)
- [ ] لديك صلاحيات النشر (Admin / College Admin / Registrar)
- [ ] جدول `published_results` موجود في قاعدة البيانات

---

**تم إنشاء هذا الدليل بواسطة:** نظام نتائج الجامعة  
**آخر تحديث:** 2024

