<?php
/**
 * صفحة عرض الأدلة والإرشادات
 * View Guide Page
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();

if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin') && !$auth->hasRole('registrar'))) {
    header('Location: index.php');
    exit;
}

// الحصول على اسم الملف من URL
$file = isset($_GET['file']) ? basename($_GET['file']) : '';

// قائمة الملفات المسموح بها (للأمان)
$allowed_files = [
    'دليل_نشر_النتائج.md',
    'ملخص_نشر_النتائج.md',
    'PUBLISH_RESULTS_GUIDE.md',
    'دليل_إضافة_الطلاب_والتسجيل.md',
    'دليل_إدارة_الفصول_وإضافة_المواد.md',
    'الدليل_الشامل_للنظام.md',
    'دليل_رفع_الطلاب_من_الإكسل.md',
    'دليل_رفع_الدرجات_من_الإكسل.md'
];

// التحقق من أن الملف مسموح
if (!in_array($file, $allowed_files) || !file_exists($file)) {
    header('Location: dashboard.php');
    exit;
}

// قراءة محتوى الملف
$content = file_get_contents($file);

// تحويل Markdown بسيط إلى HTML (تحويل أساسي)
function markdownToHtml($text) {
    // تحويل العناوين
    $text = preg_replace('/^# (.+)$/m', '<h1>$1</h1>', $text);
    $text = preg_replace('/^## (.+)$/m', '<h2>$1</h2>', $text);
    $text = preg_replace('/^### (.+)$/m', '<h3>$1</h3>', $text);
    $text = preg_replace('/^#### (.+)$/m', '<h4>$1</h4>', $text);
    
    // تحويل النقاط
    $text = preg_replace('/^- (.+)$/m', '<li>$1</li>', $text);
    $text = preg_replace('/^(\d+)\. (.+)$/m', '<li>$2</li>', $text);
    
    // تحويل النص السميك
    $text = preg_replace('/\*\*(.+?)\*\*/', '<strong>$1</strong>', $text);
    
    // تحويل النص المائل
    $text = preg_replace('/\*(.+?)\*/', '<em>$1</em>', $text);
    
    // تحويل code blocks أولاً (قبل inline codes)
    $text = preg_replace('/```(\w+)?\s*\n(.*?)```/s', '<pre style="background: #f4f4f4; padding: 15px; border-radius: 5px; overflow-x: auto;"><code>$2</code></pre>', $text);
    
    // تحويل الأكواد (inline) - بعد code blocks
    $text = preg_replace('/`([^`]+)`/', '<code style="background: #f4f4f4; padding: 2px 6px; border-radius: 3px; font-family: monospace;">$1</code>', $text);
    
    // تحويل الروابط
    $text = preg_replace('/\[(.+?)\]\((.+?)\)/', '<a href="$2">$1</a>', $text);
    
    // تحويل الفقرات
    $lines = explode("\n", $text);
    $html = '';
    $in_list = false;
    
    foreach ($lines as $line) {
        $line = trim($line);
        
        if (empty($line)) {
            if ($in_list) {
                $html .= '</ul>';
                $in_list = false;
            }
            $html .= '<br>';
            continue;
        }
        
        if (preg_match('/^<li>/', $line)) {
            if (!$in_list) {
                $html .= '<ul>';
                $in_list = true;
            }
            $html .= $line;
        } else {
            if ($in_list) {
                $html .= '</ul>';
                $in_list = false;
            }
            
            if (!preg_match('/^<(h[1-4]|ul|ol|p|div)/', $line)) {
                $html .= '<p>' . $line . '</p>';
            } else {
                $html .= $line;
            }
        }
    }
    
    if ($in_list) {
        $html .= '</ul>';
    }
    
    return $html;
}

$html_content = markdownToHtml($content);

include 'includes/header.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>عرض الدليل - <?php echo htmlspecialchars($file); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .guide-container {
            max-width: 900px;
            margin: 20px auto;
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            line-height: 1.8;
        }
        .guide-container h1 {
            color: #667eea;
            border-bottom: 3px solid #667eea;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        .guide-container h2 {
            color: #764ba2;
            margin-top: 30px;
            margin-bottom: 15px;
            padding-right: 15px;
            border-right: 4px solid #764ba2;
        }
        .guide-container h3 {
            color: #555;
            margin-top: 25px;
            margin-bottom: 10px;
        }
        .guide-container h4 {
            color: #666;
            margin-top: 20px;
            margin-bottom: 10px;
        }
        .guide-container ul {
            margin: 15px 0;
            padding-right: 30px;
        }
        .guide-container li {
            margin: 8px 0;
        }
        .guide-container code {
            background: #f4f4f4;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
        }
        .guide-container strong {
            color: #333;
            font-weight: bold;
        }
        .guide-container a {
            color: #667eea;
            text-decoration: none;
        }
        .guide-container a:hover {
            text-decoration: underline;
        }
        .guide-actions {
            text-align: center;
            margin: 30px 0;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        .guide-actions a {
            display: inline-block;
            margin: 0 10px;
            padding: 10px 20px;
            background: #667eea;
            color: white;
            border-radius: 5px;
            text-decoration: none;
        }
        .guide-actions a:hover {
            background: #764ba2;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="guide-actions">
            <a href="dashboard.php">← العودة للوحة التحكم</a>
            <?php if ($file === 'دليل_إضافة_الطلاب_والتسجيل.md'): ?>
                <a href="students.php">👥 إدارة الطلاب</a>
                <a href="registration/index.php">📋 نظام التسجيل الشامل</a>
            <?php elseif (in_array($file, ['دليل_رفع_الطلاب_من_الإكسل.md', 'دليل_رفع_الدرجات_من_الإكسل.md'])): ?>
                <a href="templates_page.php">📥 قوالب رفع البيانات</a>
                <a href="students.php">👥 إدارة الطلاب</a>
                <a href="upload_grades_excel.php">📊 رفع الدرجات</a>
            <?php else: ?>
                <a href="publish_results.php">نشر النتائج</a>
                <a href="view_guide.php?file=ملخص_نشر_النتائج.md">الملخص السريع</a>
            <?php endif; ?>
        </div>
        
        <div class="guide-container">
            <?php echo $html_content; ?>
        </div>
        
        <div class="guide-actions">
            <a href="dashboard.php">← العودة للوحة التحكم</a>
            <?php if ($file === 'دليل_إضافة_الطلاب_والتسجيل.md'): ?>
                <a href="students.php">👥 إدارة الطلاب</a>
                <a href="registration/index.php">📋 نظام التسجيل الشامل</a>
            <?php elseif (in_array($file, ['دليل_رفع_الطلاب_من_الإكسل.md', 'دليل_رفع_الدرجات_من_الإكسل.md'])): ?>
                <a href="templates_page.php">📥 قوالب رفع البيانات</a>
                <a href="students.php">👥 إدارة الطلاب</a>
                <a href="upload_grades_excel.php">📊 رفع الدرجات</a>
            <?php else: ?>
                <a href="publish_results.php">نشر النتائج</a>
            <?php endif; ?>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

