<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';
require_once __DIR__ . '/classes/CertificateGenerator.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$certificate_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$certificate_id) {
    header('Location: dashboard.php');
    exit;
}

$db = Database::getInstance();
$certificateGenerator = new CertificateGenerator();

$certificate = $certificateGenerator->getCertificateData($certificate_id);

if (!$certificate) {
    header('Location: dashboard.php');
    exit;
}

// التحقق من الصلاحية
if ($auth->hasRole('student')) {
    if ($certificate['student_id'] != $db->fetchOne("SELECT id FROM students WHERE user_id = ?", [$_SESSION['user_id']])['id']) {
        header('Location: dashboard.php');
        exit;
    }
} elseif (!$auth->canAccessStudent($certificate['student_id']) && !$auth->hasRole('admin')) {
    header('Location: dashboard.php');
    exit;
}

$certificate_types = [
    'detailed' => 'شهادة تفاصيل',
    'university' => 'شهادة جامعية',
    'transcript' => 'كشف درجات',
    'enrollment' => 'شهادة قيد',
    'graduation' => 'شهادة تخرج'
];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>عرض الشهادة</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .certificate-view {
            background: white;
            padding: 50px;
            margin: 20px auto;
            max-width: 800px;
            border: 3px solid #667eea;
            text-align: center;
        }
        .certificate-view h1 {
            color: #667eea;
            margin-bottom: 30px;
        }
        .certificate-info {
            margin: 20px 0;
            text-align: right;
        }
        .certificate-info p {
            margin: 10px 0;
            font-size: 1.1em;
        }
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="no-print" style="margin-bottom: 20px;">
            <a href="javascript:window.print()" class="btn btn-primary">طباعة</a>
            <?php if ($auth->hasRole('student')): ?>
                <a href="student_certificates.php" class="btn btn-secondary">العودة</a>
            <?php endif; ?>
        </div>
        
        <div class="certificate-view">
            <h1>شهادة <?php echo $certificate_types[$certificate['certificate_type']]; ?></h1>
            
            <div class="certificate-info">
                <p><strong>رقم الشهادة:</strong> <?php echo htmlspecialchars($certificate['certificate_number']); ?></p>
                <p><strong>الاسم:</strong> <?php echo htmlspecialchars($certificate['full_name_ar']); ?></p>
                <p><strong>الرقم الجامعي:</strong> <?php echo htmlspecialchars($certificate['student_number']); ?></p>
                <p><strong>الكلية:</strong> <?php echo htmlspecialchars($certificate['college_name']); ?></p>
                <p><strong>التخصص:</strong> <?php echo htmlspecialchars($certificate['major_name']); ?></p>
                <p><strong>تاريخ الإصدار:</strong> <?php echo date('Y-m-d', strtotime($certificate['issue_date'])); ?></p>
                <p><strong>صادر من:</strong> <?php echo htmlspecialchars($certificate['issued_by_name']); ?></p>
            </div>
            
            <div style="margin-top: 50px; border-top: 2px solid #667eea; padding-top: 20px;">
                <p>هذه شهادة رسمية صادرة من نظام نتائج الجامعة</p>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

