<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$message = '';

// الأدوار المتاحة (يجب تعريفها قبل معالجة الإضافة والتعديل)
// مدير الكلية يمكنه فقط إنشاء مسجل وأستاذ (لا يمكنه إنشاء admin أو college_admin)
$available_roles = ['registrar', 'instructor'];
if ($auth->hasRole('admin')) {
    $available_roles = ['admin', 'college_admin', 'registrar', 'instructor'];
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $full_name_ar = $_POST['full_name_ar'] ?? '';
    $full_name_en = $_POST['full_name_en'] ?? '';
    $email = $_POST['email'] ?? '';
    $role = $_POST['role'] ?? '';
    $college_id = (int)($_POST['college_id'] ?? $_SESSION['college_id']);
    
    // التحقق من الصلاحيات
    if (!$auth->belongsToCollege($college_id) && !$auth->hasRole('admin')) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لإضافة مستخدم في هذه الكلية</div>';
    } elseif (!in_array($role, $available_roles)) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لإنشاء مستخدم بهذا الدور</div>';
    } elseif (empty($username) || empty($password) || empty($full_name_ar) || empty($role)) {
        $message = '<div class="alert alert-error">يرجى ملء جميع الحقول المطلوبة</div>';
    } else {
        // التحقق من أن اسم المستخدم غير مستخدم
        $existing = $db->fetchOne("SELECT * FROM users WHERE username = ?", [$username]);
        if ($existing) {
            $message = '<div class="alert alert-error">اسم المستخدم موجود مسبقاً</div>';
        } else {
            try {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                
                $db->query(
                    "INSERT INTO users (college_id, username, password, full_name_ar, full_name_en, email, role, is_active) 
                     VALUES (?, ?, ?, ?, ?, ?, ?, 1)",
                    [$college_id, $username, $hashed_password, $full_name_ar, $full_name_en, $email, $role]
                );
                
                $message = '<div class="alert alert-success">تم إضافة المستخدم بنجاح</div>';
            } catch (PDOException $e) {
                $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }
        }
    }
}

// معالجة التعديل
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = (int)($_POST['id'] ?? 0);
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $full_name_ar = $_POST['full_name_ar'] ?? '';
    $full_name_en = $_POST['full_name_en'] ?? '';
    $email = $_POST['email'] ?? '';
    $role = $_POST['role'] ?? '';
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $college_id = (int)($_POST['college_id'] ?? $_SESSION['college_id']);
    
    // التحقق من الصلاحيات
    $user_check = $db->fetchOne("SELECT college_id, role FROM users WHERE id = ?", [$id]);
    if (!$user_check || (!$auth->belongsToCollege($user_check['college_id']) && !$auth->hasRole('admin'))) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لتعديل هذا المستخدم</div>';
    } elseif (!$auth->belongsToCollege($college_id) && !$auth->hasRole('admin')) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لإضافة مستخدم في هذه الكلية</div>';
    } elseif (!in_array($role, $available_roles)) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لتعديل دور المستخدم إلى هذا الدور</div>';
    } elseif (!$auth->hasRole('admin') && ($user_check['role'] == 'admin' || $user_check['role'] == 'college_admin')) {
        $message = '<div class="alert alert-error">ليس لديك صلاحية لتعديل مدير عام أو مدير كلية</div>';
    } elseif (empty($username) || empty($full_name_ar) || empty($role)) {
        $message = '<div class="alert alert-error">يرجى ملء جميع الحقول المطلوبة</div>';
    } else {
        try {
            // التحقق من أن اسم المستخدم غير مستخدم (باستثناء المستخدم الحالي)
            $existing = $db->fetchOne("SELECT * FROM users WHERE username = ? AND id != ?", [$username, $id]);
            if ($existing) {
                $message = '<div class="alert alert-error">اسم المستخدم موجود مسبقاً</div>';
            } else {
                if (!empty($password)) {
                    // تحديث مع كلمة المرور
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $db->query(
                        "UPDATE users SET username = ?, password = ?, full_name_ar = ?, full_name_en = ?, 
                         email = ?, role = ?, college_id = ?, is_active = ? WHERE id = ?",
                        [$username, $hashed_password, $full_name_ar, $full_name_en, $email, $role, $college_id, $is_active, $id]
                    );
                } else {
                    // تحديث بدون كلمة المرور
                    $db->query(
                        "UPDATE users SET username = ?, full_name_ar = ?, full_name_en = ?, 
                         email = ?, role = ?, college_id = ?, is_active = ? WHERE id = ?",
                        [$username, $full_name_ar, $full_name_en, $email, $role, $college_id, $is_active, $id]
                    );
                }
                
                $message = '<div class="alert alert-success">تم تحديث المستخدم بنجاح</div>';
            }
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// معالجة الحذف
if (isset($_GET['delete']) && $auth->hasRole('admin')) {
    $id = (int)$_GET['delete'];
    
    // منع حذف المستخدم الحالي
    if ($id == $_SESSION['user_id']) {
        $message = '<div class="alert alert-error">لا يمكنك حذف حسابك الخاص</div>';
    } else {
        try {
            $db->query("DELETE FROM users WHERE id = ?", [$id]);
            $message = '<div class="alert alert-success">تم حذف المستخدم بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// جلب بيانات المستخدم للتعديل
$edit_user = null;
if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    $edit_user = $db->fetchOne("SELECT * FROM users WHERE id = ?", [$edit_id]);
    
    // التحقق من الصلاحية
    if ($edit_user && (!$auth->belongsToCollege($edit_user['college_id']) && !$auth->hasRole('admin'))) {
        $edit_user = null;
    }
}

// جلب المستخدمين
if ($auth->hasRole('admin')) {
    $users = $db->fetchAll(
        "SELECT u.*, c.name_ar as college_name 
         FROM users u 
         JOIN colleges c ON u.college_id = c.id 
         ORDER BY u.role, u.full_name_ar"
    );
} else {
    $users = $db->fetchAll(
        "SELECT u.*, c.name_ar as college_name 
         FROM users u 
         JOIN colleges c ON u.college_id = c.id 
         WHERE u.college_id = ?
         ORDER BY u.role, u.full_name_ar",
        [$_SESSION['college_id']]
    );
}

// جلب الكليات
$colleges = $auth->hasRole('admin') 
    ? $db->fetchAll("SELECT * FROM colleges ORDER BY name_ar")
    : [['id' => $_SESSION['college_id'], 'name_ar' => $_SESSION['college_name']]];
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المستخدمين</title>
    <?php include __DIR__ . '/includes/compatibility.php'; ?>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة المستخدمين</h2>
            <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة مستخدم</button>
        </div>
        
        <?php echo $message; ?>
        
        <div id="addForm" class="card" style="display:<?php echo $edit_user ? 'none' : 'none'; ?>; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة مستخدم جديد</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>اسم المستخدم</label>
                    <input type="text" name="username" required>
                </div>
                <div class="form-group">
                    <label>كلمة المرور</label>
                    <input type="password" name="password" required>
                </div>
                <div class="form-group">
                    <label>الاسم الكامل (عربي)</label>
                    <input type="text" name="full_name_ar" required>
                </div>
                <div class="form-group">
                    <label>الاسم الكامل (إنجليزي)</label>
                    <input type="text" name="full_name_en">
                </div>
                <div class="form-group">
                    <label>البريد الإلكتروني</label>
                    <input type="email" name="email">
                </div>
                <?php if ($auth->hasRole('admin')): ?>
                <div class="form-group">
                    <label>الكلية</label>
                    <select name="college_id" required>
                        <?php foreach ($colleges as $college): ?>
                            <option value="<?php echo $college['id']; ?>"><?php echo htmlspecialchars($college['name_ar']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php else: ?>
                    <input type="hidden" name="college_id" value="<?php echo $_SESSION['college_id']; ?>">
                <?php endif; ?>
                <div class="form-group">
                    <label>الدور</label>
                    <select name="role" required>
                        <option value="">اختر الدور</option>
                        <?php foreach ($available_roles as $role): ?>
                            <option value="<?php echo $role; ?>"><?php 
                                $role_names = [
                                    'admin' => 'مدير عام',
                                    'college_admin' => 'مدير كلية',
                                    'registrar' => 'مسجل',
                                    'instructor' => 'أستاذ',
                                    'student' => 'طالب'
                                ];
                                echo $role_names[$role] ?? $role;
                            ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <?php if ($edit_user): ?>
        <div id="editForm" class="card" style="margin-bottom: 20px;">
            <div class="card-header">
                <h3>تعديل المستخدم</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $edit_user['id']; ?>">
                <div class="form-group">
                    <label>اسم المستخدم</label>
                    <input type="text" name="username" value="<?php echo htmlspecialchars($edit_user['username']); ?>" required>
                </div>
                <div class="form-group">
                    <label>كلمة المرور (اتركه فارغاً إذا لم ترد تغييره)</label>
                    <input type="password" name="password">
                </div>
                <div class="form-group">
                    <label>الاسم الكامل (عربي)</label>
                    <input type="text" name="full_name_ar" value="<?php echo htmlspecialchars($edit_user['full_name_ar']); ?>" required>
                </div>
                <div class="form-group">
                    <label>الاسم الكامل (إنجليزي)</label>
                    <input type="text" name="full_name_en" value="<?php echo htmlspecialchars($edit_user['full_name_en']); ?>">
                </div>
                <div class="form-group">
                    <label>البريد الإلكتروني</label>
                    <input type="email" name="email" value="<?php echo htmlspecialchars($edit_user['email']); ?>">
                </div>
                <?php if ($auth->hasRole('admin')): ?>
                <div class="form-group">
                    <label>الكلية</label>
                    <select name="college_id" required>
                        <?php foreach ($colleges as $college): ?>
                            <option value="<?php echo $college['id']; ?>" <?php echo $college['id'] == $edit_user['college_id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($college['name_ar']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php else: ?>
                    <input type="hidden" name="college_id" value="<?php echo $_SESSION['college_id']; ?>">
                <?php endif; ?>
                <div class="form-group">
                    <label>الدور</label>
                    <select name="role" required>
                        <?php foreach ($available_roles as $role): ?>
                            <option value="<?php echo $role; ?>" <?php echo $role == $edit_user['role'] ? 'selected' : ''; ?>>
                                <?php 
                                $role_names = [
                                    'admin' => 'مدير عام',
                                    'college_admin' => 'مدير كلية',
                                    'registrar' => 'مسجل',
                                    'instructor' => 'أستاذ',
                                    'student' => 'طالب'
                                ];
                                echo $role_names[$role] ?? $role;
                            ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" <?php echo $edit_user['is_active'] ? 'checked' : ''; ?>> 
                        نشط
                    </label>
                </div>
                <button type="submit" class="btn btn-success">تحديث</button>
                <a href="users.php" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
        <?php endif; ?>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>اسم المستخدم</th>
                        <th>الاسم الكامل</th>
                        <th>الكلية</th>
                        <th>الدور</th>
                        <th>البريد الإلكتروني</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo htmlspecialchars($user['full_name_ar']); ?></td>
                            <td><?php echo htmlspecialchars($user['college_name']); ?></td>
                            <td><?php 
                                $role_names = [
                                    'admin' => 'مدير عام',
                                    'college_admin' => 'مدير كلية',
                                    'registrar' => 'مسجل',
                                    'instructor' => 'أستاذ',
                                    'student' => 'طالب'
                                ];
                                echo $role_names[$user['role']] ?? $user['role'];
                            ?></td>
                            <td><?php echo htmlspecialchars($user['email'] ?? '-'); ?></td>
                            <td><?php echo $user['is_active'] ? 'نشط' : 'غير نشط'; ?></td>
                            <td>
                                <a href="?edit=<?php echo $user['id']; ?>" class="btn btn-success">تعديل</a>
                                <?php if ($auth->hasRole('admin') && $user['id'] != $_SESSION['user_id']): ?>
                                    <a href="?delete=<?php echo $user['id']; ?>" 
                                       onclick="return confirm('هل أنت متأكد من حذف هذا المستخدم؟')" 
                                       class="btn btn-danger">حذف</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

