<?php
/**
 * الشهادة الجامعية (شهادة التخرج)
 * University Certificate (Graduation Certificate)
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();

$student_id = isset($_GET['student_id']) ? (int)$_GET['student_id'] : 0;

// إذا كان طالب، استخدم معرفه
if ($auth->hasRole('student')) {
    $user = $auth->getCurrentUser();
    $student = $db->fetchOne("SELECT id FROM students WHERE user_id = ?", [$user['id']]);
    if ($student) {
        $student_id = $student['id'];
    }
}

if (!$student_id) {
    header('Location: dashboard.php');
    exit;
}

// التحقق من الصلاحيات
if (!$auth->canAccessStudent($student_id) && !$auth->hasRole('admin')) {
    header('Location: dashboard.php');
    exit;
}

// معالجة رفع الشعار
$upload_message = '';
$upload_message_type = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo']) && isset($_POST['upload_type']) && $_POST['upload_type'] === 'logo') {
    // التحقق من الصلاحيات (فقط للمديرين)
    if ($auth->hasRole('admin') || $auth->hasRole('college_admin')) {
        // إنشاء جدول settings إذا لم يكن موجوداً
        try {
            $db->query("SELECT 1 FROM settings LIMIT 1");
        } catch (Exception $e) {
            $db->query("CREATE TABLE IF NOT EXISTS settings (
                setting_key VARCHAR(255) PRIMARY KEY,
                setting_value TEXT,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        }
        
        $upload_dir = __DIR__ . '/assets/images/logo/';
        
        // إنشاء المجلد إذا لم يكن موجوداً
        if (!file_exists($upload_dir)) {
            @mkdir($upload_dir, 0777, true);
        }
        
        $file = $_FILES['logo'];
        
        // التحقق من وجود ملف
        if ($file['error'] === UPLOAD_ERR_OK) {
            $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/svg+xml'];
            $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'svg'];
            
            // محاولة الحصول على نوع MIME بطريقة آمنة
            $file_type = null;
            if (function_exists('finfo_open')) {
                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                if ($finfo) {
                    $file_type = finfo_file($finfo, $file['tmp_name']);
                    finfo_close($finfo);
                }
            }
            if (!$file_type && function_exists('mime_content_type')) {
                $file_type = mime_content_type($file['tmp_name']);
            }
            
            $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            $extension_valid = in_array($extension, $allowed_extensions);
            
            $file_valid = false;
            if ($file_type && in_array($file_type, $allowed_types)) {
                $file_valid = true;
            } elseif (!$file_type && $extension_valid) {
                $file_valid = true;
            }
            
            if (!$file_valid) {
                $upload_message = 'نوع الملف غير مدعوم. يرجى رفع صورة (JPG, PNG, GIF, SVG)';
                $upload_message_type = 'error';
            } elseif ($file['size'] > 5 * 1024 * 1024) {
                $upload_message = 'حجم الملف كبير جداً. الحد الأقصى 5MB';
                $upload_message_type = 'error';
            } else {
                $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
                $filename = 'university_logo_' . time() . '.' . $extension;
                $file_path = $upload_dir . $filename;
                
                // حذف الشعار القديم إذا كان موجوداً
                $current_logo = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'university_logo_path'");
                if ($current_logo && !empty($current_logo['setting_value']) && file_exists(__DIR__ . '/' . $current_logo['setting_value'])) {
                    @unlink(__DIR__ . '/' . $current_logo['setting_value']);
                }
                
                if (move_uploaded_file($file['tmp_name'], $file_path)) {
                    $relative_path = 'assets/images/logo/' . $filename;
                    $db->query(
                        "INSERT INTO settings (setting_key, setting_value) VALUES ('university_logo_path', ?)
                         ON DUPLICATE KEY UPDATE setting_value = ?",
                        [$relative_path, $relative_path]
                    );
                    $upload_message = 'تم رفع الشعار بنجاح';
                    $upload_message_type = 'success';
                } else {
                    $upload_message = 'فشل رفع الملف. يرجى المحاولة مرة أخرى';
                    $upload_message_type = 'error';
                }
            }
        } else {
            $upload_message = 'حدث خطأ أثناء رفع الملف';
            $upload_message_type = 'error';
        }
        
        // إعادة التوجيه لتجنب إعادة إرسال النموذج
        header("Location: university_certificate.php?student_id=" . $student_id . "&msg=" . urlencode($upload_message) . "&msg_type=" . $upload_message_type);
        exit;
    }
}

// معالجة رفع صورة الطالب
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['student_photo']) && isset($_POST['upload_type']) && $_POST['upload_type'] === 'student_photo') {
    $upload_dir = __DIR__ . '/uploads/students/';
    
    // إنشاء المجلد إذا لم يكن موجوداً
    if (!file_exists($upload_dir)) {
        @mkdir($upload_dir, 0777, true);
    }
    
    $file = $_FILES['student_photo'];
    
    // التحقق من وجود ملف
    if ($file['error'] === UPLOAD_ERR_OK) {
        $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        
        // محاولة الحصول على نوع MIME بطريقة آمنة
        $file_type = null;
        if (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            if ($finfo) {
                $file_type = finfo_file($finfo, $file['tmp_name']);
                finfo_close($finfo);
            }
        }
        if (!$file_type && function_exists('mime_content_type')) {
            $file_type = mime_content_type($file['tmp_name']);
        }
        
        $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $extension_valid = in_array($extension, $allowed_extensions);
        
        $file_valid = false;
        if ($file_type && in_array($file_type, $allowed_types)) {
            $file_valid = true;
        } elseif (!$file_type && $extension_valid) {
            $file_valid = true;
        }
        
        if (!$file_valid) {
            $upload_message = 'نوع الملف غير مدعوم. يرجى رفع صورة (JPG, PNG, GIF)';
            $upload_message_type = 'error';
        } elseif ($file['size'] > 5 * 1024 * 1024) {
            $upload_message = 'حجم الملف كبير جداً. الحد الأقصى 5MB';
            $upload_message_type = 'error';
        } else {
            $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
            $filename = 'student_' . $student_id . '_' . time() . '.' . $extension;
            $file_path = $upload_dir . $filename;
            
            // جلب معلومات الطالب (مؤقتاً)
            $temp_student = $db->fetchOne("SELECT photo_path FROM students WHERE id = ?", [$student_id]);
            
            // حذف الصورة القديمة إذا كانت موجودة
            if ($temp_student && !empty($temp_student['photo_path']) && file_exists(__DIR__ . '/' . $temp_student['photo_path'])) {
                @unlink(__DIR__ . '/' . $temp_student['photo_path']);
            }
            
            if (move_uploaded_file($file['tmp_name'], $file_path)) {
                $relative_path = 'uploads/students/' . $filename;
                $db->query(
                    "UPDATE students SET photo_path = ? WHERE id = ?",
                    [$relative_path, $student_id]
                );
                $upload_message = 'تم رفع صورة الطالب بنجاح';
                $upload_message_type = 'success';
            } else {
                $upload_message = 'فشل رفع الملف. يرجى المحاولة مرة أخرى';
                $upload_message_type = 'error';
            }
        }
    } else {
        $upload_message = 'حدث خطأ أثناء رفع الملف';
        $upload_message_type = 'error';
    }
    
    // إعادة التوجيه لتجنب إعادة إرسال النموذج
    header("Location: university_certificate.php?student_id=" . $student_id . "&msg=" . urlencode($upload_message) . "&msg_type=" . $upload_message_type);
    exit;
}

// جلب رسالة الرفع من URL (بعد إعادة التوجيه)
if (isset($_GET['msg']) && isset($_GET['msg_type'])) {
    $upload_message = urldecode($_GET['msg']);
    $upload_message_type = $_GET['msg_type'];
}

// جلب معلومات الطالب
$student = $db->fetchOne(
    "SELECT s.*, m.name_ar as major_name, c.name_ar as college_name
     FROM students s
     JOIN majors m ON s.major_id = m.id
     JOIN colleges c ON s.college_id = c.id
     WHERE s.id = ?",
    [$student_id]
);

if (!$student) {
    header('Location: dashboard.php');
    exit;
}

// جلب المعدل التراكمي النهائي
$final_cgpa = $db->fetchOne(
    "SELECT * FROM cumulative_gpas WHERE student_id = ?",
    [$student_id]
);

// إذا لم يكن هناك معدل تراكمي محفوظ، نحسبه
if (!$final_cgpa) {
    require_once __DIR__ . '/classes/GradeCalculator.php';
    $calculator = new GradeCalculator();
    $calculator->calculateCumulativeGPA($student_id);
    $final_cgpa = $db->fetchOne(
        "SELECT * FROM cumulative_gpas WHERE student_id = ?",
        [$student_id]
    );
}

// حساب التقدير النهائي (المعدل من 5)
function getGradeText($gpa, $failed_credits = 0) {
    // إذا كان المعدل أقل من 1.5: فصل
    if ($gpa < 1.5) {
        return 'فصل';
    }
    // إذا كان المعدل >= 1.5 و < 2.5: إعادة السنة
    elseif ($gpa >= 1.5 && $gpa < 2.5) {
        return 'إعادة السنة';
    }
    // إذا كان المعدل >= 2.5 و < 3: مقبول
    elseif ($gpa >= 2.5 && $gpa < 3) {
        // إذا رسب في مواد: ملاحق
        if ($failed_credits > 0) {
            return 'ملاحق';
        }
        return 'مقبول';
    }
    // إذا كان المعدل >= 3 و < 3.5: جيد
    elseif ($gpa >= 3 && $gpa < 3.5) {
        // إذا رسب في مواد: ملاحق
        if ($failed_credits > 0) {
            return 'ملاحق';
        }
        return 'جيد';
    }
    // إذا كان المعدل >= 3.5 و < 4: جيد جداً
    elseif ($gpa >= 3.5 && $gpa < 4) {
        // إذا رسب في مواد: ملاحق
        if ($failed_credits > 0) {
            return 'ملاحق';
        }
        return 'جيد جداً';
    }
    // إذا كان المعدل >= 4 و <= 5: ممتاز
    elseif ($gpa >= 4 && $gpa <= 5) {
        return 'ممتاز';
    }
    // حالات أخرى
    else {
        return 'مقبول';
    }
}

$final_grade_text = '-';
if ($final_cgpa && isset($final_cgpa['cgpa']) && $final_cgpa['cgpa'] > 0) {
    $final_grade_text = getGradeText($final_cgpa['cgpa']);
}

// جلب شعار الجامعة
$university_logo_path = null;
try {
    $logo_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'university_logo_path'");
    
    if ($logo_setting && !empty($logo_setting['setting_value'])) {
        $logo_path_raw = trim($logo_setting['setting_value']);
        
        // تنظيف المسار من المسافات والأحرف غير المرغوب فيها
        $logo_path_raw = str_replace(['\\', '/'], DIRECTORY_SEPARATOR, $logo_path_raw);
        $logo_path_raw = ltrim($logo_path_raw, '/\\');
        
        // بناء المسار الكامل
        $full_path = __DIR__ . DIRECTORY_SEPARATOR . $logo_path_raw;
        
        // التحقق من وجود الملف
        if (file_exists($full_path) && is_file($full_path) && filesize($full_path) > 0) {
            // استخدام المسار النسبي للصورة (كما هو محفوظ في قاعدة البيانات)
            $university_logo_path = str_replace('\\', '/', $logo_path_raw); // تحويل لمسار URL
        } else {
            error_log("University logo file not found or empty: " . $full_path);
        }
    }
} catch (Exception $e) {
    $university_logo_path = null;
    error_log("Error loading university logo: " . $e->getMessage());
}

// التحقق من وجود حقل photo_path في جدول students وإضافته إذا لم يكن موجوداً
try {
    $db->query("SELECT photo_path FROM students LIMIT 1");
} catch (Exception $e) {
    // إضافة الحقل إذا لم يكن موجوداً
    try {
        $db->query("ALTER TABLE students ADD COLUMN photo_path VARCHAR(255) NULL AFTER graduation_date");
    } catch (Exception $e2) {
        // تجاهل الخطأ إذا كان الحقل موجوداً بالفعل
    }
}

// جلب صورة الطالب
$student_photo_path = isset($student['photo_path']) && !empty($student['photo_path']) ? $student['photo_path'] : null;

// جلب أسماء وأوصاف المسؤولين للتوقيعات من قاعدة البيانات
try {
    $registrar_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'registrar_name'");
    $registrar_title_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'registrar_title'");
    $academic_affairs_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'academic_affairs_name'");
    $academic_affairs_title_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'academic_affairs_title'");
    $dean_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'dean_name'");
    $dean_title_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'dean_title'");
    
    $registrar_name = $registrar_setting ? $registrar_setting['setting_value'] : 'مسجل الكلية';
    $registrar_title = $registrar_title_setting ? $registrar_title_setting['setting_value'] : 'مسجل الكلية';
    $academic_affairs_name = $academic_affairs_setting ? $academic_affairs_setting['setting_value'] : 'أمين الشؤون العلمية';
    $academic_affairs_title = $academic_affairs_title_setting ? $academic_affairs_title_setting['setting_value'] : 'أمين الشؤون العلمية';
    $dean_name = $dean_setting ? $dean_setting['setting_value'] : 'عميد الكلية';
    $dean_title = $dean_title_setting ? $dean_title_setting['setting_value'] : 'عميد الكلية';
} catch (Exception $e) {
    // في حالة عدم وجود جدول settings، استخدم القيم الافتراضية
    $registrar_name = 'مسجل الكلية';
    $registrar_title = 'مسجل الكلية';
    $academic_affairs_name = 'أمين الشؤون العلمية';
    $academic_affairs_title = 'أمين الشؤون العلمية';
    $dean_name = 'عميد الكلية';
    $dean_title = 'عميد الكلية';
}

// تاريخ التخرج (يمكن استخدام تاريخ التخرج من قاعدة البيانات أو تاريخ اليوم)
$graduation_date = $student['graduation_date'] ? date('Y-m-d', strtotime($student['graduation_date'])) : date('Y-m-d');
$graduation_date_ar = date('Y/m/d', strtotime($graduation_date));
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الشهادة الجامعية - <?php echo htmlspecialchars($student['full_name_ar']); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        @media print {
            body {
                margin: 0;
                padding: 0;
            }
            .no-print {
                display: none;
            }
            .certificate-container {
                box-shadow: none;
                border: none;
            }
            @page {
                size: A4 landscape;
                margin: 20mm;
            }
        }
        
        .certificate-container {
            max-width: 297mm;
            min-height: 210mm;
            margin: 20px auto;
            padding: 40px;
            background: white;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            border: 5px solid #667eea;
            position: relative;
        }
        
        .certificate-header {
            text-align: center;
            border-bottom: 3px solid #667eea;
            padding-bottom: 20px;
            margin-bottom: 40px;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .certificate-header-content {
            flex: 1;
            text-align: center;
        }
        
        .certificate-header h1 {
            color: #667eea;
            font-size: 32px;
            margin: 10px 0;
            font-weight: bold;
        }
        
        .certificate-header h2 {
            color: #333;
            font-size: 24px;
            margin: 5px 0;
        }
        
        .logo-frame {
            width: 120px;
            height: 120px;
            border: 3px solid #667eea;
            border-radius: 8px;
            padding: 5px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            position: relative;
        }
        
        .logo-frame img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }
        
        .upload-overlay {
            position: relative;
        }
        
        .upload-form-inline {
            position: absolute;
            bottom: -45px;
            left: 50%;
            transform: translateX(-50%);
            width: auto;
            text-align: center;
            z-index: 1000;
            white-space: nowrap;
            background: rgba(255, 255, 255, 0.95);
            padding: 5px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        }
        
        .upload-form-inline input[type="file"] {
            display: none;
        }
        
        .upload-form-inline label {
            display: inline-block;
            padding: 8px 15px;
            background: #667eea;
            color: white !important;
            border-radius: 5px;
            cursor: pointer;
            font-size: 12px;
            font-weight: bold;
            margin: 0;
            transition: background 0.3s;
            white-space: nowrap;
            border: none;
        }
        
        .upload-form-inline label:hover {
            background: #5568d3;
        }
        
        .logo-frame {
            position: relative;
            margin-bottom: 50px;
        }
        
        .logo-frame .upload-overlay {
            width: 100%;
            height: 100%;
        }
        
        @media print {
            .upload-form-inline {
                display: none !important;
            }
            .logo-frame {
                margin-bottom: 0;
            }
        }
        
        .student-photo-frame {
            width: 120px;
            height: 150px;
            border: 3px solid #667eea;
            border-radius: 8px;
            padding: 5px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            position: relative;
        }
        
        .student-photo-frame img {
            max-width: 100%;
            max-height: 100%;
            object-fit: cover;
        }
        
        .student-photo-frame {
            position: relative;
            margin-bottom: 50px;
        }
        
        .student-photo-frame .upload-overlay {
            width: 100%;
            height: 100%;
        }
        
        @media print {
            .student-photo-frame {
                margin-bottom: 0;
            }
        }
        
        .empty-frame {
            background: #f5f5f5;
            color: #999;
            font-size: 12px;
            text-align: center;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .certificate-body {
            text-align: center;
            padding: 40px 20px;
            line-height: 2.5;
            font-size: 18px;
            min-height: 300px;
        }
        
        .certificate-text {
            margin: 30px 0;
            text-align: justify;
            text-align-last: center;
            direction: rtl;
        }
        
        .student-name-highlight {
            font-size: 22px;
            font-weight: bold;
            color: #667eea;
            display: inline-block;
            margin: 0 5px;
        }
        
        .major-name-highlight {
            font-size: 20px;
            font-weight: bold;
            color: #667eea;
            display: inline-block;
            margin: 0 5px;
        }
        
        .grade-highlight {
            font-size: 20px;
            font-weight: bold;
            color: #2196F3;
            display: inline-block;
            margin: 0 5px;
        }
        
        .date-highlight {
            font-size: 18px;
            font-weight: bold;
            color: #4CAF50;
            display: inline-block;
            margin: 0 5px;
        }
        
        .signatures {
            display: flex;
            justify-content: space-around;
            margin-top: 80px;
            padding-top: 40px;
            border-top: 2px solid #ddd;
        }
        
        .signature-box {
            text-align: center;
            width: 30%;
        }
        
        .signature-line {
            border-top: 2px solid #333;
            width: 250px;
            margin: 60px auto 15px;
        }
        
        .signature-name {
            font-weight: bold;
            margin-top: 10px;
            font-size: 16px;
        }
        
        .signature-title {
            margin-top: 5px;
            color: #666;
            font-size: 14px;
        }
        
        .certificate-footer {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 14px;
            color: #666;
        }
        
        .certificate-number {
            text-align: right;
        }
        
        .issue-date {
            text-align: left;
        }
        
        .print-button {
            text-align: center;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="no-print print-button">
            <button onclick="window.print()" class="btn btn-primary">🖨️ طباعة الشهادة</button>
            <a href="student_details.php?id=<?php echo $student_id; ?>" class="btn btn-secondary">العودة</a>
        </div>
        
        <?php if (!empty($upload_message)): ?>
            <div class="alert alert-<?php echo $upload_message_type === 'success' ? 'success' : 'error'; ?>" style="margin: 20px 0;">
                <?php echo htmlspecialchars($upload_message); ?>
            </div>
        <?php endif; ?>
        
        <!-- أزرار رفع الصور -->
        <div class="no-print" style="background: #f9f9f9; padding: 20px; margin: 20px 0; border-radius: 10px; border: 2px solid #667eea;">
            <h3 style="margin-top: 0; color: #667eea;">رفع الصور</h3>
            <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                <?php if ($auth->hasRole('admin') || $auth->hasRole('college_admin')): ?>
                    <div style="flex: 1; min-width: 250px;">
                        <form method="POST" enctype="multipart/form-data" style="margin: 0;">
                            <input type="hidden" name="upload_type" value="logo">
                            <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
                            <label for="logo-file-main" style="display: block; margin-bottom: 5px; font-weight: bold;">رفع شعار الجامعة:</label>
                            <input type="file" name="logo" id="logo-file-main" accept="image/jpeg,image/jpg,image/png,image/gif,image/svg+xml" style="margin-bottom: 10px; width: 100%; padding: 8px; border: 2px dashed #667eea; border-radius: 5px;">
                            <button type="submit" class="btn btn-primary" style="width: 100%;">📤 رفع الشعار</button>
                        </form>
                    </div>
                <?php endif; ?>
                
                <?php if ($auth->canAccessStudent($student_id) || $auth->hasRole('admin')): ?>
                    <div style="flex: 1; min-width: 250px;">
                        <form method="POST" enctype="multipart/form-data" style="margin: 0;">
                            <input type="hidden" name="upload_type" value="student_photo">
                            <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
                            <label for="student-photo-file-main" style="display: block; margin-bottom: 5px; font-weight: bold;">رفع صورة الطالب:</label>
                            <input type="file" name="student_photo" id="student-photo-file-main" accept="image/jpeg,image/jpg,image/png,image/gif" style="margin-bottom: 10px; width: 100%; padding: 8px; border: 2px dashed #667eea; border-radius: 5px;">
                            <button type="submit" class="btn btn-primary" style="width: 100%;">📤 رفع صورة الطالب</button>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
            <small style="display: block; margin-top: 10px; color: #666;">
                ملاحظة: يمكنك أيضاً استخدام الأزرار الموجودة داخل الأطر في الشهادة أدناه
            </small>
        </div>
        
        <div class="certificate-container">
            <!-- رأس الشهادة -->
            <div class="certificate-header">
                <!-- إطار شعار الجامعة (يسار) -->
                <div class="logo-frame upload-overlay">
                    <?php 
                    if ($university_logo_path && !empty($university_logo_path)): 
                        // تنظيف المسار للعرض في HTML
                        $logo_src = str_replace('\\', '/', $university_logo_path);
                        $logo_src = ltrim($logo_src, '/');
                        
                        // التحقق النهائي من وجود الملف
                        $logo_full_path = __DIR__ . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $logo_src);
                    ?>
                        <?php if (file_exists($logo_full_path) && is_file($logo_full_path) && filesize($logo_full_path) > 0): ?>
                            <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="شعار الجامعة" style="width: 100%; height: 100%; object-fit: contain; display: block;">
                        <?php else: ?>
                            <div class="empty-frame">شعار الجامعة</div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="empty-frame">شعار الجامعة</div>
                    <?php endif; ?>
                    
                    <?php if ($auth->hasRole('admin') || $auth->hasRole('college_admin')): ?>
                        <div class="upload-form-inline no-print">
                            <form method="POST" enctype="multipart/form-data" id="logo-upload-form">
                                <input type="hidden" name="upload_type" value="logo">
                                <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
                                <label for="logo-file">📷 اضغط لرفع شعار</label>
                                <input type="file" name="logo" id="logo-file" accept="image/jpeg,image/jpg,image/png,image/gif,image/svg+xml" onchange="document.getElementById('logo-upload-form').submit();">
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- محتوى العنوان -->
                <div class="certificate-header-content">
                    <h1 style="font-size: 18px;">جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology</h1>
                    <h2>الشهادة الجامعية</h2>
                    <h2>University Certificate</h2>
                </div>
                
                <!-- إطار صورة الطالب (يمين) -->
                <div class="student-photo-frame upload-overlay">
                    <?php if ($student_photo_path && file_exists(__DIR__ . '/' . $student_photo_path)): ?>
                        <img src="<?php echo htmlspecialchars($student_photo_path); ?>" alt="صورة الطالب">
                    <?php else: ?>
                        <div class="empty-frame">صورة الطالب</div>
                    <?php endif; ?>
                    
                    <?php if ($auth->canAccessStudent($student_id) || $auth->hasRole('admin')): ?>
                        <div class="upload-form-inline no-print">
                            <form method="POST" enctype="multipart/form-data" id="student-photo-upload-form">
                                <input type="hidden" name="upload_type" value="student_photo">
                                <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
                                <label for="student-photo-file">📷 اضغط لرفع صورة</label>
                                <input type="file" name="student_photo" id="student-photo-file" accept="image/jpeg,image/jpg,image/png,image/gif" onchange="document.getElementById('student-photo-upload-form').submit();">
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- نص الشهادة -->
            <div class="certificate-body">
                <div class="certificate-text">
                    <p style="font-size: 20px; line-height: 2.5; margin: 40px 0;">
                        نشهد نحن الموقعين أدناه بأن مجلس الأساتذة قد منح الطالب
                        <span class="student-name-highlight"><?php echo htmlspecialchars($student['full_name_ar']); ?></span>
                        درجة البكالوريوس في تخصص
                        <span class="major-name-highlight"><?php echo htmlspecialchars($student['major_name']); ?></span>
                        <?php if ($final_cgpa && $final_cgpa['cgpa'] > 0): ?>
                            بتقدير
                            <span class="grade-highlight"><?php echo $final_grade_text; ?></span>
                        <?php endif; ?>
                        بتاريخ
                        <span class="date-highlight"><?php echo $graduation_date_ar; ?></span>
                    </p>
                </div>
            </div>
            
            <!-- التوقيعات -->
            <div class="signatures">
                <div class="signature-box">
                    <div class="signature-line"></div>
                    <div class="signature-name"><?php echo htmlspecialchars($registrar_name); ?></div>
                    <div class="signature-title"><?php echo htmlspecialchars($registrar_title); ?></div>
                </div>
                <div class="signature-box">
                    <div class="signature-line"></div>
                    <div class="signature-name"><?php echo htmlspecialchars($academic_affairs_name); ?></div>
                    <div class="signature-title"><?php echo htmlspecialchars($academic_affairs_title); ?></div>
                </div>
                <div class="signature-box">
                    <div class="signature-line"></div>
                    <div class="signature-name"><?php echo htmlspecialchars($dean_name); ?></div>
                    <div class="signature-title"><?php echo htmlspecialchars($dean_title); ?></div>
                </div>
            </div>
            
            <!-- تذييل الشهادة -->
            <div class="certificate-footer">
                <div class="certificate-number">
                    <strong>رقم الشهادة:</strong> UNI-<?php echo date('Y'); ?>-<?php echo str_pad($student_id, 6, '0', STR_PAD_LEFT); ?>
                </div>
                <div class="issue-date">
                    <strong>تاريخ الإصدار:</strong> <?php echo date('Y/m/d'); ?>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

