<?php
/**
 * ملف اختبار لفحص صفحة تسجيل الطلاب
 * Test file to debug register_students_to_course.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

echo "<!DOCTYPE html><html lang='ar' dir='rtl'><head><meta charset='UTF-8'><title>اختبار الصفحة</title></head><body style='direction:rtl;padding:20px;font-family:Arial;'>";
echo "<h1>اختبار صفحة تسجيل الطلاب</h1>";

try {
    // 1. اختبار الاتصال بقاعدة البيانات
    echo "<h2>1. اختبار الاتصال بقاعدة البيانات:</h2>";
    $db = Database::getInstance();
    echo "✓ الاتصال بقاعدة البيانات نجح<br>";
    
    // 2. اختبار تسجيل الدخول
    echo "<h2>2. اختبار تسجيل الدخول:</h2>";
    $auth = new Auth();
    if ($auth->isLoggedIn()) {
        $user = $auth->getCurrentUser();
        echo "✓ مسجل دخول كـ: " . htmlspecialchars($user['full_name']) . "<br>";
        echo "✓ الدور: " . htmlspecialchars($user['role']) . "<br>";
        echo "✓ الكلية ID: " . ($user['college_id'] ?? 'غير محدد') . "<br>";
    } else {
        echo "✗ غير مسجل دخول - <a href='index.php'>سجل دخول أولاً</a><br>";
        exit;
    }
    
    // 3. اختبار البيانات المطلوبة
    echo "<h2>3. اختبار البيانات المطلوبة:</h2>";
    $course_id = isset($_GET['course_id']) ? (int)$_GET['course_id'] : 11;
    $semester_id = isset($_GET['semester_id']) ? (int)$_GET['semester_id'] : 3;
    
    echo "course_id = $course_id<br>";
    echo "semester_id = $semester_id<br>";
    
    // 4. اختبار جلب معلومات المادة
    echo "<h2>4. اختبار جلب معلومات المادة:</h2>";
    try {
        $course = $db->fetchOne(
            "SELECT c.*, m.college_id, m.id as major_id
             FROM courses c 
             JOIN majors m ON c.major_id = m.id 
             WHERE c.id = ?",
            [$course_id]
        );
        
        if ($course) {
            echo "✓ المادة موجودة: " . htmlspecialchars($course['name_ar']) . " (" . htmlspecialchars($course['code']) . ")<br>";
            echo "✓ major_id = " . $course['major_id'] . "<br>";
            echo "✓ college_id = " . $course['college_id'] . "<br>";
        } else {
            echo "✗ المادة غير موجودة (ID: $course_id)<br>";
            echo "<p>المواد المتاحة:</p><ul>";
            $all_courses = $db->fetchAll("SELECT id, code, name_ar FROM courses LIMIT 10");
            foreach ($all_courses as $c) {
                echo "<li>ID: {$c['id']} - {$c['code']} - {$c['name_ar']}</li>";
            }
            echo "</ul>";
            exit;
        }
    } catch (Exception $e) {
        echo "✗ خطأ في جلب المادة: " . htmlspecialchars($e->getMessage()) . "<br>";
        exit;
    }
    
    // 5. اختبار جلب معلومات الفصل
    echo "<h2>5. اختبار جلب معلومات الفصل:</h2>";
    try {
        $semester = $db->fetchOne("SELECT * FROM semesters WHERE id = ?", [$semester_id]);
        
        if ($semester) {
            echo "✓ الفصل موجود: فصل " . $semester['semester_number'] . " - " . htmlspecialchars($semester['academic_year']) . "<br>";
        } else {
            echo "✗ الفصل غير موجود (ID: $semester_id)<br>";
            echo "<p>الفصول المتاحة:</p><ul>";
            $all_semesters = $db->fetchAll("SELECT id, semester_number, academic_year FROM semesters LIMIT 10");
            foreach ($all_semesters as $s) {
                echo "<li>ID: {$s['id']} - فصل {$s['semester_number']} - {$s['academic_year']}</li>";
            }
            echo "</ul>";
            exit;
        }
    } catch (Exception $e) {
        echo "✗ خطأ في جلب الفصل: " . htmlspecialchars($e->getMessage()) . "<br>";
        exit;
    }
    
    // 6. اختبار جلب معلومات التخصص
    echo "<h2>6. اختبار جلب معلومات التخصص:</h2>";
    try {
        $major = $db->fetchOne("SELECT * FROM majors WHERE id = ?", [$course['major_id']]);
        
        if ($major) {
            echo "✓ التخصص موجود: " . htmlspecialchars($major['name_ar']) . "<br>";
        } else {
            echo "✗ التخصص غير موجود (ID: {$course['major_id']})<br>";
        }
    } catch (Exception $e) {
        echo "✗ خطأ في جلب التخصص: " . htmlspecialchars($e->getMessage()) . "<br>";
    }
    
    // 7. اختبار جلب الطلاب
    echo "<h2>7. اختبار جلب الطلاب:</h2>";
    $currentCollegeId = isset($_SESSION['college_id']) ? (int)$_SESSION['college_id'] : null;
    echo "currentCollegeId = " . ($currentCollegeId ?? 'null') . "<br>";
    
    try {
        if ($auth->hasRole('admin')) {
            $all_students = $db->fetchAll(
                "SELECT s.* FROM students s 
                 WHERE s.major_id = ?
                 ORDER BY s.status DESC, s.student_number",
                [$course['major_id']]
            );
            
            echo "✓ عدد الطلاب (admin): " . count($all_students) . "<br>";
            
            // اختبار COUNT - هذا هو المكان الذي يحدث فيه الخطأ
            echo "<h3>اختبار COUNT (هذا قد يسبب الخطأ):</h3>";
            $active_count_result = $db->fetchOne(
                "SELECT COUNT(*) as count FROM students s 
                 WHERE s.major_id = ? AND s.status = 'active'",
                [$course['major_id']]
            );
            
            if ($active_count_result === false || $active_count_result === null) {
                echo "✗ COUNT فشل - النتيجة: " . var_export($active_count_result, true) . "<br>";
            } else {
                echo "✓ COUNT نجح - النتيجة: ";
                var_dump($active_count_result);
                echo "<br>";
                $active_students_count = isset($active_count_result['count']) ? (int)$active_count_result['count'] : 0;
                echo "✓ عدد الطلاب النشطين: $active_students_count<br>";
            }
        } else {
            if ($currentCollegeId !== null) {
                $all_students = $db->fetchAll(
                    "SELECT s.* FROM students s 
                     WHERE s.major_id = ? AND s.college_id = ?
                     ORDER BY s.status DESC, s.student_number",
                    [$course['major_id'], $currentCollegeId]
                );
                
                echo "✓ عدد الطلاب (غير admin): " . count($all_students) . "<br>";
                
                // اختبار COUNT
                echo "<h3>اختبار COUNT (هذا قد يسبب الخطأ):</h3>";
                $active_count_result = $db->fetchOne(
                    "SELECT COUNT(*) as count FROM students s 
                     WHERE s.major_id = ? AND s.college_id = ? AND s.status = 'active'",
                    [$course['major_id'], $currentCollegeId]
                );
                
                if ($active_count_result === false || $active_count_result === null) {
                    echo "✗ COUNT فشل - النتيجة: " . var_export($active_count_result, true) . "<br>";
                } else {
                    echo "✓ COUNT نجح - النتيجة: ";
                    var_dump($active_count_result);
                    echo "<br>";
                    $active_students_count = isset($active_count_result['count']) ? (int)$active_count_result['count'] : 0;
                    echo "✓ عدد الطلاب النشطين: $active_students_count<br>";
                }
            } else {
                echo "✗ currentCollegeId = null<br>";
            }
        }
    } catch (Exception $e) {
        echo "✗ خطأ في جلب الطلاب: " . htmlspecialchars($e->getMessage()) . "<br>";
        echo "Stack trace:<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    }
    
    // 8. رابط للصفحة الحقيقية
    echo "<h2>8. رابط للصفحة الحقيقية:</h2>";
    echo "<a href='register_students_to_course.php?course_id=$course_id&semester_id=$semester_id' style='padding:10px;background:#4CAF50;color:white;text-decoration:none;border-radius:5px;'>افتح صفحة تسجيل الطلاب</a>";
    
} catch (Exception $e) {
    echo "<h2 style='color:red;'>خطأ عام:</h2>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

echo "</body></html>";
?>