<?php
/**
 * سكريبت متقدم لاختبار الاتصال بـ MySQL مع تجربة كلمات مرور متعددة
 * Advanced MySQL connection tester with multiple password attempts
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اختبار اتصال MySQL</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .content { padding: 30px; }
        .test-item {
            padding: 15px;
            margin: 10px 0;
            border-radius: 5px;
            border-right: 4px solid #ddd;
        }
        .success {
            background: #f1f8f4;
            border-right-color: #4caf50;
            color: #2e7d32;
        }
        .error {
            background: #ffebee;
            border-right-color: #f44336;
            color: #c62828;
        }
        .info {
            background: #e3f2fd;
            border-right-color: #2196f3;
            color: #1565c0;
        }
        code {
            background: #f4f4f4;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            color: #d63384;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px 5px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover { background: #5568d3; }
        .btn-success { background: #4caf50; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔍 اختبار اتصال MySQL</h1>
            <p>البحث عن كلمة المرور الصحيحة</p>
        </div>
        
        <div class="content">
            <?php
            $host = 'localhost';
            $user = 'root';
            $database = 'university_results';
            
            // قائمة موسعة من كلمات المرور
            $passwords = [
                '',           // فارغة
                'root',       // الأكثر شيوعاً
                'password',   
                '123456',
                'admin',
                'mysql',
                '1234',
                '12345',
                'root123',
                'password123',
                'admin123',
            ];
            
            echo '<h2>جارٍ تجربة كلمات المرور...</h2>';
            echo '<div style="margin: 20px 0;">';
            
            $found = false;
            $workingPassword = null;
            $connectionError = null;
            
            foreach ($passwords as $password) {
                $displayPassword = $password === '' ? '(فارغة)' : str_repeat('*', strlen($password));
                echo '<div class="test-item">';
                echo '<strong>تجربة:</strong> <code>' . htmlspecialchars($displayPassword) . '</code> ... ';
                
                try {
                    $dsn = "mysql:host=$host;charset=utf8mb4";
                    $options = [
                        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                        PDO::ATTR_TIMEOUT => 3,
                    ];
                    
                    $pdo = new PDO($dsn, $user, $password, $options);
                    
                    // محاولة الوصول إلى قاعدة البيانات
                    try {
                        $pdo->exec("USE `$database`");
                        echo '<span class="success">✓ نجح! قاعدة البيانات متاحة أيضاً.</span>';
                    } catch (PDOException $e) {
                        echo '<span class="success">✓ نجح الاتصال! (لكن قاعدة البيانات غير موجودة)</span>';
                    }
                    
                    $found = true;
                    $workingPassword = $password;
                    echo '</div>';
                    break;
                    
                } catch (PDOException $e) {
                    $errorCode = $e->getCode();
                    $errorMsg = $e->getMessage();
                    
                    if ($errorCode == 1045) {
                        echo '<span class="error">✗ فشل (Access denied)</span>';
                    } elseif ($errorCode == 2002) {
                        echo '<span class="error">✗ فشل (MySQL غير قيد التشغيل)</span>';
                        $connectionError = "MySQL غير قيد التشغيل";
                        break;
                    } else {
                        echo '<span class="error">✗ فشل (' . htmlspecialchars($errorMsg) . ')</span>';
                    }
                }
                echo '</div>';
            }
            
            echo '</div>';
            
            // عرض النتيجة
            if ($found) {
                echo '<div class="test-item success">';
                echo '<h2>✓ تم العثور على كلمة مرور صحيحة!</h2>';
                echo '<p><strong>كلمة المرور:</strong> <code>' . ($workingPassword === '' ? '(فارغة)' : htmlspecialchars($workingPassword)) . '</code></p>';
                echo '<p><strong>الخطوات التالية:</strong></p>';
                echo '<ol style="margin-right: 20px; margin-top: 10px;">';
                echo '<li>افتح ملف <code>config/database.php</code></li>';
                echo '<li>حدّث السطر 22 إلى:</li>';
                echo '</ol>';
                echo '<code style="display: block; padding: 10px; margin: 10px 0;">';
                echo "define('DB_PASS', " . ($workingPassword === '' ? "''" : "'" . htmlspecialchars($workingPassword) . "'") . ");";
                echo '</code>';
                echo '<p><a href="test_student_registration.php" class="btn btn-success">اختبار الاتصال الآن</a></p>';
                echo '</div>';
                
                // تحديث الملف تلقائياً إذا أمكن
                $dbFilePath = __DIR__ . '/config/database.php';
                if (is_writable($dbFilePath)) {
                    $dbFile = file_get_contents($dbFilePath);
                    $newPasswordValue = $workingPassword === '' ? "''" : "'" . addslashes($workingPassword) . "'";
                    
                    // البحث عن السطر الذي يحتوي على DB_PASS وتحديثه
                    $lines = explode("\n", $dbFile);
                    $updated = false;
                    foreach ($lines as $i => $line) {
                        if (preg_match("/define\s*\(\s*['\"]DB_PASS['\"]/", $line)) {
                            $lines[$i] = "define('DB_PASS', $newPasswordValue); // قم بتغيير هذه القيمة إلى كلمة مرور MySQL الخاصة بك";
                            $updated = true;
                            break;
                        }
                    }
                    
                    if ($updated) {
                        file_put_contents($dbFilePath, implode("\n", $lines));
                        echo '<div class="test-item info">';
                        echo '<p>✓ تم تحديث ملف <code>config/database.php</code> تلقائياً!</p>';
                        echo '<p>يمكنك الآن <a href="test_student_registration.php" class="btn btn-success" style="display: inline-block; margin-top: 10px;">اختبار الاتصال</a></p>';
                        echo '</div>';
                    }
                } else {
                    echo '<div class="test-item info">';
                    echo '<p>⚠ لا يمكن تحديث الملف تلقائياً (مشكلة في الصلاحيات). يرجى تحديثه يدوياً.</p>';
                    echo '</div>';
                }
                
            } else {
                echo '<div class="test-item error">';
                echo '<h2>✗ لم يتم العثور على كلمة مرور صحيحة</h2>';
                
                if ($connectionError) {
                    echo '<p><strong>المشكلة:</strong> ' . $connectionError . '</p>';
                    echo '<p><strong>الحل:</strong></p>';
                    echo '<ol style="margin-right: 20px;">';
                    echo '<li>افتح <strong>AppServ Control Panel</strong></li>';
                    echo '<li>تأكد من أن MySQL يعمل (Status: Running)</li>';
                    echo '<li>إذا لم يكن يعمل، اضغط <strong>Start</strong></li>';
                    echo '</ol>';
                } else {
                    echo '<p>جميع كلمات المرور الشائعة فشلت. يجب إعادة تعيين كلمة مرور MySQL.</p>';
                    echo '<p><strong>الحلول:</strong></p>';
                    echo '<ol style="margin-right: 20px;">';
                    echo '<li><strong>من AppServ Control Panel:</strong> ابحث عن خيار "MySQL Password" أو "Reset Password"</li>';
                    echo '<li><strong>استخدم السكريبت:</strong> <a href="reset_mysql_password.php">reset_mysql_password.php</a></li>';
                    echo '<li><strong>يدوياً:</strong> اتبع التعليمات في <code>RESET_MYSQL_PASSWORD_GUIDE.md</code></li>';
                    echo '</ol>';
                    echo '<p><a href="reset_mysql_password.php" class="btn">إعادة تعيين كلمة المرور</a></p>';
                }
                echo '</div>';
            }
            ?>
            
            <div class="test-item info" style="margin-top: 30px;">
                <h3>ملاحظات:</h3>
                <ul style="margin-right: 20px;">
                    <li>إذا تم العثور على كلمة مرور، سيتم تحديث <code>config/database.php</code> تلقائياً</li>
                    <li>يمكنك تحديث الملف يدوياً إذا لم يحدث التحديث التلقائي</li>
                    <li>بعد التحديث، اختبر الاتصال: <a href="test_student_registration.php">test_student_registration.php</a></li>
                </ul>
            </div>
        </div>
    </div>
</body>
</html>

