<?php
/**
 * سكريبت لاختبار الاتصال بقاعدة البيانات (واجهة سطر الأوامر)
 * Database Connection Test Script (CLI)
 * 
 * للاختبار الشامل مع واجهة HTML، استخدم: test_student_registration.php
 */

require_once __DIR__ . '/config/config.php';

echo "═══════════════════════════════════════════════════════════\n";
echo "   اختبار الاتصال بقاعدة البيانات\n";
echo "   Database Connection Test\n";
echo "═══════════════════════════════════════════════════════════\n\n";

// عرض إعدادات الاتصال
echo "إعدادات الاتصال:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "DB_HOST: " . (defined('DB_HOST') ? DB_HOST : 'غير معرّف') . "\n";
echo "DB_USER: " . (defined('DB_USER') ? DB_USER : 'غير معرّف') . "\n";
echo "DB_PASS: " . (defined('DB_PASS') ? (DB_PASS === '' ? '(فارغة)' : '(محددة)') : 'غير معرّف') . "\n";
echo "DB_NAME: " . (defined('DB_NAME') ? DB_NAME : 'غير معرّف') . "\n";
echo "\n";

try {
    $db = Database::getInstance();
    echo "✓ الاتصال بقاعدة البيانات نجح!\n\n";
    
    // التحقق من الجداول
    $tables = $db->fetchAll("SHOW TABLES");
    echo "الجداول الموجودة: " . count($tables) . "\n";
    if (count($tables) > 0) {
        echo "قائمة الجداول:\n";
        foreach ($tables as $table) {
            $tableName = array_values($table)[0];
            echo "  - $tableName\n";
        }
    }
    echo "\n";
    
    // التحقق من المستخدمين
    try {
        $users = $db->fetchAll("SELECT username, role, is_active FROM users");
        echo "المستخدمون: " . count($users) . "\n";
        if (count($users) > 0) {
            foreach ($users as $user) {
                $status = $user['is_active'] ? 'نشط' : 'غير نشط';
                echo "  - {$user['username']} ({$user['role']}) - $status\n";
            }
        }
        echo "\n";
    } catch (Exception $e) {
        echo "⚠ لا يمكن جلب بيانات المستخدمين: " . $e->getMessage() . "\n\n";
    }
    
    // التحقق من الكليات
    try {
        $colleges = $db->fetchAll("SELECT * FROM colleges");
        echo "الكليات: " . count($colleges) . "\n";
        if (count($colleges) > 0) {
            foreach ($colleges as $college) {
                echo "  - {$college['name_ar']} ({$college['code']})\n";
            }
        } else {
            echo "  ⚠ لا توجد كليات في قاعدة البيانات\n";
        }
        echo "\n";
    } catch (Exception $e) {
        echo "⚠ لا يمكن جلب بيانات الكليات: " . $e->getMessage() . "\n\n";
    }
    
    // التحقق من الطلاب
    try {
        $students = $db->fetchAll("SELECT COUNT(*) as count FROM students");
        $studentCount = $students[0]['count'] ?? 0;
        echo "الطلاب المسجلين: $studentCount\n\n";
    } catch (Exception $e) {
        echo "⚠ لا يمكن جلب عدد الطلاب: " . $e->getMessage() . "\n\n";
    }
    
    // اختبار تسجيل الدخول
    echo "───────────────────────────────────────────────────────────\n";
    echo "اختبار تسجيل الدخول:\n";
    echo "───────────────────────────────────────────────────────────\n";
    if (file_exists(__DIR__ . '/classes/Auth.php')) {
        require_once __DIR__ . '/classes/Auth.php';
        $auth = new Auth();
        
        if ($auth->login('admin', 'admin123')) {
            echo "✓ تسجيل الدخول نجح!\n";
            echo "  اسم المستخدم: admin\n";
            echo "  كلمة المرور: admin123\n";
        } else {
            echo "✗ تسجيل الدخول فشل!\n";
            echo "  يرجى تشغيل fix_admin_password.php لإصلاح كلمة المرور\n";
        }
    } else {
        echo "⚠ ملف Auth.php غير موجود\n";
    }
    
    echo "\n";
    echo "═══════════════════════════════════════════════════════════\n";
    echo "✓ جميع الاختبارات الأساسية اكتملت بنجاح!\n";
    echo "═══════════════════════════════════════════════════════════\n";
    
} catch (PDOException $e) {
    echo "✗ خطأ في الاتصال: " . $e->getMessage() . "\n\n";
    echo "═══════════════════════════════════════════════════════════\n";
    echo "إرشادات حل المشكلة:\n";
    echo "═══════════════════════════════════════════════════════════\n";
    echo "1. تأكد من أن MySQL يعمل (تحقق من AppServ Control Panel)\n";
    echo "2. تأكد من وجود قاعدة البيانات '" . (defined('DB_NAME') ? DB_NAME : 'university_results') . "'\n";
    echo "3. تحقق من إعدادات config/database.php:\n";
    echo "   - DB_HOST = 'localhost'\n";
    echo "   - DB_USER = 'root'\n";
    echo "   - DB_PASS = 'root' أو '' (حسب إعدادات AppServ)\n";
    echo "   - DB_NAME = 'university_results'\n";
    echo "\n";
    echo "في AppServ، كلمة مرور root الافتراضية عادة تكون:\n";
    echo "  - 'root' (الأكثر شيوعاً)\n";
    echo "  - '' (فارغة - إذا تم التثبيت بدون كلمة مرور)\n";
    echo "\n";
    echo "لإنشاء قاعدة البيانات:\n";
    echo "  mysql -u root -p < database/schema.sql\n";
    echo "\n";
    echo "للاختبار الشامل مع واجهة HTML:\n";
    echo "  افتح: test_student_registration.php في المتصفح\n";
    echo "═══════════════════════════════════════════════════════════\n";
}

