<?php
/**
 * ملف اختبار بسيط للتحقق من عمل PHP و Apache
 * Simple test file to verify PHP and Apache are working
 */
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>اختبار PHP</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f0f0f0;
        }
        .success {
            background: #4caf50;
            color: white;
            padding: 20px;
            border-radius: 5px;
            margin: 10px 0;
        }
        .info {
            background: #2196f3;
            color: white;
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
        }
        pre {
            background: #333;
            color: #0f0;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
        }
    </style>
</head>
<body>
    <h1>اختبار PHP و Apache</h1>
    
    <div class="success">
        <h2>✓ PHP يعمل بنجاح!</h2>
        <p>إصدار PHP: <?php echo phpversion(); ?></p>
    </div>
    
    <div class="info">
        <h3>معلومات الخادم:</h3>
        <ul>
            <li>الخادم: <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'غير معروف'; ?></li>
            <li>المسار: <?php echo __DIR__; ?></li>
            <li>الملف الحالي: <?php echo __FILE__; ?></li>
        </ul>
    </div>
    
    <div class="info">
        <h3>الملفات المتاحة للاختبار:</h3>
        <ul>
            <li><a href="find_mysql_password.php" style="color: white;">find_mysql_password.php</a> - للعثور على كلمة مرور MySQL</li>
            <li><a href="test_student_registration.php" style="color: white;">test_student_registration.php</a> - اختبار شامل</li>
            <li><a href="test_connection.php" style="color: white;">test_connection.php</a> - اختبار الاتصال</li>
        </ul>
    </div>
    
    <h3>معلومات PHP:</h3>
    <pre><?php
    echo "PHP Version: " . phpversion() . "\n";
    echo "Server: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "\n";
    echo "Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown') . "\n";
    echo "Script Name: " . ($_SERVER['SCRIPT_NAME'] ?? 'Unknown') . "\n";
    echo "Request URI: " . ($_SERVER['REQUEST_URI'] ?? 'Unknown') . "\n";
    ?></pre>
    
    <h3>إعدادات PHP المهمة:</h3>
    <pre><?php
    echo "PDO Available: " . (extension_loaded('pdo') ? 'Yes' : 'No') . "\n";
    echo "PDO MySQL: " . (extension_loaded('pdo_mysql') ? 'Yes' : 'No') . "\n";
    echo "Error Reporting: " . error_reporting() . "\n";
    echo "Display Errors: " . ini_get('display_errors') . "\n";
    ?></pre>
    
    <p><a href="index.php">← العودة للصفحة الرئيسية</a></p>
</body>
</html>

