<?php
/**
 * صفحة قوالب رفع البيانات
 * Templates Page
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin') && !$auth->hasRole('registrar'))) {
    header('Location: index.php');
    exit;
}

require_once __DIR__ . '/includes/header.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>قوالب رفع البيانات</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .templates-container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 20px;
        }
        
        .template-card {
            background: white;
            border-radius: 12px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 3px 15px rgba(0,0,0,0.1);
            border-right: 4px solid #667eea;
        }
        
        .template-card h2 {
            color: #667eea;
            margin-top: 0;
            margin-bottom: 20px;
            font-size: 1.8em;
        }
        
        .template-card h3 {
            color: #333;
            margin-top: 25px;
            margin-bottom: 15px;
            font-size: 1.3em;
        }
        
        .template-info {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .template-info ul {
            margin-right: 20px;
            margin-top: 10px;
        }
        
        .template-info li {
            margin: 8px 0;
        }
        
        .btn-download {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 25px;
            font-weight: bold;
            margin: 10px 10px 10px 0;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-guide {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
            color: white;
            text-decoration: none;
            border-radius: 25px;
            font-weight: bold;
            margin: 10px 10px 10px 0;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(76, 175, 80, 0.3);
        }
        
        .btn-guide:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(76, 175, 80, 0.4);
        }
        
        .example-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            background: white;
        }
        
        .example-table th {
            background: #667eea;
            color: white;
            padding: 12px;
            text-align: center;
            border: 1px solid #555;
        }
        
        .example-table td {
            padding: 10px;
            text-align: center;
            border: 1px solid #ddd;
        }
        
        .example-table tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .icon-large {
            font-size: 3em;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <?php require_once __DIR__ . '/includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1>📥 قوالب رفع البيانات</h1>
            <a href="dashboard.php" class="btn btn-secondary">العودة للوحة التحكم</a>
        </div>
        
        <div class="templates-container">
            <!-- قالب رفع الطلاب -->
            <div class="template-card">
                <div style="text-align: center; margin-bottom: 20px;">
                    <div class="icon-large">👥</div>
                </div>
                <h2>قالب رفع الطلاب من Excel</h2>
                
                <div class="template-info">
                    <h3>📋 معلومات القالب</h3>
                    <p><strong>الوصف:</strong> هذا القالب يستخدم لرفع بيانات الطلاب من ملف Excel أو CSV إلى النظام.</p>
                    
                    <h4>الأعمدة المطلوبة:</h4>
                    <ul>
                        <li><strong>student_number</strong> (مطلوب): الرقم الجامعي</li>
                        <li><strong>full_name_ar</strong> (مطلوب): الاسم الكامل بالعربية</li>
                        <li><strong>full_name_en</strong> (اختياري): الاسم الكامل بالإنجليزية</li>
                        <li><strong>national_id</strong> (اختياري): الرقم الوطني</li>
                        <li><strong>email</strong> (اختياري): البريد الإلكتروني</li>
                        <li><strong>phone</strong> (اختياري): رقم الهاتف</li>
                        <li><strong>major_code</strong> (اختياري): رمز التخصص</li>
                        <li><strong>enrollment_date</strong> (اختياري): تاريخ التسجيل (YYYY-MM-DD)</li>
                    </ul>
                </div>
                
                <div class="template-info">
                    <h3>📝 مثال على التنسيق</h3>
                    <table class="example-table">
                        <thead>
                            <tr>
                                <th>student_number</th>
                                <th>full_name_ar</th>
                                <th>full_name_en</th>
                                <th>national_id</th>
                                <th>email</th>
                                <th>phone</th>
                                <th>major_code</th>
                                <th>enrollment_date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>2023001</td>
                                <td>أحمد محمد علي</td>
                                <td>Ahmed Mohammed Ali</td>
                                <td>123456789012</td>
                                <td>ahmed@example.com</td>
                                <td>0501234567</td>
                                <td>CS001</td>
                                <td>2023-09-01</td>
                            </tr>
                            <tr>
                                <td>2023002</td>
                                <td>فاطمة أحمد حسن</td>
                                <td>Fatima Ahmed Hassan</td>
                                <td>234567890123</td>
                                <td>fatima@example.com</td>
                                <td>0502345678</td>
                                <td>CS001</td>
                                <td>2023-09-01</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <div style="margin-top: 25px;">
                    <a href="download_templates.php?type=students" class="btn-download">📥 تحميل القالب</a>
                    <a href="view_guide.php?file=دليل_رفع_الطلاب_من_الإكسل.md" class="btn-guide">📖 عرض الدليل الكامل</a>
                    <a href="students.php" class="btn btn-primary">➡️ رفع الطلاب الآن</a>
                </div>
            </div>
            
            <!-- قالب رفع الدرجات -->
            <div class="template-card">
                <div style="text-align: center; margin-bottom: 20px;">
                    <div class="icon-large">📊</div>
                </div>
                <h2>قالب رفع الدرجات من Excel</h2>
                
                <div class="template-info">
                    <h3>📋 معلومات القالب</h3>
                    <p><strong>الوصف:</strong> هذا القالب يستخدم لرفع درجات الطلاب من ملف Excel أو CSV إلى النظام.</p>
                    
                    <h4>التنسيق:</h4>
                    <ul>
                        <li><strong>العمود الأول:</strong> رقم الطالب (student_number)</li>
                        <li><strong>باقي الأعمدة:</strong> أكواد المواد كعناوين (مثل: CS101, MATH101)</li>
                        <li><strong>الصفوف:</strong> الدرجات لكل طالب في كل مادة</li>
                    </ul>
                    
                    <h4>أنواع الدرجات المدعومة:</h4>
                    <ul>
                        <li><strong>درجات رقمية:</strong> 0-100 (مثل: 85, 90, 75.5)</li>
                        <li><strong>درجات نصية:</strong> بد (بديل), غ (غياب), م (معيد), مث (مستثنى), ن (ناجح), ر (راسب)</li>
                    </ul>
                </div>
                
                <div class="template-info">
                    <h3>📝 مثال على التنسيق</h3>
                    <table class="example-table">
                        <thead>
                            <tr>
                                <th>رقم الطالب</th>
                                <th>CS101</th>
                                <th>MATH101</th>
                                <th>ENG101</th>
                                <th>PHYS101</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>2023001</td>
                                <td>85</td>
                                <td>90</td>
                                <td>75</td>
                                <td>88</td>
                            </tr>
                            <tr>
                                <td>2023002</td>
                                <td>80</td>
                                <td>85</td>
                                <td>بد</td>
                                <td>90</td>
                            </tr>
                            <tr>
                                <td>2023003</td>
                                <td>92</td>
                                <td>88</td>
                                <td>95</td>
                                <td>87</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <div style="margin-top: 25px;">
                    <a href="download_templates.php?type=grades" class="btn-download">📥 تحميل القالب</a>
                    <a href="view_guide.php?file=دليل_رفع_الدرجات_من_الإكسل.md" class="btn-guide">📖 عرض الدليل الكامل</a>
                    <a href="upload_grades_excel.php" class="btn btn-primary">➡️ رفع الدرجات الآن</a>
                </div>
            </div>
        </div>
    </div>
    
    <?php require_once __DIR__ . '/includes/footer.php'; ?>
</body>
</html>

