<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$student_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$student_id || !$auth->canAccessStudent($student_id)) {
    header('Location: students.php');
    exit;
}

$db = Database::getInstance();

// جلب معلومات الطالب
$student = $db->fetchOne(
    "SELECT s.*, m.name_ar as major_name, c.name_ar as college_name
     FROM students s
     JOIN majors m ON s.major_id = m.id
     JOIN colleges c ON s.college_id = c.id
     WHERE s.id = ?",
    [$student_id]
);

if (!$student) {
    header('Location: students.php');
    exit;
}

// جلب المعدل التراكمي
$cgpa = $db->fetchOne(
    "SELECT * FROM cumulative_gpas WHERE student_id = ?",
    [$student_id]
);

// جلب المعدلات الفصلية
$semester_gpas = $db->fetchAll(
    "SELECT sg.*, s.academic_year, s.semester_number
     FROM semester_gpas sg
     JOIN semesters s ON sg.semester_id = s.id
     WHERE sg.student_id = ?
     ORDER BY s.academic_year, s.semester_number",
    [$student_id]
);

// جلب الرسوم
$fees = $db->fetchAll(
    "SELECT f.*, s.academic_year, s.semester_number
     FROM fees f
     JOIN semesters s ON f.semester_id = s.id
     WHERE f.student_id = ?
     ORDER BY s.academic_year, s.semester_number",
    [$student_id]
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تفاصيل الطالب</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>تفاصيل الطالب</h2>
            <div>
                <a href="academic_transcript.php?id=<?php echo $student_id; ?>" class="btn btn-primary">📋 السجل الأكاديمي</a>
                <a href="detailed_certificate.php?student_id=<?php echo $student_id; ?>&lang=ar" class="btn btn-success">📜 شهادة التفاصيل (عربي)</a>
                <a href="detailed_certificate.php?student_id=<?php echo $student_id; ?>&lang=en" class="btn btn-success">📜 Detailed Certificate (English)</a>
                <a href="university_certificate.php?student_id=<?php echo $student_id; ?>" class="btn btn-success">🎓 الشهادة الجامعية</a>
                <a href="upload_student_photo.php?student_id=<?php echo $student_id; ?>" class="btn btn-info">📷 رفع صورة الطالب</a>
                <a href="students.php" class="btn btn-secondary">العودة</a>
                <a href="semesters.php?major_id=<?php echo $student['major_id']; ?>" class="btn btn-primary">تسجيل مواد</a>
                <a href="fees.php?student_id=<?php echo $student_id; ?>" class="btn btn-primary">الرسوم</a>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3>المعلومات الشخصية</h3>
            </div>
            <p><strong>الرقم الجامعي:</strong> <?php echo htmlspecialchars($student['student_number']); ?></p>
            <p><strong>الرقم الوطني:</strong> <?php echo htmlspecialchars($student['national_id'] ?? '-'); ?></p>
            <p><strong>الاسم الكامل:</strong> <?php echo htmlspecialchars($student['full_name_ar']); ?></p>
            <p><strong>الكلية:</strong> <?php echo htmlspecialchars($student['college_name']); ?></p>
            <p><strong>التخصص:</strong> <?php echo htmlspecialchars($student['major_name']); ?></p>
            <p><strong>البريد الإلكتروني:</strong> <?php echo htmlspecialchars($student['email'] ?? '-'); ?></p>
            <p><strong>الهاتف:</strong> <?php echo htmlspecialchars($student['phone'] ?? '-'); ?></p>
            <p><strong>تاريخ التسجيل:</strong> <?php echo date('Y-m-d', strtotime($student['enrollment_date'])); ?></p>
            <p><strong>الحالة:</strong> <?php 
                $status = ['active' => 'نشط', 'graduated' => 'متخرج', 'suspended' => 'معلق', 'withdrawn' => 'منسحب'];
                echo $status[$student['status']] ?? $student['status'];
            ?></p>
        </div>
        
        <?php if ($cgpa): ?>
        <div class="card">
            <div class="card-header">
                <h3>المعدل التراكمي</h3>
            </div>
            <p><strong>المعدل التراكمي:</strong> <?php echo number_format($cgpa['cgpa'], 2); ?></p>
            <p><strong>إجمالي الساعات:</strong> <?php echo $cgpa['total_credit_hours']; ?></p>
        </div>
        <?php endif; ?>
        
        <?php if (!empty($semester_gpas)): ?>
        <div class="card">
            <div class="card-header">
                <h3>المعدلات الفصلية</h3>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>الفصل</th>
                            <th>السنة الدراسية</th>
                            <th>المعدل الفصلي</th>
                            <th>الساعات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($semester_gpas as $sgpa): ?>
                            <tr>
                                <td>فصل <?php echo $sgpa['semester_number']; ?></td>
                                <td><?php echo htmlspecialchars($sgpa['academic_year']); ?></td>
                                <td><?php echo number_format($sgpa['gpa'], 2); ?></td>
                                <td><?php echo $sgpa['total_credit_hours']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if (!empty($fees)): ?>
        <div class="card">
            <div class="card-header">
                <h3>الرسوم الدراسية</h3>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>الفصل</th>
                            <th>نوع الرسوم</th>
                            <th>المبلغ</th>
                            <th>المسدد</th>
                            <th>الحالة</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($fees as $fee): ?>
                            <tr>
                                <td>فصل <?php echo $fee['semester_number']; ?> - <?php echo htmlspecialchars($fee['academic_year']); ?></td>
                                <td><?php 
                                    $types = ['tuition' => 'رسوم دراسية', 'registration' => 'رسوم تسجيل', 'other' => 'أخرى'];
                                    echo $types[$fee['fee_type']] ?? $fee['fee_type'];
                                ?></td>
                                <td><?php echo number_format($fee['amount'], 2); ?></td>
                                <td><?php echo number_format($fee['paid_amount'], 2); ?></td>
                                <td><?php 
                                    $status = ['pending' => 'غير مسدد', 'partial' => 'جزئي', 'paid' => 'مسدد'];
                                    echo $status[$fee['payment_status']] ?? $fee['payment_status'];
                                ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

