<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$major_id = isset($_GET['major_id']) ? (int)$_GET['major_id'] : 0;
$message = '';

if (!$major_id) {
    header('Location: majors.php');
    exit;
}

// التحقق من الصلاحية
$major = $db->fetchOne("SELECT m.*, c.id as college_id FROM majors m JOIN colleges c ON m.college_id = c.id WHERE m.id = ?", [$major_id]);
if (!$major || (!$auth->belongsToCollege($major['college_id']) && !$auth->hasRole('admin'))) {
    header('Location: majors.php');
    exit;
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $semester_number = (int)($_POST['semester_number'] ?? 0);
    $academic_year = $_POST['academic_year'] ?? '';
    $start_date = $_POST['start_date'] ?? null;
    $end_date = $_POST['end_date'] ?? null;
    
    if ($semester_number && $academic_year) {
        try {
            $db->query(
                "INSERT INTO semesters (major_id, semester_number, academic_year, start_date, end_date) 
                 VALUES (?, ?, ?, ?, ?)",
                [$major_id, $semester_number, $academic_year, $start_date, $end_date]
            );
            $message = '<div class="alert alert-success">تم إضافة الفصل الدراسي بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// جلب الفصول
$semesters = $db->fetchAll(
    "SELECT s.*, m.name_ar as major_name 
     FROM semesters s 
     JOIN majors m ON s.major_id = m.id 
     WHERE s.major_id = ? 
     ORDER BY s.academic_year, s.semester_number",
    [$major_id]
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الفصول الدراسية</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة الفصول الدراسية - <?php echo htmlspecialchars($major['name_ar']); ?></h2>
            <div>
                <a href="create_next_semester.php" class="btn btn-success">🔄 إنشاء فصل جديد تلقائياً</a>
                <a href="majors.php?college_id=<?php echo $major['college_id']; ?>" class="btn btn-secondary">العودة للتخصصات</a>
                <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة فصل</button>
            </div>
        </div>
        
        <?php echo $message; ?>
        
        <div id="addForm" class="card" style="display:none; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة فصل دراسي جديد</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>رقم الفصل</label>
                    <input type="number" name="semester_number" min="1" max="<?php echo $major['total_semesters']; ?>" required>
                </div>
                <div class="form-group">
                    <label>السنة الدراسية (مثال: 2024-2025)</label>
                    <input type="text" name="academic_year" placeholder="2024-2025" required>
                </div>
                <div class="form-group">
                    <label>تاريخ البدء</label>
                    <input type="date" name="start_date">
                </div>
                <div class="form-group">
                    <label>تاريخ الانتهاء</label>
                    <input type="date" name="end_date">
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>رقم الفصل</th>
                        <th>السنة الدراسية</th>
                        <th>تاريخ البدء</th>
                        <th>تاريخ الانتهاء</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($semesters as $semester): ?>
                        <tr>
                            <td><?php echo $semester['semester_number']; ?></td>
                            <td><?php echo htmlspecialchars($semester['academic_year']); ?></td>
                            <td><?php echo $semester['start_date'] ? date('Y-m-d', strtotime($semester['start_date'])) : '-'; ?></td>
                            <td><?php echo $semester['end_date'] ? date('Y-m-d', strtotime($semester['end_date'])) : '-'; ?></td>
                            <td><?php echo $semester['is_active'] ? 'نشط' : 'غير نشط'; ?></td>
                            <td>
                                <a href="courses.php?semester_id=<?php echo $semester['id']; ?>" class="btn btn-primary">المواد</a>
                                <a href="grades.php?semester_id=<?php echo $semester['id']; ?>" class="btn btn-success">الدرجات</a>
                                <a href="semester_results.php?semester_id=<?php echo $semester['id']; ?>" class="btn btn-secondary">النتائج</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

