<?php
/**
 * سكريبت بسيط لإعادة تعيين كلمة مرور المدير
 * Simple script to reset admin password
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

// كلمة المرور الجديدة: admin123
$new_password = password_hash('admin123', PASSWORD_DEFAULT);

echo "إعادة تعيين كلمة مرور المدير...\n\n";

try {
    // التحقق من وجود المستخدم
    $admin = $db->fetchOne("SELECT * FROM users WHERE username = 'admin'");
    
    if ($admin) {
        // تحديث كلمة المرور
        $db->query(
            "UPDATE users SET password = ? WHERE username = 'admin'",
            [$new_password]
        );
        echo "✓ تم تحديث كلمة مرور المدير بنجاح!\n\n";
        echo "اسم المستخدم: admin\n";
        echo "كلمة المرور: admin123\n\n";
        
        // التحقق من أن كلمة المرور صحيحة
        if (password_verify('admin123', $new_password)) {
            echo "✓ تم التحقق من كلمة المرور بنجاح!\n";
        } else {
            echo "✗ خطأ في التحقق من كلمة المرور!\n";
        }
    } else {
        echo "✗ المستخدم 'admin' غير موجود في قاعدة البيانات!\n";
        echo "يرجى تشغيل schema.sql أولاً لإنشاء قاعدة البيانات.\n";
    }
    
} catch (PDOException $e) {
    echo "✗ خطأ: " . $e->getMessage() . "\n";
    echo "\nيرجى التحقق من:\n";
    echo "1. قاعدة البيانات موجودة ومتصلة\n";
    echo "2. إعدادات الاتصال في config/database.php صحيحة\n";
    echo "3. تم تشغيل ملف schema.sql\n";
}

