<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$college_id = isset($_GET['college_id']) ? (int)$_GET['college_id'] : $_SESSION['college_id'];
$message = '';

// التحقق من الصلاحية
if (!$auth->belongsToCollege($college_id) && !$auth->hasRole('admin')) {
    header('Location: colleges.php');
    exit;
}

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $total_semesters = (int)($_POST['total_semesters'] ?? 8);
    
    if ($name_ar && $code) {
        try {
            $db->query(
                "INSERT INTO majors (college_id, name_ar, name_en, code, total_semesters) VALUES (?, ?, ?, ?, ?)",
                [$college_id, $name_ar, $name_en, $code, $total_semesters]
            );
            $message = '<div class="alert alert-success">تم إضافة التخصص بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// معالجة التعديل
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = (int)($_POST['id'] ?? 0);
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $total_semesters = (int)($_POST['total_semesters'] ?? 8);
    
    if ($id && $name_ar && $code) {
        // التحقق من أن التخصص ينتمي للكلية الصحيحة
        $major_check = $db->fetchOne("SELECT college_id FROM majors WHERE id = ?", [$id]);
        if ($major_check && ($auth->belongsToCollege($major_check['college_id']) || $auth->hasRole('admin'))) {
            try {
                $db->query(
                    "UPDATE majors SET name_ar = ?, name_en = ?, code = ?, total_semesters = ? WHERE id = ?",
                    [$name_ar, $name_en, $code, $total_semesters, $id]
                );
                $message = '<div class="alert alert-success">تم تحديث التخصص بنجاح</div>';
            } catch (PDOException $e) {
                $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
            }
        }
    }
}

// جلب بيانات التخصص للتعديل
$edit_major = null;
if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    $edit_major = $db->fetchOne("SELECT * FROM majors WHERE id = ?", [$edit_id]);
    // التحقق من الصلاحية
    if ($edit_major && !$auth->belongsToCollege($edit_major['college_id']) && !$auth->hasRole('admin')) {
        $edit_major = null;
    }
    if ($edit_major) {
        $college_id = $edit_major['college_id']; // تحديث college_id للتأكد من عرض الكلية الصحيحة
    }
}

// جلب التخصصات
$majors = $db->fetchAll(
    "SELECT m.*, c.name_ar as college_name FROM majors m 
     JOIN colleges c ON m.college_id = c.id 
     WHERE m.college_id = ? ORDER BY m.name_ar",
    [$college_id]
);

$college = $db->fetchOne("SELECT * FROM colleges WHERE id = ?", [$college_id]);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة التخصصات - <?php echo htmlspecialchars($college['name_ar']); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة التخصصات - <?php echo htmlspecialchars($college['name_ar']); ?></h2>
            <div>
                <a href="colleges.php" class="btn btn-secondary">العودة للكليات</a>
                <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة تخصص</button>
            </div>
        </div>
        
        <?php echo $message; ?>
        
        <div id="addForm" class="card" style="display:<?php echo $edit_major ? 'none' : 'none'; ?>; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة تخصص جديد</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>اسم التخصص (عربي)</label>
                    <input type="text" name="name_ar" required>
                </div>
                <div class="form-group">
                    <label>اسم التخصص (إنجليزي)</label>
                    <input type="text" name="name_en">
                </div>
                <div class="form-group">
                    <label>رمز التخصص</label>
                    <input type="text" name="code" required>
                </div>
                <div class="form-group">
                    <label>عدد الفصول الدراسية</label>
                    <input type="number" name="total_semesters" value="8" min="1" max="16" required>
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <?php if ($edit_major): ?>
        <div id="editForm" class="card" style="margin-bottom: 20px;">
            <div class="card-header">
                <h3>تعديل التخصص</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $edit_major['id']; ?>">
                <div class="form-group">
                    <label>اسم التخصص (عربي)</label>
                    <input type="text" name="name_ar" value="<?php echo htmlspecialchars($edit_major['name_ar']); ?>" required>
                </div>
                <div class="form-group">
                    <label>اسم التخصص (إنجليزي)</label>
                    <input type="text" name="name_en" value="<?php echo htmlspecialchars($edit_major['name_en']); ?>">
                </div>
                <div class="form-group">
                    <label>رمز التخصص</label>
                    <input type="text" name="code" value="<?php echo htmlspecialchars($edit_major['code']); ?>" required>
                </div>
                <div class="form-group">
                    <label>عدد الفصول الدراسية</label>
                    <input type="number" name="total_semesters" value="<?php echo $edit_major['total_semesters']; ?>" min="1" max="16" required>
                </div>
                <button type="submit" class="btn btn-success">تحديث</button>
                <a href="majors.php?college_id=<?php echo $college_id; ?>" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
        <?php endif; ?>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>الرمز</th>
                        <th>الاسم (عربي)</th>
                        <th>عدد الفصول</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($majors as $major): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($major['code']); ?></td>
                            <td><?php echo htmlspecialchars($major['name_ar']); ?></td>
                            <td><?php echo $major['total_semesters']; ?></td>
                            <td>
                                <a href="semesters.php?major_id=<?php echo $major['id']; ?>" class="btn btn-primary">الفصول</a>
                                <a href="students.php?major_id=<?php echo $major['id']; ?>" class="btn btn-success">الطلاب</a>
                                <a href="?edit=<?php echo $major['id']; ?>&college_id=<?php echo $college_id; ?>" class="btn btn-success">تعديل</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

