<?php
/**
 * سكريبت لتحميل البيانات التجريبية
 * Script to load sample data
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/GradeCalculator.php';

echo "بدء تحميل البيانات التجريبية...\n\n";

try {
    $db = Database::getInstance();
    
    // قراءة ملف البيانات التجريبية
    $sql_file = __DIR__ . '/database/sample_data.sql';
    
    if (!file_exists($sql_file)) {
        die("✗ ملف البيانات التجريبية غير موجود: $sql_file\n");
    }
    
    $sql = file_get_contents($sql_file);
    
    // تقسيم SQL إلى أوامر منفصلة
    $statements = array_filter(
        array_map('trim', explode(';', $sql)),
        function($stmt) {
            return !empty($stmt) && !preg_match('/^(--|\/\*|USE|SET)/i', $stmt);
        }
    );
    
    $success_count = 0;
    $error_count = 0;
    
    foreach ($statements as $statement) {
        if (empty(trim($statement))) continue;
        
        try {
            $db->query($statement);
            $success_count++;
        } catch (PDOException $e) {
            // تجاهل الأخطاء المتعلقة بالبيانات المكررة
            if (strpos($e->getMessage(), 'Duplicate entry') === false && 
                strpos($e->getMessage(), 'already exists') === false) {
                echo "⚠ تحذير: " . $e->getMessage() . "\n";
                $error_count++;
            }
        }
    }
    
    echo "✓ تم تحميل البيانات التجريبية!\n";
    echo "✓ عدد الأوامر المنفذة بنجاح: $success_count\n";
    if ($error_count > 0) {
        echo "⚠ عدد الأخطاء: $error_count\n";
    }
    
    // حساب المعدلات للطلاب
    echo "\n--- حساب المعدلات ---\n";
    $gradeCalculator = new GradeCalculator();
    
    $students = $db->fetchAll("SELECT id FROM students");
    foreach ($students as $student) {
        $gradeCalculator->updateAllGPAs($student['id']);
    }
    
    echo "✓ تم حساب جميع المعدلات!\n\n";
    
    // عرض ملخص
    echo "--- ملخص البيانات ---\n";
    $counts = [
        'users' => $db->fetchOne("SELECT COUNT(*) as count FROM users")['count'],
        'students' => $db->fetchOne("SELECT COUNT(*) as count FROM students")['count'],
        'majors' => $db->fetchOne("SELECT COUNT(*) as count FROM majors")['count'],
        'semesters' => $db->fetchOne("SELECT COUNT(*) as count FROM semesters")['count'],
        'courses' => $db->fetchOne("SELECT COUNT(*) as count FROM courses")['count'],
        'grades' => $db->fetchOne("SELECT COUNT(*) as count FROM grades")['count'],
        'fees' => $db->fetchOne("SELECT COUNT(*) as count FROM fees")['count'],
    ];
    
    echo "المستخدمون: " . $counts['users'] . "\n";
    echo "الطلاب: " . $counts['students'] . "\n";
    echo "التخصصات: " . $counts['majors'] . "\n";
    echo "الفصول الدراسية: " . $counts['semesters'] . "\n";
    echo "المواد: " . $counts['courses'] . "\n";
    echo "الدرجات: " . $counts['grades'] . "\n";
    echo "الرسوم: " . $counts['fees'] . "\n";
    
    echo "\n✓ تم تحميل البيانات بنجاح!\n";
    echo "\nيمكنك الآن تسجيل الدخول باستخدام:\n";
    echo "- admin / admin123 (مدير عام)\n";
    echo "- college_admin1 / admin123 (مدير كلية الهندسة)\n";
    echo "- registrar1 / admin123 (مسجل كلية الهندسة)\n";
    echo "- instructor1 / admin123 (أستاذ)\n";
    echo "- STU20231001 / admin123 (طالب - محمد أحمد)\n";
    echo "- STU20231002 / admin123 (طالب - فاطمة سعيد)\n";
    
} catch (Exception $e) {
    echo "✗ خطأ: " . $e->getMessage() . "\n";
    echo "\nيرجى التحقق من:\n";
    echo "1. قاعدة البيانات موجودة ومتصلة\n";
    echo "2. تم تشغيل schema.sql أولاً\n";
    echo "3. إعدادات الاتصال صحيحة\n";
}

