<?php
/**
 * ملف التوافق مع جميع المتصفحات وإصدارات Windows
 * Cross-browser and Windows compatibility file
 */
?>
<!-- Meta Tags for Cross-Browser Compatibility -->
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="format-detection" content="telephone=no">
<meta name="mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

<!-- Windows Compatibility -->
<meta name="application-name" content="نظام نتائج الجامعة">
<meta name="msapplication-TileColor" content="#667eea">
<meta name="msapplication-TileImage" content="assets/images/tile-icon.png">
<meta name="msapplication-config" content="assets/browserconfig.xml">
<meta name="theme-color" content="#667eea">

<!-- Compatibility for older browsers -->
<!--[if lt IE 9]>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/respond.js/1.4.2/respond.min.js"></script>
    <link rel="stylesheet" href="assets/css/ie8-fix.css">
<![endif]-->

<!-- Polyfills for modern JavaScript features -->
<script>
// Polyfill for older browsers
(function() {
    'use strict';
    
    // Array.from polyfill for IE
    if (!Array.from) {
        Array.from = function(arrayLike, mapFn, thisArg) {
            var C = this;
            var items = Object(arrayLike);
            if (arrayLike == null) {
                throw new TypeError('Array.from requires an array-like object - not null or undefined');
            }
            var mapFunction = mapFn === undefined ? undefined : mapFn;
            var T;
            if (typeof mapFunction !== 'undefined') {
                if (typeof mapFunction !== 'function') {
                    throw new TypeError('Array.from: when provided, the second argument must be a function');
                }
                if (arguments.length > 2) {
                    T = thisArg;
                }
            }
            var len = parseInt(items.length) || 0;
            var A = typeof C === 'function' ? Object(new C(len)) : new Array(len);
            var k = 0;
            var kValue;
            while (k < len) {
                kValue = items[k];
                if (mapFunction) {
                    A[k] = typeof T === 'undefined' ? mapFunction(kValue, k) : mapFunction.call(T, kValue, k);
                } else {
                    A[k] = kValue;
                }
                k += 1;
            }
            A.length = len;
            return A;
        };
    }
    
    // Object.assign polyfill for IE
    if (typeof Object.assign !== 'function') {
        Object.assign = function(target) {
            'use strict';
            if (target == null) {
                throw new TypeError('Cannot convert undefined or null to object');
            }
            var to = Object(target);
            for (var index = 1; index < arguments.length; index++) {
                var nextSource = arguments[index];
                if (nextSource != null) {
                    for (var nextKey in nextSource) {
                        if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                            to[nextKey] = nextSource[nextKey];
                        }
                    }
                }
            }
            return to;
        };
    }
    
    // String.includes polyfill for IE
    if (!String.prototype.includes) {
        String.prototype.includes = function(search, start) {
            'use strict';
            if (typeof start !== 'number') {
                start = 0;
            }
            if (start + search.length > this.length) {
                return false;
            } else {
                return this.indexOf(search, start) !== -1;
            }
        };
    }
    
    // Array.includes polyfill for IE
    if (!Array.prototype.includes) {
        Array.prototype.includes = function(searchElement, fromIndex) {
            'use strict';
            if (this == null) {
                throw new TypeError('Array.prototype.includes called on null or undefined');
            }
            var O = Object(this);
            var len = parseInt(O.length) || 0;
            if (len === 0) {
                return false;
            }
            var n = parseInt(fromIndex) || 0;
            var k;
            if (n >= 0) {
                k = n;
            } else {
                k = len + n;
                if (k < 0) {
                    k = 0;
                }
            }
            function sameValueZero(x, y) {
                return x === y || (typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y));
            }
            for (; k < len; k++) {
                if (sameValueZero(O[k], searchElement)) {
                    return true;
                }
            }
            return false;
        };
    }
    
    // Promise polyfill for older browsers
    if (typeof Promise === 'undefined') {
        (function() {
            function Promise(executor) {
                if (typeof executor !== 'function') {
                    throw new TypeError('Promise constructor requires a function');
                }
                var self = this;
                self.state = 'pending';
                self.value = undefined;
                self.handlers = [];
                
                function resolve(result) {
                    if (self.state === 'pending') {
                        self.state = 'fulfilled';
                        self.value = result;
                        self.handlers.forEach(handle);
                        self.handlers = null;
                    }
                }
                
                function reject(error) {
                    if (self.state === 'pending') {
                        self.state = 'rejected';
                        self.value = error;
                        self.handlers.forEach(handle);
                        self.handlers = null;
                    }
                }
                
                function handle(handler) {
                    if (self.state === 'pending') {
                        self.handlers.push(handler);
                    } else {
                        if (self.state === 'fulfilled' && typeof handler.onFulfilled === 'function') {
                            handler.onFulfilled(self.value);
                        }
                        if (self.state === 'rejected' && typeof handler.onRejected === 'function') {
                            handler.onRejected(self.value);
                        }
                    }
                }
                
                self.then = function(onFulfilled, onRejected) {
                    return new Promise(function(resolve, reject) {
                        handle({
                            onFulfilled: function(result) {
                                try {
                                    resolve(onFulfilled ? onFulfilled(result) : result);
                                } catch (ex) {
                                    reject(ex);
                                }
                            },
                            onRejected: function(error) {
                                try {
                                    resolve(onRejected ? onRejected(error) : error);
                                } catch (ex) {
                                    reject(ex);
                                }
                            }
                        });
                    });
                };
                
                self.catch = function(onRejected) {
                    return self.then(null, onRejected);
                };
                
                try {
                    executor(resolve, reject);
                } catch (ex) {
                    reject(ex);
                }
            }
            
            Promise.resolve = function(value) {
                return new Promise(function(resolve) {
                    resolve(value);
                });
            };
            
            Promise.reject = function(reason) {
                return new Promise(function(resolve, reject) {
                    reject(reason);
                });
            };
            
            window.Promise = Promise;
        })();
    }
    
    // Fetch API polyfill for older browsers
    if (typeof fetch === 'undefined') {
        window.fetch = function(url, options) {
            return new Promise(function(resolve, reject) {
                var xhr = new XMLHttpRequest();
                var method = (options && options.method) || 'GET';
                var headers = (options && options.headers) || {};
                var body = options && options.body;
                
                xhr.open(method, url);
                
                for (var key in headers) {
                    if (headers.hasOwnProperty(key)) {
                        xhr.setRequestHeader(key, headers[key]);
                    }
                }
                
                xhr.onload = function() {
                    var response = {
                        ok: xhr.status >= 200 && xhr.status < 300,
                        status: xhr.status,
                        statusText: xhr.statusText,
                        url: xhr.responseURL,
                        text: function() {
                            return Promise.resolve(xhr.responseText);
                        },
                        json: function() {
                            try {
                                return Promise.resolve(JSON.parse(xhr.responseText));
                            } catch (e) {
                                return Promise.reject(e);
                            }
                        }
                    };
                    resolve(response);
                };
                
                xhr.onerror = function() {
                    reject(new TypeError('Network request failed'));
                };
                
                xhr.send(body);
            });
        };
    }
    
    // CSS Custom Properties (CSS Variables) polyfill for IE
    if (window.CSS && !CSS.supports('color', 'var(--fake-var)')) {
        (function() {
            var root = document.documentElement;
            var style = document.createElement('style');
            var variables = {};
            
            function updateVariables() {
                var css = '';
                for (var prop in variables) {
                    if (variables.hasOwnProperty(prop)) {
                        css += prop + ':' + variables[prop] + ';';
                    }
                }
                style.textContent = ':root{' + css + '}';
            }
            
            if (!document.head.querySelector('style[data-css-vars]')) {
                style.setAttribute('data-css-vars', '');
                document.head.appendChild(style);
            }
            
            var originalSetProperty = CSSStyleDeclaration.prototype.setProperty;
            CSSStyleDeclaration.prototype.setProperty = function(prop, value, priority) {
                if (prop && prop.indexOf('--') === 0) {
                    variables[prop] = value;
                    updateVariables();
                }
                return originalSetProperty.call(this, prop, value, priority);
            };
        })();
    }
})();
</script>

<!-- CSS for older browsers -->
<style>
/* Fix for IE8 and older */
.ie8-fix {
    display: block;
}

/* RTL support for older browsers */
[dir="rtl"] {
    direction: rtl;
    text-align: right;
}

[dir="ltr"] {
    direction: ltr;
    text-align: left;
}

/* Flexbox fallback for older browsers */
.flex-container {
    display: -webkit-box;      /* OLD - iOS 6-, Safari 3.1-6 */
    display: -moz-box;         /* OLD - Firefox 19- (buggy but mostly works) */
    display: -ms-flexbox;      /* TWEENER - IE 10 */
    display: -webkit-flex;     /* NEW - Chrome */
    display: flex;             /* NEW, Spec - Opera 12.1, Firefox 20+ */
}

/* Grid fallback for older browsers */
.grid-container {
    display: -ms-grid;
    display: grid;
}

/* Transform fallback */
.transform {
    -webkit-transform: translateZ(0);
    -moz-transform: translateZ(0);
    -ms-transform: translateZ(0);
    -o-transform: translateZ(0);
    transform: translateZ(0);
}

/* Transition fallback */
.transition {
    -webkit-transition: all 0.3s ease;
    -moz-transition: all 0.3s ease;
    -ms-transition: all 0.3s ease;
    -o-transition: all 0.3s ease;
    transition: all 0.3s ease;
}

/* Border-radius fallback */
.rounded {
    -webkit-border-radius: 10px;
    -moz-border-radius: 10px;
    -ms-border-radius: 10px;
    -o-border-radius: 10px;
    border-radius: 10px;
}

/* Box-shadow fallback */
.shadow {
    -webkit-box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    -moz-box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    -ms-box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    -o-box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Gradient fallback */
.gradient {
    background: #667eea; /* Fallback for older browsers */
    background: -webkit-linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    background: -moz-linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    background: -ms-linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    background: -o-linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

/* User-select fallback */
.no-select {
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    -o-user-select: none;
    user-select: none;
}

/* Appearance fallback for form elements */
input, select, textarea, button {
    -webkit-appearance: none;
    -moz-appearance: none;
    -ms-appearance: none;
    -o-appearance: none;
    appearance: none;
}

/* Backdrop-filter fallback */
.backdrop-blur {
    background: rgba(255, 255, 255, 0.9);
}

@supports (backdrop-filter: blur(10px)) {
    .backdrop-blur {
        background: rgba(255, 255, 255, 0.2);
        -webkit-backdrop-filter: blur(10px);
        backdrop-filter: blur(10px);
    }
}
</style>

