<?php
/**
 * صفحة مساعدة لإدخال الدرجات والمعايرة
 * Help page for entering grades and calibration
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$current_step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مساعدة إدخال الدرجات والمعايرة</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .steps-container {
            display: flex;
            gap: 20px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }
        .step-card {
            flex: 1;
            min-width: 200px;
            background: white;
            border: 2px solid #ddd;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        .step-card.active {
            border-color: #667eea;
            background: #f0f4ff;
        }
        .step-card.completed {
            border-color: #4caf50;
            background: #f1f8f4;
        }
        .step-number {
            font-size: 2em;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 10px;
        }
        .step-card.completed .step-number {
            color: #4caf50;
        }
        .step-title {
            font-size: 1.2em;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .step-content {
            margin-top: 30px;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .action-buttons {
            margin-top: 20px;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        .info-box {
            background: #e3f2fd;
            border-right: 5px solid #2196F3;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .warning-box {
            background: #fff3cd;
            border-right: 5px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .success-box {
            background: #f1f8f4;
            border-right: 5px solid #4caf50;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>مساعدة إدخال الدرجات والمعايرة</h2>
            <p>دليل خطوة بخطوة لإدخال الدرجات الأصلية ومعايرة الدرجات</p>
        </div>
        
        <div class="steps-container">
            <div class="step-card <?php echo $current_step >= 1 ? 'completed' : ''; ?> <?php echo $current_step == 1 ? 'active' : ''; ?>" onclick="location.href='?step=1'">
                <div class="step-number">1</div>
                <div class="step-title">تسجيل الطلاب</div>
                <div>تسجيل الطلاب في المواد</div>
            </div>
            <div class="step-card <?php echo $current_step >= 2 ? 'completed' : ''; ?> <?php echo $current_step == 2 ? 'active' : ''; ?>" onclick="location.href='?step=2'">
                <div class="step-number">2</div>
                <div class="step-title">إدخال الدرجات</div>
                <div>إدخال الدرجات الأصلية</div>
            </div>
            <div class="step-card <?php echo $current_step >= 3 ? 'completed' : ''; ?> <?php echo $current_step == 3 ? 'active' : ''; ?>" onclick="location.href='?step=3'">
                <div class="step-number">3</div>
                <div class="step-title">عرض النتائج الأصلية</div>
                <div>التحقق من الدرجات</div>
            </div>
            <div class="step-card <?php echo $current_step >= 4 ? 'completed' : ''; ?> <?php echo $current_step == 4 ? 'active' : ''; ?>" onclick="location.href='?step=4'">
                <div class="step-number">4</div>
                <div class="step-title">معايرة الدرجات</div>
                <div>معايرة وحفظ الدرجات</div>
            </div>
            <div class="step-card <?php echo $current_step >= 5 ? 'completed' : ''; ?> <?php echo $current_step == 5 ? 'active' : ''; ?>" onclick="location.href='?step=5'">
                <div class="step-number">5</div>
                <div class="step-title">عرض النتائج المعايرة</div>
                <div>النتائج بعد المعالجة</div>
            </div>
        </div>
        
        <div class="step-content">
            <?php if ($current_step == 1): ?>
                <h3>الخطوة 1: تسجيل الطلاب في المواد</h3>
                
                <div class="info-box">
                    <strong>📋 الهدف:</strong> تسجيل الطلاب في المواد قبل إدخال الدرجات
                </div>
                
                <h4>الطريقة الأولى: من صفحة إدخال الدرجات</h4>
                <ol style="margin-right: 20px;">
                    <li>اذهب إلى <strong>"إدخال الدرجات (مبسط)"</strong></li>
                    <li>اختر الفصل الدراسي</li>
                    <li>اختر المادة</li>
                    <li>إذا لم تظهر قائمة الطلاب، اضغط على <strong>"تسجيل طلاب في هذه المادة"</strong></li>
                </ol>
                
                <h4>الطريقة الثانية: من صفحة إدارة المواد</h4>
                <ol style="margin-right: 20px;">
                    <li>اذهب إلى <strong>"إدارة المواد"</strong></li>
                    <li>اختر الفصل الدراسي</li>
                    <li>بجانب كل مادة، اضغط <strong>"تسجيل طلاب"</strong></li>
                </ol>
                
                <h4>في صفحة تسجيل الطلاب:</h4>
                <ul style="margin-right: 20px;">
                    <li><strong>التسجيل اليدوي:</strong> حدد الطلاب من القائمة واضغط "تسجيل الطلاب المحددين"</li>
                    <li><strong>التسجيل من ملف Excel:</strong> ارفع ملف Excel/CSV يحتوي على أرقام الطلاب</li>
                </ul>
                
                <div class="action-buttons">
                    <a href="enter_grades_simple.php" class="btn btn-primary">➡️ اذهب إلى إدخال الدرجات</a>
                    <a href="courses.php" class="btn btn-secondary">➡️ اذهب إلى إدارة المواد</a>
                    <a href="?step=2" class="btn btn-success">✅ تم التسجيل - التالي</a>
                </div>
                
            <?php elseif ($current_step == 2): ?>
                <h3>الخطوة 2: إدخال الدرجات الأصلية</h3>
                
                <div class="info-box">
                    <strong>📋 الهدف:</strong> إدخال الدرجات الأصلية للطلاب (من 0 إلى 100)
                </div>
                
                <h4>خطوات إدخال الدرجات:</h4>
                <ol style="margin-right: 20px;">
                    <li>اذهب إلى <strong>"إدخال الدرجات (مبسط)"</strong></li>
                    <li><strong>اختر الفصل الدراسي</strong> من القائمة المنسدلة</li>
                    <li><strong>اختر المادة</strong> التي تريد إدخال درجاتها</li>
                    <li>ستظهر قائمة بجميع الطلاب المسجلين في المادة</li>
                    <li><strong>أدخل الدرجة</strong> لكل طالب (من 0 إلى 100)</li>
                    <li>اضغط <strong>"حفظ"</strong> بجانب كل طالب</li>
                    <li>سيتم حساب التقدير الحرفي والنقاط تلقائياً</li>
                </ol>
                
                <div class="warning-box">
                    <strong>⚠️ مهم:</strong>
                    <ul style="margin-right: 20px; margin-top: 10px;">
                        <li>يجب إدخال الدرجات الأصلية لجميع الطلاب في جميع المواد</li>
                        <li>الدرجات يجب أن تكون بين 0 و 100</li>
                        <li>بعد الحفظ، سيتم تحديث المعدل الفصلي تلقائياً</li>
                    </ul>
                </div>
                
                <h4>نظام الدرجات:</h4>
                <table style="width: 100%; margin-top: 15px;">
                    <thead>
                        <tr style="background: #667eea; color: white;">
                            <th style="padding: 10px;">الدرجة</th>
                            <th style="padding: 10px;">التقدير</th>
                            <th style="padding: 10px;">النقاط</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td style="padding: 8px;">80 - 100</td><td style="padding: 8px;"><strong>A</strong></td><td style="padding: 8px;">4.0</td></tr>
                        <tr style="background: #f9f9f9;"><td style="padding: 8px;">70 - 79</td><td style="padding: 8px;"><strong>B</strong></td><td style="padding: 8px;">3.0</td></tr>
                        <tr><td style="padding: 8px;">60 - 69</td><td style="padding: 8px;"><strong>C</strong></td><td style="padding: 8px;">2.0</td></tr>
                        <tr style="background: #f9f9f9;"><td style="padding: 8px;">50 - 59</td><td style="padding: 8px;"><strong>D</strong></td><td style="padding: 8px;">1.0</td></tr>
                        <tr><td style="padding: 8px;">أقل من 50</td><td style="padding: 8px;"><strong>F</strong></td><td style="padding: 8px;">0.0</td></tr>
                    </tbody>
                </table>
                
                <div class="action-buttons">
                    <a href="enter_grades_simple.php" class="btn btn-primary">➡️ اذهب إلى إدخال الدرجات</a>
                    <a href="?step=3" class="btn btn-success">✅ تم الإدخال - التالي</a>
                </div>
                
            <?php elseif ($current_step == 3): ?>
                <h3>الخطوة 3: عرض النتائج الأصلية (قبل المعالجة)</h3>
                
                <div class="info-box">
                    <strong>📋 الهدف:</strong> التحقق من الدرجات الأصلية قبل المعايرة
                </div>
                
                <h4>خطوات عرض النتائج الأصلية:</h4>
                <ol style="margin-right: 20px;">
                    <li>اذهب إلى <strong>"استخراج النتائج"</strong></li>
                    <li><strong>اختر الكلية</strong> من القائمة</li>
                    <li><strong>اختر التخصص</strong></li>
                    <li><strong>اختر الفصل الدراسي</strong> (رقم الفصل)</li>
                    <li><strong>اختر السنة الدراسية</strong></li>
                    <li>اضغط على <strong>"النتائج الأصلية (قبل المعالجة)"</strong></li>
                    <li>ستظهر جميع الدرجات الأصلية للطلاب</li>
                </ol>
                
                <div class="warning-box">
                    <strong>⚠️ تأكد من:</strong>
                    <ul style="margin-right: 20px; margin-top: 10px;">
                        <li>جميع الطلاب لديهم درجات في جميع المواد</li>
                        <li>الدرجات صحيحة</li>
                        <li>المعدلات الفصلية محسوبة بشكل صحيح</li>
                    </ul>
                </div>
                
                <div class="action-buttons">
                    <a href="semester_results.php" class="btn btn-primary">➡️ اذهب إلى استخراج النتائج</a>
                    <a href="?step=4" class="btn btn-success">✅ تم التحقق - التالي</a>
                </div>
                
            <?php elseif ($current_step == 4): ?>
                <h3>الخطوة 4: معايرة الدرجات وحفظها</h3>
                
                <div class="info-box">
                    <strong>📋 الهدف:</strong> معايرة الدرجات باستخدام نظام ثوراندويك وحفظها
                </div>
                
                <h4>خطوات المعايرة:</h4>
                <ol style="margin-right: 20px;">
                    <li>من صفحة <strong>"استخراج النتائج"</strong></li>
                    <li>بعد اختيار الفصل الدراسي</li>
                    <li>اضغط على <strong>"النتائج بعد المعايرة (ثوراندويك)"</strong></li>
                    <li>ستظهر الدرجات المعايرة تلقائياً</li>
                    <li><strong>تعديل المعاملات (اختياري):</strong>
                        <ul style="margin-right: 20px; margin-top: 10px;">
                            <li><strong>المتوسط المستهدف:</strong> القيمة الافتراضية 70 (يمكن تغييرها)</li>
                            <li><strong>الانحراف المعياري المستهدف:</strong> القيمة الافتراضية 12 (يمكن تغييرها)</li>
                            <li>اضغط <strong>"تحديث المعايرة"</strong> لتطبيق التغييرات</li>
                        </ul>
                    </li>
                    <li>راجع الدرجات المعايرة والإحصائيات</li>
                    <li>اضغط <strong>"💾 حفظ الدرجات المعايرة"</strong> لحفظها في قاعدة البيانات</li>
                </ol>
                
                <div class="info-box">
                    <strong>ℹ️ عن نظام ثوراندويك:</strong>
                    <ul style="margin-right: 20px; margin-top: 10px;">
                        <li>يقوم بمعايرة الدرجات بناءً على التوزيع الطبيعي</li>
                        <li>يحافظ على الترتيب النسبي للطلاب</li>
                        <li>يعدل المتوسط والانحراف المعياري للدرجات</li>
                        <li>كل مادة تُعاير بشكل منفصل</li>
                    </ul>
                </div>
                
                <div class="warning-box">
                    <strong>⚠️ ملاحظات مهمة:</strong>
                    <ul style="margin-right: 20px; margin-top: 10px;">
                        <li>يجب أن يكون هناك 3 طلاب على الأقل في كل مادة للمعايرة</li>
                        <li>إذا كانت جميع الدرجات متساوية، لا يمكن المعايرة</li>
                        <li>بعد الحفظ، يمكنك عرض النتائج المعايرة في أي وقت</li>
                    </ul>
                </div>
                
                <h4>مثال على المعايرة:</h4>
                <div style="background: #f5f5f5; padding: 15px; border-radius: 5px; margin-top: 15px;">
                    <p><strong>الدرجات الأصلية:</strong></p>
                    <ul style="margin-right: 20px;">
                        <li>طالب 1: 85</li>
                        <li>طالب 2: 75</li>
                        <li>طالب 3: 65</li>
                        <li>المتوسط: 75 | الانحراف المعياري: 8.16</li>
                    </ul>
                    <p style="margin-top: 15px;"><strong>بعد المعايرة (70, 12):</strong></p>
                    <ul style="margin-right: 20px;">
                        <li>طالب 1: 84.69 (نقص بسيط)</li>
                        <li>طالب 2: 72.65 (نقص بسيط)</li>
                        <li>طالب 3: 62.65 (نقص بسيط)</li>
                        <li>المتوسط: 70 | الانحراف المعياري: 12</li>
                    </ul>
                </div>
                
                <div class="action-buttons">
                    <a href="semester_results.php" class="btn btn-primary">➡️ اذهب إلى استخراج النتائج</a>
                    <a href="?step=5" class="btn btn-success">✅ تم الحفظ - التالي</a>
                </div>
                
            <?php elseif ($current_step == 5): ?>
                <h3>الخطوة 5: عرض النتائج بعد المعالجة (المعايرة)</h3>
                
                <div class="success-box">
                    <strong>✅ الهدف:</strong> عرض النتائج النهائية بعد معايرة الدرجات
                </div>
                
                <h4>خطوات عرض النتائج المعايرة:</h4>
                <ol style="margin-right: 20px;">
                    <li>اذهب إلى <strong>"استخراج النتائج"</strong></li>
                    <li>اختر الكلية، التخصص، الفصل الدراسي، والسنة</li>
                    <li>اضغط على <strong>"النتائج بعد المعايرة (ثوراندويك)"</strong></li>
                    <li>ستظهر النتائج المعايرة مع:
                        <ul style="margin-right: 20px; margin-top: 10px;">
                            <li>الدرجة المعايرة (بالأعلى)</li>
                            <li>التقدير الحرفي المعاير</li>
                            <li>مقارنة بالدرجة الأصلية: <code>[الأصلية → التغيير]</code></li>
                            <li>المعدل الفصلي المعاير</li>
                        </ul>
                    </li>
                </ol>
                
                <h4>فهم النتائج:</h4>
                <div style="background: #f5f5f5; padding: 15px; border-radius: 5px; margin-top: 15px;">
                    <p><strong>في جدول النتائج:</strong></p>
                    <ul style="margin-right: 20px;">
                        <li><strong>الدرجة المعايرة:</strong> الدرجة بعد المعايرة (بالأعلى)</li>
                        <li><strong>التقدير:</strong> التقدير الحرفي بناءً على الدرجة المعايرة</li>
                        <li><strong>[الأصلية → التغيير]:</strong>
                            <ul style="margin-right: 20px; margin-top: 5px;">
                                <li><span style="color: green;">أخضر</span>: زيادة في الدرجة</li>
                                <li><span style="color: red;">أحمر</span>: نقص في الدرجة</li>
                                <li><span style="color: gray;">رمادي</span>: لا يوجد تغيير</li>
                            </ul>
                        </li>
                    </ul>
                </div>
                
                <h4>إحصائيات المعايرة:</h4>
                <div style="background: #f5f5f5; padding: 15px; border-radius: 5px; margin-top: 15px;">
                    <p>في نهاية الصفحة، ستجد جدول <strong>"إحصائيات المعايرة"</strong> الذي يوضح:</p>
                    <ul style="margin-right: 20px;">
                        <li>عدد الطلاب في كل مادة</li>
                        <li>المتوسط الأصلي مقابل المعاير</li>
                        <li>الانحراف المعياري الأصلي مقابل المعاير</li>
                        <li>الفرق في المتوسط</li>
                    </ul>
                </div>
                
                <div class="info-box">
                    <strong>💡 نصائح:</strong>
                    <ul style="margin-right: 20px; margin-top: 10px;">
                        <li>يمكنك طباعة النتائج باستخدام زر "طباعة النتائج"</li>
                        <li>النتائج المعايرة محفوظة ويمكنك عرضها في أي وقت</li>
                        <li>يمكنك تعديل المعايرة وحفظها مرة أخرى</li>
                    </ul>
                </div>
                
                <div class="action-buttons">
                    <a href="semester_results.php" class="btn btn-primary">➡️ اذهب إلى استخراج النتائج</a>
                    <a href="?step=1" class="btn btn-secondary">🔄 ابدأ من جديد</a>
                </div>
                
            <?php endif; ?>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

