<?php
/**
 * سكريبت لمساعدة في العثور على كلمة مرور MySQL الصحيحة
 * Script to help find the correct MySQL password
 */

// قائمة كلمات المرور الشائعة في AppServ
$commonPasswords = [
    '',           // فارغة
    'root',       // الأكثر شيوعاً
    'password',   // كلمة مرور شائعة
    '123456',     // كلمة مرور بسيطة
    'admin',      // كلمة مرور شائعة
];

$host = 'localhost';
$user = 'root';
$database = 'university_results';

echo "═══════════════════════════════════════════════════════════\n";
echo "   البحث عن كلمة مرور MySQL الصحيحة\n";
echo "   Finding Correct MySQL Password\n";
echo "═══════════════════════════════════════════════════════════\n\n";
echo "جارٍ تجربة كلمات المرور الشائعة...\n\n";

$found = false;
$workingPassword = null;

foreach ($commonPasswords as $password) {
    $displayPassword = $password === '' ? '(فارغة)' : $password;
    echo "تجربة: '$displayPassword' ... ";
    
    try {
        $dsn = "mysql:host=$host;charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_TIMEOUT => 2, // مهلة قصيرة للاختبار السريع
        ];
        
        $pdo = new PDO($dsn, $user, $password, $options);
        
        // محاولة الوصول إلى قاعدة البيانات
        try {
            $pdo->exec("USE `$database`");
            echo "✓ نجح! قاعدة البيانات متاحة أيضاً.\n";
            $found = true;
            $workingPassword = $password;
            break;
        } catch (PDOException $e) {
            // الاتصال نجح لكن قاعدة البيانات غير موجودة
            echo "✓ نجح الاتصال! (لكن قاعدة البيانات '$database' غير موجودة)\n";
            $found = true;
            $workingPassword = $password;
            break;
        }
        
    } catch (PDOException $e) {
        $errorCode = $e->getCode();
        if ($errorCode == 1045) {
            echo "✗ فشل (Access denied)\n";
        } elseif ($errorCode == 2002) {
            echo "✗ فشل (MySQL غير قيد التشغيل)\n";
            echo "\n⚠ تحذير: يبدو أن MySQL غير قيد التشغيل!\n";
            echo "يرجى تشغيل MySQL من AppServ Control Panel\n";
            break;
        } else {
            echo "✗ فشل (" . $e->getMessage() . ")\n";
        }
    }
}

echo "\n";
echo "═══════════════════════════════════════════════════════════\n";

if ($found) {
    echo "✓ تم العثور على كلمة مرور صحيحة!\n\n";
    echo "كلمة المرور الصحيحة: ";
    if ($workingPassword === '') {
        echo "(فارغة)\n\n";
        echo "قم بتحديث ملف config/database.php:\n";
        echo "define('DB_PASS', '');\n";
    } else {
        echo "'$workingPassword'\n\n";
        echo "قم بتحديث ملف config/database.php:\n";
        echo "define('DB_PASS', '$workingPassword');\n";
    }
    
    // التحقق من وجود قاعدة البيانات
    try {
        $dsn = "mysql:host=$host;charset=utf8mb4";
        $pdo = new PDO($dsn, $user, $workingPassword);
        $pdo->exec("USE `$database`");
        echo "\n✓ قاعدة البيانات '$database' موجودة ومتاحة!\n";
    } catch (PDOException $e) {
        echo "\n⚠ قاعدة البيانات '$database' غير موجودة.\n";
        echo "يرجى إنشائها باستخدام:\n";
        echo "  mysql -u root -p < database/schema.sql\n";
        echo "أو من phpMyAdmin استورد ملف database/schema.sql\n";
    }
    
} else {
    echo "✗ لم يتم العثور على كلمة مرور صحيحة من القائمة الشائعة.\n\n";
    echo "الحلول الممكنة:\n";
    echo "───────────────────────────────────────────────────────────\n";
    echo "1. تحقق من كلمة المرور من AppServ Control Panel:\n";
    echo "   - افتح AppServ Control Panel\n";
    echo "   - ابحث عن إعدادات MySQL أو كلمة مرور root\n\n";
    
    echo "2. تحقق من كلمة المرور من phpMyAdmin:\n";
    echo "   - افتح http://localhost/phpmyadmin\n";
    echo "   - حاول تسجيل الدخول بكلمات مرور مختلفة\n\n";
    
    echo "3. إعادة تعيين كلمة مرور MySQL:\n";
    echo "   - أوقف MySQL من AppServ Control Panel\n";
    echo "   - شغّل MySQL في وضع safe mode:\n";
    echo "     mysqld --skip-grant-tables\n";
    echo "   - في نافذة أخرى:\n";
    echo "     mysql -u root\n";
    echo "     ALTER USER 'root'@'localhost' IDENTIFIED BY 'root';\n";
    echo "     FLUSH PRIVILEGES;\n";
    echo "   - أوقف MySQL وأعد تشغيله بشكل طبيعي\n\n";
    
    echo "4. إذا كنت تعرف كلمة المرور، قم بتحديثها يدوياً في:\n";
    echo "   config/database.php\n";
    echo "   define('DB_PASS', 'كلمة_المرور_الصحيحة');\n";
}

echo "═══════════════════════════════════════════════════════════\n";

