<?php
/**
 * مثال على استخدام كود نتائج الملاحق ونتائج إزالة الرسوب
 * Example Usage of Supplementary and Removal Exam Results
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/SupplementaryResults.php';
require_once __DIR__ . '/classes/RemovalExamResults.php';

$db = Database::getInstance();

// ==========================================
// مثال 1: حساب نتيجة الملاحق لطالب واحد
// ==========================================
echo "=== مثال 1: حساب نتيجة الملاحق لطالب واحد ===\n\n";

$supplementaryResults = new SupplementaryResults($db);

// مثال: طالب برقم معرف 1 في فصل برقم معرف 1
$student_id = 1;
$semester_id = 1;

$result = $supplementaryResults->calculateSupplementaryResult($student_id, $semester_id);

echo "معرف الطالب: $student_id\n";
echo "معرف الفصل: $semester_id\n";
echo "النتيجة: " . $result['arabic_status'] . "\n";
echo "الرسالة: " . $result['message'] . "\n";
echo "عدد المواد الراسبة: " . $result['failed_count'] . "\n";
echo "إجمالي مواد الملاحق: " . $result['total_supplementary_courses'] . "\n";

if ($result['status'] == 'repeat_year') {
    echo "\nالقرار: يعيد السنة الدراسية\n";
} elseif ($result['status'] == 'removal_exam') {
    echo "\nالقرار: يسمح له بامتحان إزالة الرسوب\n";
} else {
    echo "\nالقرار: ناجح في جميع مواد الملاحق\n";
}

// ==========================================
// مثال 2: حساب نتيجة إزالة الرسوب لطالب واحد
// ==========================================
echo "\n\n=== مثال 2: حساب نتيجة إزالة الرسوب لطالب واحد ===\n\n";

$removalExamResults = new RemovalExamResults($db);

$removal_result = $removalExamResults->calculateRemovalExamResult($student_id, $semester_id);

echo "معرف الطالب: $student_id\n";
echo "معرف الفصل: $semester_id\n";
echo "النتيجة: " . $removal_result['arabic_status'] . "\n";
echo "الرسالة: " . $removal_result['message'] . "\n";
echo "عدد المواد الراسبة: " . $removal_result['failed_count'] . "\n";
echo "إجمالي مواد امتحان إزالة الرسوب: " . $removal_result['total_removal_exam_courses'] . "\n";

if ($removal_result['status'] == 'repeat_year') {
    echo "\nالقرار: يعيد السنة الدراسية (راسب في مادة واحدة)\n";
} else {
    echo "\nالقرار: يستمر بشكل طبيعي (ناجح أو راسب في صفر مواد)\n";
}

// ==========================================
// مثال 3: حساب نتائج الملاحق لعدة طلاب
// ==========================================
echo "\n\n=== مثال 3: حساب نتائج الملاحق لعدة طلاب ===\n\n";

$student_ids = [1, 2, 3, 4, 5];
$batch_results = $supplementaryResults->calculateBatchSupplementaryResults($student_ids, $semester_id);

foreach ($batch_results as $std_id => $std_result) {
    echo "الطالب $std_id: " . $std_result['arabic_status'] . 
         " (" . $std_result['failed_count'] . " مواد راسبة)\n";
}

// ==========================================
// مثال 4: جلب تقرير شامل لنتائج الملاحق
// ==========================================
echo "\n\n=== مثال 4: جلب تقرير شامل لنتائج الملاحق ===\n\n";

$report = $supplementaryResults->getSupplementaryReport($semester_id);

echo "إجمالي الطلاب: " . $report['summary']['total_students'] . "\n";
echo "يعيد السنة: " . $report['summary']['repeat_year_count'] . "\n";
echo "يسمح له بامتحان إزالة الرسوب: " . $report['summary']['removal_exam_count'] . "\n";
echo "ناجح: " . $report['summary']['pass_count'] . "\n";

// ==========================================
// مثال 5: استخدام في صفحة ويب
// ==========================================
/*
// في ملف PHP:
require_once __DIR__ . '/classes/SupplementaryResults.php';
require_once __DIR__ . '/classes/RemovalExamResults.php';

$db = Database::getInstance();
$supplementaryResults = new SupplementaryResults($db);

// حساب النتيجة
$result = $supplementaryResults->calculateSupplementaryResult($student_id, $semester_id);

// عرض النتيجة
if ($result['status'] == 'repeat_year') {
    echo "<div class='alert alert-danger'>يعيد السنة الدراسية</div>";
} elseif ($result['status'] == 'removal_exam') {
    echo "<div class='alert alert-warning'>يسمح له بامتحان إزالة الرسوب</div>";
} else {
    echo "<div class='alert alert-success'>ناجح</div>";
}
*/

// ==========================================
// ملاحظات مهمة:
// ==========================================
/*
1. القواعد المطبقة في كود الملاحق:
   - إذا رسب في أكثر من مادتين: يعيد السنة
   - إذا رسب في مادتين على الأكثر: يسمح له بامتحان إزالة الرسوب

2. القواعد المطبقة في كود إزالة الرسوب:
   - إذا رسب في مادة واحدة: يعيد السنة
   - إذا لم يرسب (أو رسب في صفر مواد): يستمر بشكل طبيعي

3. يمكن تخصيص الكود حسب هيكل قاعدة البيانات:
   - إذا كانت هناك جداول منفصلة للملاحق وإزالة الرسوب
   - إذا كانت هناك أعمدة إضافية في جدول grades لتحديد نوع الامتحان

4. الوصول للصفحات:
   - صفحة نتائج الملاحق: supplementary_results_page.php
   - صفحة نتائج إزالة الرسوب: removal_exam_results_page.php
*/

echo "\n\n=== انتهى المثال ===\n";

