<?php
/**
 * صفحة تحميل القوالب
 * Download Templates Page
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin') && !$auth->hasRole('registrar'))) {
    header('Location: index.php');
    exit;
}

$template_type = isset($_GET['type']) ? $_GET['type'] : '';

// تحديد نوع القالب
if ($template_type === 'students') {
    // قالب رفع الطلاب
    $filename = 'template_students.csv';
    $filepath = __DIR__ . '/templates/template_students.csv';
    
    // إنشاء المحتوى بالقيم الصحيحة
    $template_content = "student_number,full_name_ar,full_name_en,national_id,email,phone,major_code,enrollment_date\n";
    $template_content .= "2023001,أحمد محمد علي,Ahmed Mohammed Ali,123456789012,ahmed@example.com,0501234567,CS001,2023-09-01\n";
    $template_content .= "2023002,فاطمة أحمد حسن,Fatima Ahmed Hassan,234567890123,fatima@example.com,0502345678,CS001,2023-09-01\n";
    $template_content .= "2023003,محمد خالد إبراهيم,Mohammed Khalid Ibrahim,345678901234,mohammed@example.com,0503456789,CS002,2023-09-01\n";
    
    // إنشاء المجلد إذا لم يكن موجوداً
    $template_dir = dirname($filepath);
    if (!is_dir($template_dir)) {
        mkdir($template_dir, 0755, true);
    }
    
    // حفظ الملف بترميز UTF-8 مع BOM
    // التأكد من أن المحتوى UTF-8
    if (!mb_check_encoding($template_content, 'UTF-8')) {
        $template_content = mb_convert_encoding($template_content, 'UTF-8', 'auto');
    }
    file_put_contents($filepath, "\xEF\xBB\xBF" . $template_content, LOCK_EX);
    
    // إرسال الملف بالترميز الصحيح
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Content-Transfer-Encoding: binary');
    
    // إرسال BOM UTF-8 أولاً ثم المحتوى
    echo "\xEF\xBB\xBF";
    
    // قراءة الملف وإرساله مع التحقق من الترميز
    if (file_exists($filepath)) {
        $content = file_get_contents($filepath);
        // إزالة BOM الموجود في الملف إذا كان موجوداً لتجنب التكرار
        if (substr($content, 0, 3) === "\xEF\xBB\xBF") {
            $content = substr($content, 3);
        }
        // التحقق من أن المحتوى UTF-8
        if (!mb_check_encoding($content, 'UTF-8')) {
            $content = mb_convert_encoding($content, 'UTF-8', 'auto');
        }
        echo $content;
    } else {
        // إذا لم يكن الملف موجوداً، أرسل المحتوى مباشرة
        if (!mb_check_encoding($template_content, 'UTF-8')) {
            $template_content = mb_convert_encoding($template_content, 'UTF-8', 'auto');
        }
        echo $template_content;
    }
    exit;
    
} elseif ($template_type === 'grades') {
    // قالب رفع الدرجات
    $filename = 'template_grades.csv';
    $filepath = __DIR__ . '/templates/template_grades.csv';
    
    // إنشاء المحتوى بالقيم الصحيحة
    $template_content = "رقم الطالب,CS101,MATH101,ENG101,PHYS101\n";
    $template_content .= "2023001,85,90,75,88\n";
    $template_content .= "2023002,80,85,بد,90\n";
    $template_content .= "2023003,92,88,95,87\n";
    
    // إنشاء المجلد إذا لم يكن موجوداً
    $template_dir = dirname($filepath);
    if (!is_dir($template_dir)) {
        mkdir($template_dir, 0755, true);
    }
    
    // حفظ الملف بترميز UTF-8 مع BOM
    // التأكد من أن المحتوى UTF-8
    if (!mb_check_encoding($template_content, 'UTF-8')) {
        $template_content = mb_convert_encoding($template_content, 'UTF-8', 'auto');
    }
    file_put_contents($filepath, "\xEF\xBB\xBF" . $template_content, LOCK_EX);
    
    // إرسال الملف بالترميز الصحيح
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Content-Transfer-Encoding: binary');
    
    // إرسال BOM UTF-8 أولاً ثم المحتوى
    echo "\xEF\xBB\xBF";
    
    // قراءة الملف وإرساله مع التحقق من الترميز
    if (file_exists($filepath)) {
        $content = file_get_contents($filepath);
        // إزالة BOM الموجود في الملف إذا كان موجوداً لتجنب التكرار
        if (substr($content, 0, 3) === "\xEF\xBB\xBF") {
            $content = substr($content, 3);
        }
        // التحقق من أن المحتوى UTF-8
        if (!mb_check_encoding($content, 'UTF-8')) {
            $content = mb_convert_encoding($content, 'UTF-8', 'auto');
        }
        echo $content;
    } else {
        // إذا لم يكن الملف موجوداً، أرسل المحتوى مباشرة
        if (!mb_check_encoding($template_content, 'UTF-8')) {
            $template_content = mb_convert_encoding($template_content, 'UTF-8', 'auto');
        }
        echo $template_content;
    }
    exit;
    
}

// إذا لم يتم تحديد نوع القالب أو حدث خطأ، إعادة توجيه للصفحة الرئيسية
header('Location: dashboard.php');
exit;

