<?php
/**
 * صفحة تشخيص لصفحة تسجيل الطلاب
 * Debug page for students registration
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تشخيص صفحة تسجيل الطلاب</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .test { background: white; padding: 15px; margin: 10px 0; border-radius: 5px; border-right: 4px solid #ddd; }
        .success { border-right-color: #4caf50; background: #f1f8f4; }
        .error { border-right-color: #f44336; background: #ffebee; }
        .warning { border-right-color: #ff9800; background: #fff3e0; }
        code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; }
    </style>
</head>
<body>
    <h1>🔍 تشخيص صفحة تسجيل الطلاب</h1>
    
    <?php
    // اختبار 1: تحميل الملفات
    echo '<div class="test">';
    echo '<h2>1. اختبار تحميل الملفات</h2>';
    try {
        require_once __DIR__ . '/config/config.php';
        echo '<p style="color: #4caf50;">✓ config.php تم تحميله</p>';
    } catch (Exception $e) {
        echo '<p style="color: #f44336;">✗ خطأ في config.php: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
    
    try {
        require_once __DIR__ . '/classes/Auth.php';
        echo '<p style="color: #4caf50;">✓ Auth.php تم تحميله</p>';
    } catch (Exception $e) {
        echo '<p style="color: #f44336;">✗ خطأ في Auth.php: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
    echo '</div>';
    
    // اختبار 2: الاتصال بقاعدة البيانات
    echo '<div class="test">';
    echo '<h2>2. اختبار الاتصال بقاعدة البيانات</h2>';
    try {
        $db = Database::getInstance();
        $connection = $db->getConnection();
        echo '<p style="color: #4caf50;">✓ الاتصال بقاعدة البيانات نجح</p>';
    } catch (Exception $e) {
        echo '<p style="color: #f44336;">✗ خطأ في الاتصال: ' . htmlspecialchars($e->getMessage()) . '</p>';
        echo '</div></body></html>';
        exit;
    }
    echo '</div>';
    
    // اختبار 3: الجداول
    echo '<div class="test">';
    echo '<h2>3. اختبار الجداول</h2>';
    $requiredTables = ['students', 'users', 'colleges', 'majors'];
    foreach ($requiredTables as $table) {
        try {
            $result = $db->fetchAll("SHOW TABLES LIKE '$table'");
            if (count($result) > 0) {
                echo '<p style="color: #4caf50;">✓ جدول <code>' . $table . '</code> موجود</p>';
            } else {
                echo '<p style="color: #f44336;">✗ جدول <code>' . $table . '</code> غير موجود</p>';
            }
        } catch (Exception $e) {
            echo '<p style="color: #f44336;">✗ خطأ في فحص جدول <code>' . $table . '</code>: ' . htmlspecialchars($e->getMessage()) . '</p>';
        }
    }
    echo '</div>';
    
    // اختبار 4: Auth
    echo '<div class="test">';
    echo '<h2>4. اختبار Auth</h2>';
    try {
        $auth = new Auth();
        if ($auth->isLoggedIn()) {
            echo '<p style="color: #4caf50;">✓ المستخدم مسجل دخول</p>';
            echo '<p>اسم المستخدم: <code>' . htmlspecialchars($_SESSION['username'] ?? 'غير محدد') . '</code></p>';
            echo '<p>الدور: <code>' . htmlspecialchars($_SESSION['role'] ?? 'غير محدد') . '</code></p>';
            
            $hasPermission = $auth->hasRole('admin') || $auth->hasRole('college_admin') || $auth->hasRole('registrar');
            if ($hasPermission) {
                echo '<p style="color: #4caf50;">✓ لديك صلاحية للوصول لصفحة الطلاب</p>';
            } else {
                echo '<p style="color: #f44336;">✗ ليس لديك صلاحية للوصول لصفحة الطلاب</p>';
                echo '<p>الأدوار المطلوبة: admin, college_admin, أو registrar</p>';
            }
        } else {
            echo '<p style="color: #ff9800;">⚠ المستخدم غير مسجل دخول</p>';
            echo '<p><a href="index.php">سجل دخول أولاً</a></p>';
        }
    } catch (Exception $e) {
        echo '<p style="color: #f44336;">✗ خطأ في Auth: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
    echo '</div>';
    
    // اختبار 5: جلب البيانات
    echo '<div class="test">';
    echo '<h2>5. اختبار جلب البيانات</h2>';
    try {
        $auth = new Auth();
        if ($auth->isLoggedIn()) {
            // جلب الكليات
            try {
                if ($auth->hasRole('admin')) {
                    $colleges = $db->fetchAll("SELECT * FROM colleges ORDER BY name_ar");
                } else {
                    $college_id = $_SESSION['college_id'] ?? 0;
                    $college_name = $_SESSION['college_name'] ?? 'غير محدد';
                    $colleges = [['id' => $college_id, 'name_ar' => $college_name]];
                }
                echo '<p style="color: #4caf50;">✓ تم جلب الكليات: ' . count($colleges) . ' كلية</p>';
            } catch (Exception $e) {
                echo '<p style="color: #f44336;">✗ خطأ في جلب الكليات: ' . htmlspecialchars($e->getMessage()) . '</p>';
            }
            
            // جلب التخصصات
            try {
                if ($auth->hasRole('admin')) {
                    $majors = $db->fetchAll("SELECT m.* FROM majors m JOIN colleges c ON m.college_id = c.id ORDER BY m.name_ar");
                } else {
                    $college_id = $_SESSION['college_id'] ?? 0;
                    $majors = $db->fetchAll(
                        "SELECT m.* FROM majors m JOIN colleges c ON m.college_id = c.id WHERE c.id = ? ORDER BY m.name_ar",
                        [$college_id]
                    );
                }
                echo '<p style="color: #4caf50;">✓ تم جلب التخصصات: ' . count($majors) . ' تخصص</p>';
            } catch (Exception $e) {
                echo '<p style="color: #f44336;">✗ خطأ في جلب التخصصات: ' . htmlspecialchars($e->getMessage()) . '</p>';
            }
            
            // جلب الطلاب
            try {
                if ($auth->hasRole('admin')) {
                    $students = $db->fetchAll(
                        "SELECT s.*, m.name_ar as major_name, c.name_ar as college_name 
                         FROM students s 
                         JOIN majors m ON s.major_id = m.id 
                         JOIN colleges c ON s.college_id = c.id 
                         ORDER BY s.student_number"
                    );
                } else {
                    $college_id = $_SESSION['college_id'] ?? 0;
                    $students = $db->fetchAll(
                        "SELECT s.*, m.name_ar as major_name, c.name_ar as college_name 
                         FROM students s 
                         JOIN majors m ON s.major_id = m.id 
                         JOIN colleges c ON s.college_id = c.id 
                         WHERE s.college_id = ?
                         ORDER BY s.student_number",
                        [$college_id]
                    );
                }
                echo '<p style="color: #4caf50;">✓ تم جلب الطلاب: ' . count($students) . ' طالب</p>';
            } catch (Exception $e) {
                echo '<p style="color: #f44336;">✗ خطأ في جلب الطلاب: ' . htmlspecialchars($e->getMessage()) . '</p>';
            }
        }
    } catch (Exception $e) {
        echo '<p style="color: #f44336;">✗ خطأ عام: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
    echo '</div>';
    
    // الملخص
    echo '<div class="test" style="background: #e3f2fd; border-right-color: #2196f3;">';
    echo '<h2>الخطوات التالية</h2>';
    echo '<ol>';
    echo '<li>إذا كان المستخدم غير مسجل دخول: <a href="index.php">سجل دخول</a></li>';
    echo '<li>إذا كانت الجداول غير موجودة: استورد <code>database/schema.sql</code> من phpMyAdmin</li>';
    echo '<li>إذا كانت هناك أخطاء في قاعدة البيانات: تحقق من كلمة المرور في <code>config/database.php</code></li>';
    echo '<li>بعد إصلاح المشاكل، جرّب <a href="students.php">students.php</a></li>';
    echo '</ol>';
    echo '</div>';
    ?>
</body>
</html>

