-- بيانات تجريبية لنظام نتائج الجامعة
-- Sample Data for University Results System

USE university_results;

-- إضافة مستخدمين إضافيين
INSERT INTO users (college_id, username, password, full_name_ar, full_name_en, email, role) VALUES
(1, 'college_admin1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مدير كلية الهندسة', 'Engineering College Admin', 'admin1@university.edu', 'college_admin'),
(2, 'college_admin2', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مدير كلية العلوم', 'Science College Admin', 'admin2@university.edu', 'college_admin'),
(1, 'registrar1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مسجل كلية الهندسة', 'Engineering Registrar', 'registrar1@university.edu', 'registrar'),
(2, 'registrar2', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مسجل كلية العلوم', 'Science Registrar', 'registrar2@university.edu', 'registrar'),
(1, 'instructor1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'أستاذ أحمد محمد', 'Prof. Ahmed Mohammed', 'instructor1@university.edu', 'instructor'),
(1, 'instructor2', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'أستاذة فاطمة علي', 'Prof. Fatima Ali', 'instructor2@university.edu', 'instructor');

-- إضافة تخصصات
INSERT INTO majors (college_id, name_ar, name_en, code, total_semesters) VALUES
(1, 'هندسة الحاسوب', 'Computer Engineering', 'CE', 8),
(1, 'هندسة البرمجيات', 'Software Engineering', 'SE', 8),
(1, 'هندسة الشبكات', 'Network Engineering', 'NE', 8),
(2, 'علوم الحاسوب', 'Computer Science', 'CS', 8),
(2, 'الرياضيات', 'Mathematics', 'MATH', 8),
(2, 'الفيزياء', 'Physics', 'PHY', 8),
(3, 'اللغة العربية', 'Arabic Language', 'AR', 8),
(3, 'اللغة الإنجليزية', 'English Language', 'EN', 8),
(4, 'المحاسبة', 'Accounting', 'ACC', 8),
(4, 'إدارة الأعمال', 'Business Administration', 'BA', 8);

-- إضافة فصول دراسية
INSERT INTO semesters (major_id, semester_number, academic_year, start_date, end_date, is_active) VALUES
-- هندسة الحاسوب - الفصل الأول
(1, 1, '2023-2024', '2023-09-01', '2024-01-15', 0),
(1, 2, '2023-2024', '2024-02-01', '2024-06-15', 0),
(1, 3, '2024-2025', '2024-09-01', '2025-01-15', 1),
(1, 4, '2024-2025', '2025-02-01', '2025-06-15', 0),
-- هندسة البرمجيات
(2, 1, '2023-2024', '2023-09-01', '2024-01-15', 0),
(2, 2, '2023-2024', '2024-02-01', '2024-06-15', 0),
(2, 3, '2024-2025', '2024-09-01', '2025-01-15', 1),
-- علوم الحاسوب
(4, 1, '2023-2024', '2023-09-01', '2024-01-15', 0),
(4, 2, '2023-2024', '2024-02-01', '2024-06-15', 0),
(4, 3, '2024-2025', '2024-09-01', '2025-01-15', 1);

-- إضافة مواد دراسية
INSERT INTO courses (major_id, semester_id, code, name_ar, name_en, credit_hours, is_required) VALUES
-- مواد هندسة الحاسوب - الفصل الأول
(1, 1, 'CE101', 'مقدمة في البرمجة', 'Introduction to Programming', 3, 1),
(1, 1, 'CE102', 'الرياضيات المتقطعة', 'Discrete Mathematics', 3, 1),
(1, 1, 'CE103', 'مبادئ الهندسة الكهربائية', 'Electrical Engineering Principles', 3, 1),
(1, 1, 'CE104', 'اللغة الإنجليزية التقنية', 'Technical English', 2, 1),
-- مواد هندسة الحاسوب - الفصل الثاني
(1, 2, 'CE201', 'هياكل البيانات', 'Data Structures', 3, 1),
(1, 2, 'CE202', 'الخوارزميات', 'Algorithms', 3, 1),
(1, 2, 'CE203', 'قواعد البيانات', 'Database Systems', 3, 1),
(1, 2, 'CE204', 'هندسة البرمجيات', 'Software Engineering', 3, 1),
-- مواد هندسة الحاسوب - الفصل الثالث
(1, 3, 'CE301', 'شبكات الحاسوب', 'Computer Networks', 3, 1),
(1, 3, 'CE302', 'أنظمة التشغيل', 'Operating Systems', 3, 1),
(1, 3, 'CE303', 'أمن المعلومات', 'Information Security', 3, 1),
(1, 3, 'CE304', 'الذكاء الاصطناعي', 'Artificial Intelligence', 3, 0),
-- مواد هندسة البرمجيات
(2, 5, 'SE101', 'أساسيات البرمجة', 'Programming Fundamentals', 3, 1),
(2, 5, 'SE102', 'تحليل وتصميم الأنظمة', 'Systems Analysis and Design', 3, 1),
(2, 5, 'SE201', 'تطوير تطبيقات الويب', 'Web Application Development', 3, 1),
(2, 5, 'SE202', 'تطوير تطبيقات الهاتف', 'Mobile Application Development', 3, 1),
-- مواد علوم الحاسوب
(4, 8, 'CS101', 'مقدمة في علوم الحاسوب', 'Introduction to Computer Science', 3, 1),
(4, 8, 'CS102', 'البرمجة الشيئية', 'Object-Oriented Programming', 3, 1),
(4, 8, 'CS201', 'الذكاء الاصطناعي', 'Artificial Intelligence', 3, 1),
(4, 8, 'CS202', 'تعلم الآلة', 'Machine Learning', 3, 1);

-- إضافة طلاب
INSERT INTO students (college_id, major_id, student_number, national_id, full_name_ar, full_name_en, email, phone, address, enrollment_date, status, user_id) VALUES
-- طلاب هندسة الحاسوب
(1, 1, '20231001', '1234567890', 'محمد أحمد العلي', 'Mohammed Ahmed Al-Ali', 'm.ahmed@student.edu', '0501234567', 'الرياض، حي النرجس', '2023-09-01', 'active', NULL),
(1, 1, '20231002', '1234567891', 'فاطمة سعيد الخالدي', 'Fatima Saeed Al-Khalidi', 'f.saeed@student.edu', '0501234568', 'الرياض، حي العليا', '2023-09-01', 'active', NULL),
(1, 1, '20231003', '1234567892', 'خالد عبدالله المطيري', 'Khalid Abdullah Al-Mutairi', 'k.abdullah@student.edu', '0501234569', 'الرياض، حي المطار', '2023-09-01', 'active', NULL),
(1, 1, '20231004', '1234567893', 'نورا حسن الدوسري', 'Nora Hassan Al-Dosari', 'n.hassan@student.edu', '0501234570', 'الرياض، حي العريجاء', '2023-09-01', 'active', NULL),
-- طلاب هندسة البرمجيات
(1, 2, '20232001', '1234567894', 'عبدالرحمن يوسف القحطاني', 'Abdulrahman Youssef Al-Qahtani', 'a.youssef@student.edu', '0501234571', 'الرياض، حي النزهة', '2023-09-01', 'active', NULL),
(1, 2, '20232002', '1234567895', 'سارة علي الشمري', 'Sara Ali Al-Shammari', 's.ali@student.edu', '0501234572', 'الرياض، حي الياسمين', '2023-09-01', 'active', NULL),
-- طلاب علوم الحاسوب
(2, 4, '20234001', '1234567896', 'أحمد محمد الحربي', 'Ahmed Mohammed Al-Harbi', 'a.mohammed@student.edu', '0501234573', 'الرياض، حي الورود', '2023-09-01', 'active', NULL),
(2, 4, '20234002', '1234567897', 'مريم خالد العتيبي', 'Mariam Khalid Al-Otaibi', 'm.khalid@student.edu', '0501234574', 'الرياض، حي الربيع', '2023-09-01', 'active', NULL);

-- إضافة حسابات للطلاب
INSERT INTO users (college_id, username, password, full_name_ar, full_name_en, email, role) VALUES
(1, 'STU20231001', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'محمد أحمد العلي', 'Mohammed Ahmed Al-Ali', 'm.ahmed@student.edu', 'student'),
(1, 'STU20231002', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'فاطمة سعيد الخالدي', 'Fatima Saeed Al-Khalidi', 'f.saeed@student.edu', 'student'),
(1, 'STU20231003', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'خالد عبدالله المطيري', 'Khalid Abdullah Al-Mutairi', 'k.abdullah@student.edu', 'student'),
(1, 'STU20231004', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'نورا حسن الدوسري', 'Nora Hassan Al-Dosari', 'n.hassan@student.edu', 'student'),
(1, 'STU20232001', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'عبدالرحمن يوسف القحطاني', 'Abdulrahman Youssef Al-Qahtani', 'a.youssef@student.edu', 'student'),
(1, 'STU20232002', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'سارة علي الشمري', 'Sara Ali Al-Shammari', 's.ali@student.edu', 'student'),
(2, 'STU20234001', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'أحمد محمد الحربي', 'Ahmed Mohammed Al-Harbi', 'a.mohammed@student.edu', 'student'),
(2, 'STU20234002', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'مريم خالد العتيبي', 'Mariam Khalid Al-Otaibi', 'm.khalid@student.edu', 'student');

-- تحديث user_id للطلاب
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20231001') WHERE student_number = '20231001';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20231002') WHERE student_number = '20231002';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20231003') WHERE student_number = '20231003';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20231004') WHERE student_number = '20231004';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20232001') WHERE student_number = '20232001';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20232002') WHERE student_number = '20232002';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20234001') WHERE student_number = '20234001';
UPDATE students SET user_id = (SELECT id FROM users WHERE username = 'STU20234002') WHERE student_number = '20234002';

-- تسجيل الطلاب في المواد
INSERT INTO student_courses (student_id, course_id, semester_id, registration_date) VALUES
-- الطالب 20231001 (محمد أحمد) - الفصل الأول
(1, 1, 1, '2023-09-05'),
(1, 2, 1, '2023-09-05'),
(1, 3, 1, '2023-09-05'),
(1, 4, 1, '2023-09-05'),
-- الطالب 20231001 - الفصل الثاني
(1, 5, 2, '2024-02-05'),
(1, 6, 2, '2024-02-05'),
(1, 7, 2, '2024-02-05'),
(1, 8, 2, '2024-02-05'),
-- الطالب 20231001 - الفصل الثالث
(1, 9, 3, '2024-09-05'),
(1, 10, 3, '2024-09-05'),
(1, 11, 3, '2024-09-05'),
(1, 12, 3, '2024-09-05'),
-- الطالب 20231002 (فاطمة سعيد) - الفصل الأول
(2, 1, 1, '2023-09-05'),
(2, 2, 1, '2023-09-05'),
(2, 3, 1, '2023-09-05'),
(2, 4, 1, '2023-09-05'),
-- الطالب 20231002 - الفصل الثاني
(2, 5, 2, '2024-02-05'),
(2, 6, 2, '2024-02-05'),
(2, 7, 2, '2024-02-05'),
(2, 8, 2, '2024-02-05'),
-- الطالب 20231003 (خالد عبدالله) - الفصل الأول
(3, 1, 1, '2023-09-05'),
(3, 2, 1, '2023-09-05'),
(3, 3, 1, '2023-09-05'),
(3, 4, 1, '2023-09-05'),
-- الطالب 20231004 (نورا حسن) - الفصل الأول
(4, 1, 1, '2023-09-05'),
(4, 2, 1, '2023-09-05'),
(4, 3, 1, '2023-09-05'),
(4, 4, 1, '2023-09-05');

-- إضافة درجات للطلاب
INSERT INTO grades (student_course_id, student_id, course_id, semester_id, marks, letter_grade, points, entered_by) VALUES
-- درجات الطالب 20231001 - الفصل الأول
(1, 1, 1, 1, 85, 'A', 4.0, 5),
(2, 1, 2, 1, 78, 'B+', 3.5, 5),
(3, 1, 3, 1, 82, 'A', 4.0, 5),
(4, 1, 4, 1, 90, 'A', 4.0, 5),
-- درجات الطالب 20231001 - الفصل الثاني
(5, 1, 5, 2, 88, 'A', 4.0, 5),
(6, 1, 6, 2, 75, 'B+', 3.5, 5),
(7, 1, 7, 2, 80, 'A', 4.0, 5),
(8, 1, 8, 2, 85, 'A', 4.0, 5),
-- درجات الطالب 20231001 - الفصل الثالث
(9, 1, 9, 3, 92, 'A', 4.0, 5),
(10, 1, 10, 3, 87, 'A', 4.0, 5),
(11, 1, 11, 3, 83, 'A', 4.0, 5),
(12, 1, 12, 3, 79, 'B+', 3.5, 5),
-- درجات الطالب 20231002 - الفصل الأول
(13, 2, 1, 1, 92, 'A', 4.0, 5),
(14, 2, 2, 1, 88, 'A', 4.0, 5),
(15, 2, 3, 1, 85, 'A', 4.0, 5),
(16, 2, 4, 1, 90, 'A', 4.0, 5),
-- درجات الطالب 20231002 - الفصل الثاني
(17, 2, 5, 2, 95, 'A', 4.0, 5),
(18, 2, 6, 2, 89, 'A', 4.0, 5),
(19, 2, 7, 2, 87, 'A', 4.0, 5),
(20, 2, 8, 2, 91, 'A', 4.0, 5),
-- درجات الطالب 20231003 - الفصل الأول
(21, 3, 1, 1, 72, 'B+', 3.5, 5),
(22, 3, 2, 1, 68, 'B', 3.0, 5),
(23, 3, 3, 1, 75, 'B+', 3.5, 5),
(24, 3, 4, 1, 70, 'B+', 3.5, 5),
-- درجات الطالب 20231004 - الفصل الأول
(25, 4, 1, 1, 65, 'B', 3.0, 5),
(26, 4, 2, 1, 62, 'C', 2.0, 5),
(27, 4, 3, 1, 68, 'B', 3.0, 5),
(28, 4, 4, 1, 72, 'B+', 3.5, 5);

-- حساب المعدلات الفصلية (سيتم حسابها تلقائياً عند الوصول، لكن نضيف بعض البيانات للتوضيح)
-- سيتم حسابها تلقائياً بواسطة GradeCalculator

-- إضافة رسوم دراسية
INSERT INTO fees (student_id, semester_id, fee_type, amount, due_date, paid_amount, payment_status) VALUES
-- رسوم الطالب 20231001
(1, 1, 'tuition', 5000.00, '2023-09-15', 5000.00, 'paid'),
(1, 1, 'registration', 500.00, '2023-09-15', 500.00, 'paid'),
(1, 2, 'tuition', 5000.00, '2024-02-15', 5000.00, 'paid'),
(1, 2, 'registration', 500.00, '2024-02-15', 500.00, 'paid'),
(1, 3, 'tuition', 5000.00, '2024-09-15', 5000.00, 'paid'),
(1, 3, 'registration', 500.00, '2024-09-15', 500.00, 'paid'),
-- رسوم الطالب 20231002
(2, 1, 'tuition', 5000.00, '2023-09-15', 5000.00, 'paid'),
(2, 1, 'registration', 500.00, '2023-09-15', 500.00, 'paid'),
(2, 2, 'tuition', 5000.00, '2024-02-15', 5000.00, 'paid'),
(2, 2, 'registration', 500.00, '2024-02-15', 500.00, 'paid'),
-- رسوم الطالب 20231003
(3, 1, 'tuition', 5000.00, '2023-09-15', 3000.00, 'partial'),
(3, 1, 'registration', 500.00, '2023-09-15', 500.00, 'paid'),
-- رسوم الطالب 20231004
(4, 1, 'tuition', 5000.00, '2023-09-15', 0.00, 'pending'),
(4, 1, 'registration', 500.00, '2023-09-15', 0.00, 'pending');

-- إضافة طلبات شهادات
INSERT INTO certificate_requests (student_id, certificate_type, request_date, status) VALUES
(1, 'transcript', '2024-10-01', 'pending'),
(2, 'university', '2024-10-02', 'pending'),
(1, 'detailed', '2024-10-03', 'approved');

-- ملاحظة: المعدلات الفصلية والتراكمية سيتم حسابها تلقائياً عند الوصول للصفحات
-- يمكن تشغيل GradeCalculator لتحديثها الآن إذا أردت

