-- إنشاء جدول semester_calibrations إذا لم يكن موجوداً
-- Create semester_calibrations table if it doesn't exist

CREATE TABLE IF NOT EXISTS semester_calibrations (
    id INT PRIMARY KEY AUTO_INCREMENT,
    semester_id INT NOT NULL,
    target_mean DECIMAL(5,2) NOT NULL,
    target_std DECIMAL(5,2) NOT NULL,
    calibrated_by INT NOT NULL,
    calibrated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (semester_id) REFERENCES semesters(id) ON DELETE CASCADE,
    FOREIGN KEY (calibrated_by) REFERENCES users(id) ON DELETE RESTRICT,
    UNIQUE KEY unique_semester_calibration (semester_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

