<?php
/**
 * سكريبت لإنشاء/إعادة تعيين كلمة مرور المدير
 * Script to create/reset admin password
 */

require_once __DIR__ . '/config/config.php';

$db = Database::getInstance();

// كلمة المرور: admin123
$new_password = password_hash('admin123', PASSWORD_DEFAULT);

echo "=== إعداد حساب المدير ===\n\n";

try {
    // 1. التحقق من وجود كلية أو إنشائها
    $college = $db->fetchOne("SELECT * FROM colleges WHERE id = 1");
    if (!$college) {
        // محاولة الحصول على أي كلية
        $any_college = $db->fetchOne("SELECT * FROM colleges LIMIT 1");
        if (!$any_college) {
            // إنشاء كلية افتراضية
            $db->query(
                "INSERT INTO colleges (id, name_ar, name_en, code) 
                 VALUES (1, 'كلية الهندسة', 'College of Engineering', 'ENG')"
            );
            echo "✓ تم إنشاء كلية افتراضية (ID: 1)\n";
            $college_id = 1;
        } else {
            $college_id = $any_college['id'];
            echo "✓ تم العثور على كلية موجودة (ID: $college_id)\n";
        }
    } else {
        $college_id = 1;
        echo "✓ الكلية موجودة (ID: 1)\n";
    }
    
    // 2. التحقق من وجود المستخدم
    $admin = $db->fetchOne("SELECT * FROM users WHERE username = 'admin'");
    
    if ($admin) {
        // تحديث كلمة المرور
        $db->query(
            "UPDATE users SET password = ? WHERE username = 'admin'",
            [$new_password]
        );
        echo "✓ تم تحديث كلمة مرور المدير\n";
    } else {
        // إنشاء مستخدم جديد
        $db->query(
            "INSERT INTO users (college_id, username, password, full_name_ar, role, is_active) 
             VALUES (?, 'admin', ?, 'مدير النظام', 'admin', 1)",
            [$college_id, $new_password]
        );
        echo "✓ تم إنشاء مستخدم المدير\n";
    }
    
    // 3. التحقق من أن كلمة المرور صحيحة
    $test_user = $db->fetchOne("SELECT * FROM users WHERE username = 'admin'");
    if ($test_user && password_verify('admin123', $test_user['password'])) {
        echo "\n✓✓✓ تم التحقق من كلمة المرور بنجاح! ✓✓✓\n\n";
    } else {
        echo "\n✗ خطأ: فشل التحقق من كلمة المرور\n";
    }
    
    echo "=== بيانات تسجيل الدخول ===\n";
    echo "اسم المستخدم: admin\n";
    echo "كلمة المرور: admin123\n\n";
    echo "يمكنك الآن تسجيل الدخول إلى النظام!\n";
    
} catch (PDOException $e) {
    echo "\n✗ خطأ: " . $e->getMessage() . "\n\n";
    echo "يرجى التحقق من:\n";
    echo "1. قاعدة البيانات 'university_results' موجودة\n";
    echo "2. إعدادات الاتصال في config/database.php صحيحة\n";
    echo "3. تم تشغيل ملف database/schema.sql لإنشاء الجداول\n";
}

