<?php
/**
 * إعدادات عامة للنظام
 * General System Configuration
 */

// إعدادات الجلسة
session_start();

// المنطقة الزمنية
date_default_timezone_set('Asia/Riyadh');

// وضع التصحيح (يُنصح بإيقافه في الإنتاج)
if (!defined('APP_DEBUG')) {
    define('APP_DEBUG', true);
}
if (APP_DEBUG) {
    ini_set('display_errors', '1');
    ini_set('display_startup_errors', '1');
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', '0');
    error_reporting(0);
}

// إعدادات النظام
define('SITE_NAME', 'نظام نتائج جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology');
define('SITE_URL', 'http://localhost/GUNS');
define('UPLOAD_DIR', __DIR__ . '/../uploads/');
define('CERTIFICATES_DIR', __DIR__ . '/../certificates/');
define('LOG_DIR', __DIR__ . '/../logs/');

// تهيئة مجلد السجلات وتوجيه أخطاء PHP إلى ملف
if (!file_exists(LOG_DIR)) {
    @mkdir(LOG_DIR, 0777, true);
}
ini_set('log_errors', '1');
ini_set('error_log', LOG_DIR . '/php-error.log');

// إعدادات الأمان
define('SESSION_TIMEOUT', 3600); // ساعة واحدة

// إعدادات الدرجات
// التقدير الجديد: A (80-100), B (70-79), C (60-69), D (50-59), F (<50)
define('GRADE_SCALE', [
    'A' => ['min' => 80, 'max' => 100, 'points' => 4.0],
    'B' => ['min' => 70, 'max' => 79, 'points' => 3.0],
    'C' => ['min' => 60, 'max' => 69, 'points' => 2.0],
    'D' => ['min' => 50, 'max' => 59, 'points' => 1.0],
    'F' => ['min' => 0, 'max' => 49, 'points' => 0.0]
]);

// دالة لتنظيف التقدير الحرفي وإزالة علامات + (مثل B+ -> B, C+ -> C)
// التقديرات المسموحة فقط: A, B, C, D, F
function cleanLetterGrade($letter_grade) {
    if (empty($letter_grade) || $letter_grade === '-') {
        return $letter_grade;
    }
    
    $letter_grade = trim($letter_grade);
    
    // إزالة علامات + من التقديرات
    $letter_grade = str_replace(['B+', 'C+', 'A+', '+'], ['B', 'C', 'A', ''], $letter_grade);
    
    return $letter_grade;
}

// تضمين ملف قاعدة البيانات
require_once __DIR__ . '/database.php';

// إنشاء مجلدات إذا لم تكن موجودة
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0777, true);
}
if (!file_exists(CERTIFICATES_DIR)) {
    mkdir(CERTIFICATES_DIR, 0777, true);
}

