<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$message = '';

// معالجة الإضافة
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $specialization_year = !empty($_POST['specialization_year']) ? (int)$_POST['specialization_year'] : null;
    
    if ($name_ar && $code) {
        try {
            $db->query(
                "INSERT INTO colleges (name_ar, name_en, code, specialization_year) VALUES (?, ?, ?, ?)",
                [$name_ar, $name_en, $code, $specialization_year]
            );
            $message = '<div class="alert alert-success">تم إضافة الكلية بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// معالجة التعديل
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = (int)($_POST['id'] ?? 0);
    $name_ar = $_POST['name_ar'] ?? '';
    $name_en = $_POST['name_en'] ?? '';
    $code = $_POST['code'] ?? '';
    $specialization_year = !empty($_POST['specialization_year']) ? (int)$_POST['specialization_year'] : null;
    
    if ($id && $name_ar && $code && $auth->hasRole('admin')) {
        try {
            $db->query(
                "UPDATE colleges SET name_ar = ?, name_en = ?, code = ?, specialization_year = ? WHERE id = ?",
                [$name_ar, $name_en, $code, $specialization_year, $id]
            );
            $message = '<div class="alert alert-success">تم تحديث الكلية بنجاح</div>';
        } catch (PDOException $e) {
            $message = '<div class="alert alert-error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        }
    }
}

// جلب بيانات الكلية للتعديل
$edit_college = null;
if (isset($_GET['edit']) && $auth->hasRole('admin')) {
    $edit_id = (int)$_GET['edit'];
    $edit_college = $db->fetchOne("SELECT * FROM colleges WHERE id = ?", [$edit_id]);
}

// معالجة الحذف
if (isset($_GET['delete']) && $auth->hasRole('admin')) {
    $id = (int)$_GET['delete'];
    $db->query("DELETE FROM colleges WHERE id = ?", [$id]);
    $message = '<div class="alert alert-success">تم حذف الكلية بنجاح</div>';
}

// جلب الكليات
$colleges = $db->fetchAll("SELECT * FROM colleges ORDER BY name_ar");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة الكليات</title>
    <?php include __DIR__ . '/includes/compatibility.php'; ?>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدارة الكليات</h2>
            <?php if ($auth->hasRole('admin')): ?>
                <button onclick="document.getElementById('addForm').style.display='block'" class="btn btn-primary">إضافة كلية</button>
            <?php endif; ?>
        </div>
        
        <?php echo $message; ?>
        
        <?php if ($auth->hasRole('admin')): ?>
        <div id="addForm" class="card" style="display:<?php echo $edit_college ? 'none' : 'none'; ?>; margin-bottom: 20px;">
            <div class="card-header">
                <h3>إضافة كلية جديدة</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>اسم الكلية (عربي)</label>
                    <input type="text" name="name_ar" required>
                </div>
                <div class="form-group">
                    <label>اسم الكلية (إنجليزي)</label>
                    <input type="text" name="name_en">
                </div>
                <div class="form-group">
                    <label>رمز الكلية</label>
                    <input type="text" name="code" required>
                </div>
                <div class="form-group">
                    <label>سنة التوزيع على التخصصات</label>
                    <select name="specialization_year">
                        <option value="">لا يوجد توزيع متأخر</option>
                        <option value="1">السنة الأولى</option>
                        <option value="2">السنة الثانية</option>
                        <option value="3">السنة الثالثة</option>
                        <option value="4">السنة الرابعة</option>
                        <option value="5">السنة الخامسة</option>
                    </select>
                    <small style="display: block; color: #666; margin-top: 5px;">
                        اختر السنة التي يتوزع فيها الطلاب على التخصصات (اتركه فارغاً إذا كان التوزيع من البداية)
                    </small>
                </div>
                <button type="submit" class="btn btn-success">إضافة</button>
                <button type="button" onclick="document.getElementById('addForm').style.display='none'" class="btn btn-secondary">إلغاء</button>
            </form>
        </div>
        
        <?php if ($edit_college): ?>
        <div id="editForm" class="card" style="margin-bottom: 20px;">
            <div class="card-header">
                <h3>تعديل الكلية</h3>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $edit_college['id']; ?>">
                <div class="form-group">
                    <label>اسم الكلية (عربي)</label>
                    <input type="text" name="name_ar" value="<?php echo htmlspecialchars($edit_college['name_ar']); ?>" required>
                </div>
                <div class="form-group">
                    <label>اسم الكلية (إنجليزي)</label>
                    <input type="text" name="name_en" value="<?php echo htmlspecialchars($edit_college['name_en']); ?>">
                </div>
                <div class="form-group">
                    <label>رمز الكلية</label>
                    <input type="text" name="code" value="<?php echo htmlspecialchars($edit_college['code']); ?>" required>
                </div>
                <div class="form-group">
                    <label>سنة التوزيع على التخصصات</label>
                    <select name="specialization_year">
                        <option value="" <?php echo empty($edit_college['specialization_year']) ? 'selected' : ''; ?>>لا يوجد توزيع متأخر</option>
                        <option value="1" <?php echo $edit_college['specialization_year'] == 1 ? 'selected' : ''; ?>>السنة الأولى</option>
                        <option value="2" <?php echo $edit_college['specialization_year'] == 2 ? 'selected' : ''; ?>>السنة الثانية</option>
                        <option value="3" <?php echo $edit_college['specialization_year'] == 3 ? 'selected' : ''; ?>>السنة الثالثة</option>
                        <option value="4" <?php echo $edit_college['specialization_year'] == 4 ? 'selected' : ''; ?>>السنة الرابعة</option>
                        <option value="5" <?php echo $edit_college['specialization_year'] == 5 ? 'selected' : ''; ?>>السنة الخامسة</option>
                    </select>
                    <small style="display: block; color: #666; margin-top: 5px;">
                        اختر السنة التي يتوزع فيها الطلاب على التخصصات (اتركه فارغاً إذا كان التوزيع من البداية)
                    </small>
                </div>
                <button type="submit" class="btn btn-success">تحديث</button>
                <a href="colleges.php" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>الرمز</th>
                        <th>الاسم (عربي)</th>
                        <th>الاسم (إنجليزي)</th>
                        <th>سنة التوزيع على التخصصات</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($colleges as $college): ?>
                        <?php if ($auth->hasRole('admin') || $college['id'] == $_SESSION['college_id']): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($college['code']); ?></td>
                            <td><?php echo htmlspecialchars($college['name_ar']); ?></td>
                            <td><?php echo htmlspecialchars($college['name_en']); ?></td>
                            <td>
                                <?php 
                                if (isset($college['specialization_year']) && $college['specialization_year'] > 0) {
                                    echo 'السنة ' . $college['specialization_year'];
                                } else {
                                    echo '<span style="color: #999;">من البداية</span>';
                                }
                                ?>
                            </td>
                            <td>
                                <a href="majors.php?college_id=<?php echo $college['id']; ?>" class="btn btn-primary">التخصصات</a>
                                <?php if ($auth->hasRole('admin')): ?>
                                    <a href="?edit=<?php echo $college['id']; ?>" class="btn btn-success">تعديل</a>
                                    <a href="?delete=<?php echo $college['id']; ?>" 
                                       onclick="return confirm('هل أنت متأكد من الحذف؟')" 
                                       class="btn btn-danger">حذف</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

