<?php
/**
 * صفحة للتحقق من شعار الجامعة وتشخيص المشاكل
 * Check University Logo and Diagnose Issues
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$logo_info = [];

// جلب الشعار من قاعدة البيانات
try {
    $logo_setting = $db->fetchOne("SELECT setting_value FROM settings WHERE setting_key = 'university_logo_path'");
    $logo_info['database_path'] = $logo_setting ? $logo_setting['setting_value'] : 'غير موجود';
} catch (Exception $e) {
    $logo_info['database_error'] = $e->getMessage();
}

// التحقق من وجود الملف
if (!empty($logo_info['database_path']) && $logo_info['database_path'] !== 'غير موجود') {
    $logo_path = trim($logo_info['database_path']);
    $full_path = __DIR__ . '/' . ltrim($logo_path, '/');
    
    $logo_info['full_path'] = $full_path;
    $logo_info['file_exists'] = file_exists($full_path);
    $logo_info['is_file'] = is_file($full_path);
    $logo_info['readable'] = is_readable($full_path);
    
    if ($logo_info['file_exists']) {
        $logo_info['file_size'] = filesize($full_path);
        $logo_info['file_permissions'] = substr(sprintf('%o', fileperms($full_path)), -4);
    }
    
    // التحقق من المجلد
    $logo_dir = dirname($full_path);
    $logo_info['dir_exists'] = is_dir($logo_dir);
    $logo_info['dir_writable'] = is_writable($logo_dir);
    $logo_info['dir_path'] = $logo_dir;
}

include 'includes/header.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التحقق من شعار جامعة الشرق للعلوم والتكنولوجيا: Alsharg University of Science and Technology</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .info-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .info-box h3 {
            color: #667eea;
            margin-bottom: 15px;
        }
        .info-item {
            margin: 10px 0;
            padding: 10px;
            background: #f9f9f9;
            border-right: 4px solid #667eea;
        }
        .info-item strong {
            color: #333;
            display: inline-block;
            min-width: 200px;
        }
        .status-ok {
            color: green;
            font-weight: bold;
        }
        .status-error {
            color: red;
            font-weight: bold;
        }
        .logo-preview {
            text-align: center;
            margin: 20px 0;
            padding: 20px;
            background: #f9f9f9;
            border-radius: 8px;
        }
        .logo-preview img {
            max-width: 300px;
            max-height: 300px;
            border: 3px solid #667eea;
            border-radius: 8px;
            padding: 10px;
            background: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="page-header">
            <h2>التحقق من شعار الجامعة</h2>
            <a href="dashboard.php" class="btn btn-secondary">العودة</a>
            <a href="upload_university_logo.php" class="btn btn-primary">رفع/تحديث الشعار</a>
        </div>
        
        <div class="info-box">
            <h3>معلومات الشعار</h3>
            
            <div class="info-item">
                <strong>المسار في قاعدة البيانات:</strong>
                <span><?php echo htmlspecialchars($logo_info['database_path'] ?? 'غير محدد'); ?></span>
            </div>
            
            <?php if (!empty($logo_info['full_path'])): ?>
            <div class="info-item">
                <strong>المسار الكامل:</strong>
                <span><?php echo htmlspecialchars($logo_info['full_path']); ?></span>
            </div>
            
            <div class="info-item">
                <strong>الملف موجود:</strong>
                <span class="<?php echo $logo_info['file_exists'] ? 'status-ok' : 'status-error'; ?>">
                    <?php echo $logo_info['file_exists'] ? '✅ نعم' : '❌ لا'; ?>
                </span>
            </div>
            
            <?php if ($logo_info['file_exists']): ?>
            <div class="info-item">
                <strong>حجم الملف:</strong>
                <span><?php echo number_format($logo_info['file_size'] ?? 0); ?> بايت</span>
            </div>
            
            <div class="info-item">
                <strong>صلاحيات الملف:</strong>
                <span><?php echo $logo_info['file_permissions'] ?? 'غير محدد'; ?></span>
            </div>
            
            <div class="info-item">
                <strong>قابل للقراءة:</strong>
                <span class="<?php echo $logo_info['readable'] ? 'status-ok' : 'status-error'; ?>">
                    <?php echo $logo_info['readable'] ? '✅ نعم' : '❌ لا'; ?>
                </span>
            </div>
            
            <div class="info-item">
                <strong>نوع الملف:</strong>
                <span><?php echo $logo_info['is_file'] ? 'ملف' : 'مجلد أو غير ذلك'; ?></span>
            </div>
            
            <div class="logo-preview">
                <h4>معاينة الشعار:</h4>
                <?php 
                $logo_path = ltrim($logo_info['database_path'], '/');
                if ($logo_info['file_exists'] && $logo_info['readable']): 
                ?>
                    <img src="<?php echo htmlspecialchars($logo_path); ?>" alt="شعار الجامعة" onerror="this.parentElement.innerHTML += '<p style=\'color:red;\'>❌ فشل تحميل الصورة</p>'">
                    <p style="margin-top: 10px;">
                        <strong>المسار المستخدم:</strong> <?php echo htmlspecialchars($logo_path); ?>
                    </p>
                <?php else: ?>
                    <p style="color: red;">❌ لا يمكن عرض الشعار - الملف غير موجود أو غير قابل للقراءة</p>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($logo_info['dir_path'])): ?>
            <div class="info-item">
                <strong>مجلد الشعار:</strong>
                <span><?php echo htmlspecialchars($logo_info['dir_path']); ?></span>
            </div>
            
            <div class="info-item">
                <strong>المجلد موجود:</strong>
                <span class="<?php echo $logo_info['dir_exists'] ? 'status-ok' : 'status-error'; ?>">
                    <?php echo $logo_info['dir_exists'] ? '✅ نعم' : '❌ لا'; ?>
                </span>
            </div>
            
            <div class="info-item">
                <strong>المجلد قابل للكتابة:</strong>
                <span class="<?php echo $logo_info['dir_writable'] ? 'status-ok' : 'status-error'; ?>">
                    <?php echo $logo_info['dir_writable'] ? '✅ نعم' : '❌ لا'; ?>
                </span>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($logo_info['database_error'])): ?>
            <div class="info-item" style="background: #ffebee; border-color: #f44336;">
                <strong>خطأ في قاعدة البيانات:</strong>
                <span class="status-error"><?php echo htmlspecialchars($logo_info['database_error']); ?></span>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="info-box">
            <h3>إرشادات الحل</h3>
            <ul style="margin-right: 20px; line-height: 2;">
                <?php if (empty($logo_info['database_path']) || $logo_info['database_path'] === 'غير موجود'): ?>
                <li>❌ <strong>المشكلة:</strong> لا يوجد شعار مسجل في قاعدة البيانات</li>
                <li>✅ <strong>الحل:</strong> اذهب إلى <a href="upload_university_logo.php">رفع شعار الجامعة</a> وارفع الشعار</li>
                <?php elseif (!$logo_info['file_exists']): ?>
                <li>❌ <strong>المشكلة:</strong> الملف غير موجود في المسار المحدد</li>
                <li>✅ <strong>الحل:</strong> ارفع الشعار مرة أخرى من <a href="upload_university_logo.php">هنا</a></li>
                <?php elseif (!$logo_info['readable']): ?>
                <li>❌ <strong>المشكلة:</strong> الملف موجود لكن غير قابل للقراءة</li>
                <li>✅ <strong>الحل:</strong> قم بتغيير صلاحيات الملف أو ارفع الشعار مرة أخرى</li>
                <?php elseif ($logo_info['file_exists'] && $logo_info['readable']): ?>
                <li>✅ <strong>الحالة:</strong> الشعار موجود ويجب أن يظهر في الشهادة</li>
                <li>إذا لم يظهر في الشهادة، تأكد من أن المسار في الصفحة صحيح</li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

