-- نسخة احتياطية من قاعدة البيانات
-- Database Backup
-- Generated: 2025-11-20 00:58:53
-- Database: university_results

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- --------------------------------------------------------
-- Table structure for table `certificate_requests`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `certificate_requests`;
CREATE TABLE `certificate_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `certificate_type` enum('detailed','university','transcript','enrollment','graduation') COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_date` date NOT NULL,
  `status` enum('pending','approved','rejected','issued') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `rejection_reason` text COLLATE utf8mb4_unicode_ci,
  `issued_date` date DEFAULT NULL,
  `issued_by` int(11) DEFAULT NULL,
  `certificate_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `issued_by` (`issued_by`),
  CONSTRAINT `certificate_requests_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `certificate_requests_ibfk_2` FOREIGN KEY (`issued_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
-- Table structure for table `certificates`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `certificates`;
CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_request_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `certificate_type` enum('detailed','university','transcript','enrollment','graduation') COLLATE utf8mb4_unicode_ci NOT NULL,
  `certificate_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issue_date` date NOT NULL,
  `pdf_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `issued_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `certificate_number` (`certificate_number`),
  KEY `certificate_request_id` (`certificate_request_id`),
  KEY `student_id` (`student_id`),
  KEY `issued_by` (`issued_by`),
  CONSTRAINT `certificates_ibfk_1` FOREIGN KEY (`certificate_request_id`) REFERENCES `certificate_requests` (`id`) ON DELETE CASCADE,
  CONSTRAINT `certificates_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `certificates_ibfk_3` FOREIGN KEY (`issued_by`) REFERENCES `users` (`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
-- Table structure for table `colleges`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `colleges`;
CREATE TABLE `colleges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name_ar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_en` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `colleges`

INSERT INTO `colleges` (`id`, `name_ar`, `name_en`, `code`, `created_at`, `updated_at`) VALUES ('6', 'علوم الحاسوب', 'Computer Science', 'CS', '2025-11-16 07:51:32', '2025-11-16 07:51:32');

-- --------------------------------------------------------
-- Table structure for table `courses`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `courses`;
CREATE TABLE `courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `major_id` int(11) NOT NULL,
  `semester_id` int(11) DEFAULT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_ar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_en` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_hours` int(11) NOT NULL,
  `is_required` tinyint(1) DEFAULT '1',
  `is_alternative` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_course_code` (`major_id`,`code`),
  KEY `semester_id` (`semester_id`),
  CONSTRAINT `courses_ibfk_1` FOREIGN KEY (`major_id`) REFERENCES `majors` (`id`) ON DELETE CASCADE,
  CONSTRAINT `courses_ibfk_2` FOREIGN KEY (`semester_id`) REFERENCES `semesters` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `courses`

INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('3', '9', '3', 'AI001', 'الذكاء الاصطناعي', 'artificial Intelligence', '3', '1', '0', '2025-11-17 07:57:02', '2025-11-17 08:00:00');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('17', '9', '3', 'IT001', 'تقنية المعلومات_1', 'Information Technology_1', '3', '1', '0', '2025-11-17 20:45:18', '2025-11-17 20:45:18');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('18', '9', '3', 'Math01', 'الرياضيات ', 'Mathematics', '2', '1', '0', '2025-11-17 20:47:14', '2025-11-17 20:47:14');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('19', '9', '3', 'Man01', 'الادارة_1', 'management_1', '2', '1', '0', '2025-11-17 20:48:33', '2025-11-17 20:48:33');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('20', '9', '3', 'SlA01', 'الدرسات الاسلامية', 'Slamic Language', '2', '1', '0', '2025-11-17 21:00:58', '2025-11-17 21:00:58');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('21', '9', '3', 'ENG01', 'انجليزي_1', 'English_1', '2', '1', '0', '2025-11-17 21:02:29', '2025-11-17 21:02:29');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('22', '9', '3', 'ACC01', 'المحاسبة', 'Accounting', '2', '1', '0', '2025-11-17 21:03:33', '2025-11-17 21:03:33');
INSERT INTO `courses` (`id`, `major_id`, `semester_id`, `code`, `name_ar`, `name_en`, `credit_hours`, `is_required`, `is_alternative`, `created_at`, `updated_at`) VALUES ('23', '9', '3', 'STAT01', 'الاحصاء', 'ٍStatistics', '2', '1', '0', '2025-11-17 21:04:41', '2025-11-17 21:04:41');

-- --------------------------------------------------------
-- Table structure for table `cumulative_gpas`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `cumulative_gpas`;
CREATE TABLE `cumulative_gpas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `total_credit_hours` decimal(5,2) NOT NULL,
  `total_points` decimal(10,2) NOT NULL,
  `cgpa` decimal(4,2) NOT NULL,
  `calculated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_student_cgpa` (`student_id`),
  CONSTRAINT `cumulative_gpas_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `cumulative_gpas`

INSERT INTO `cumulative_gpas` (`id`, `student_id`, `total_credit_hours`, `total_points`, `cgpa`, `calculated_at`) VALUES ('4', '6', '16.00', '64.00', '4.00', '2025-11-19 22:39:00');
INSERT INTO `cumulative_gpas` (`id`, `student_id`, `total_credit_hours`, `total_points`, `cgpa`, `calculated_at`) VALUES ('8', '7', '13.00', '39.50', '3.04', '2025-11-19 22:39:00');
INSERT INTO `cumulative_gpas` (`id`, `student_id`, `total_credit_hours`, `total_points`, `cgpa`, `calculated_at`) VALUES ('16', '8', '16.00', '33.00', '2.06', '2025-11-19 22:39:00');
INSERT INTO `cumulative_gpas` (`id`, `student_id`, `total_credit_hours`, `total_points`, `cgpa`, `calculated_at`) VALUES ('17', '9', '18.00', '44.00', '2.44', '2025-11-19 22:39:00');

-- --------------------------------------------------------
-- Table structure for table `fees`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `fees`;
CREATE TABLE `fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `semester_id` int(11) NOT NULL,
  `fee_type` enum('tuition','registration','other') COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `due_date` date DEFAULT NULL,
  `paid_amount` decimal(10,2) DEFAULT '0.00',
  `payment_date` date DEFAULT NULL,
  `payment_status` enum('pending','partial','paid') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `semester_id` (`semester_id`),
  CONSTRAINT `fees_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fees_ibfk_2` FOREIGN KEY (`semester_id`) REFERENCES `semesters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `fees`

INSERT INTO `fees` (`id`, `student_id`, `semester_id`, `fee_type`, `amount`, `due_date`, `paid_amount`, `payment_date`, `payment_status`, `notes`, `created_at`, `updated_at`) VALUES ('1', '7', '3', 'tuition', '5000.00', '2025-10-29', '5000.00', '2025-11-18', 'paid', NULL, '2025-11-18 19:54:37', '2025-11-18 19:55:06');

-- --------------------------------------------------------
-- Table structure for table `grades`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `grades`;
CREATE TABLE `grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_course_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `semester_id` int(11) NOT NULL,
  `marks` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `letter_grade` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` decimal(3,2) DEFAULT NULL,
  `calibrated_marks` decimal(5,2) DEFAULT NULL,
  `calibrated_letter_grade` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calibrated_points` decimal(3,2) DEFAULT NULL,
  `calibration_target_mean` decimal(5,2) DEFAULT NULL,
  `calibration_target_std` decimal(5,2) DEFAULT NULL,
  `calibrated_at` timestamp NULL DEFAULT NULL,
  `calibrated_by` int(11) DEFAULT NULL,
  `entered_by` int(11) NOT NULL,
  `entered_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_student_course_grade` (`student_course_id`),
  KEY `student_id` (`student_id`),
  KEY `course_id` (`course_id`),
  KEY `semester_id` (`semester_id`),
  KEY `entered_by` (`entered_by`),
  KEY `calibrated_by` (`calibrated_by`),
  CONSTRAINT `grades_ibfk_1` FOREIGN KEY (`student_course_id`) REFERENCES `student_courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `grades_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `grades_ibfk_3` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `grades_ibfk_4` FOREIGN KEY (`semester_id`) REFERENCES `semesters` (`id`) ON DELETE CASCADE,
  CONSTRAINT `grades_ibfk_5` FOREIGN KEY (`entered_by`) REFERENCES `users` (`id`) ON DELETE RESTRICT,
  CONSTRAINT `grades_ibfk_6` FOREIGN KEY (`calibrated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `grades`

INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('4', '3', '6', '3', '3', '85', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 08:42:34', '2025-11-19 22:31:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('5', '4', '7', '3', '3', 'بد', 'بد', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 10:19:19', '2025-11-19 22:31:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('6', '5', '6', '22', '3', 'بد', 'بد', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:06:34', '2025-11-19 20:45:07');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('7', '6', '7', '22', '3', '98', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:06:53', '2025-11-19 20:45:07');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('8', '10', '7', '17', '3', '73.0', 'B+', '3.50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:10:45', '2025-11-18 13:39:11');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('9', '9', '6', '17', '3', '83.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:10:56', '2025-11-18 13:39:11');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('10', '11', '6', '18', '3', '87.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:52:01', '2025-11-18 13:39:30');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('11', '12', '7', '18', '3', '73.0', 'B+', '3.50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:52:01', '2025-11-18 13:39:30');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('12', '33', '8', '18', '3', '66.0', 'B', '3.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:52:01', '2025-11-18 13:39:30');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('13', '34', '9', '18', '3', '84.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-17 21:52:01', '2025-11-18 13:39:30');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('14', '19', '8', '22', '3', '76', 'B+', '3.50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:04:17', '2025-11-19 20:45:07');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('15', '20', '9', '22', '3', 'غ', 'F', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:04:34', '2025-11-19 20:45:07');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('16', '21', '8', '3', '3', '45', 'F', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:05:59', '2025-11-19 22:31:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('17', '22', '9', '3', '3', '34', 'F', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:06:09', '2025-11-19 22:31:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('18', '7', '6', '21', '3', '86', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:07:07', '2025-11-19 22:35:05');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('19', '8', '7', '21', '3', 'بد', 'بد', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:07:19', '2025-11-19 22:35:05');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('20', '23', '8', '21', '3', '65', 'B', '3.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:07:30', '2025-11-19 22:35:05');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('21', '24', '9', '21', '3', '35', 'F', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:07:42', '2025-11-19 22:35:05');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('22', '25', '8', '17', '3', '63.0', 'C', '2.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:08:18', '2025-11-18 13:39:11');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('23', '26', '9', '17', '3', '84.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:08:29', '2025-11-18 13:39:11');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('24', '13', '6', '19', '3', '84', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:10:11', '2025-11-19 22:39:00');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('25', '14', '7', '19', '3', '45', 'F', '0.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:10:21', '2025-11-19 22:39:00');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('26', '27', '8', '19', '3', 'بد', 'بد', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:10:31', '2025-11-19 22:39:00');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('27', '28', '9', '19', '3', '85', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:10:48', '2025-11-19 22:39:00');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('28', '17', '6', '23', '3', '83.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:12:35', '2025-11-18 13:39:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('29', '18', '7', '23', '3', '74.0', 'B+', '3.50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:12:45', '2025-11-18 13:39:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('30', '31', '8', '23', '3', '64.0', 'C', '2.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:12:55', '2025-11-18 13:39:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('31', '32', '9', '23', '3', '85.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:13:04', '2025-11-18 13:39:50');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('32', '15', '6', '20', '3', '85.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:15:19', '2025-11-18 13:39:41');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('33', '16', '7', '20', '3', '76.0', 'B+', '3.50', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:15:19', '2025-11-18 13:39:41');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('34', '29', '8', '20', '3', '63.0', 'C', '2.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:15:19', '2025-11-18 13:39:41');
INSERT INTO `grades` (`id`, `student_course_id`, `student_id`, `course_id`, `semester_id`, `marks`, `letter_grade`, `points`, `calibrated_marks`, `calibrated_letter_grade`, `calibrated_points`, `calibration_target_mean`, `calibration_target_std`, `calibrated_at`, `calibrated_by`, `entered_by`, `entered_at`, `updated_at`) VALUES ('35', '30', '9', '20', '3', '86.0', 'A', '4.00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '12', '2025-11-18 07:15:19', '2025-11-18 13:39:41');

-- --------------------------------------------------------
-- Table structure for table `majors`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `majors`;
CREATE TABLE `majors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `college_id` int(11) NOT NULL,
  `name_ar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_en` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_semesters` int(11) NOT NULL DEFAULT '8',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_major_code` (`college_id`,`code`),
  CONSTRAINT `majors_ibfk_1` FOREIGN KEY (`college_id`) REFERENCES `colleges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `majors`

INSERT INTO `majors` (`id`, `college_id`, `name_ar`, `name_en`, `code`, `total_semesters`, `created_at`, `updated_at`) VALUES ('9', '6', 'تقنية المعلومات', 'Information Technology', 'IT', '8', '2025-11-16 07:52:42', '2025-11-16 07:52:42');

-- --------------------------------------------------------
-- Table structure for table `permissions`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` enum('admin','college_admin','registrar','instructor','student') COLLATE utf8mb4_unicode_ci NOT NULL,
  `permission_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_role_permission` (`role`,`permission_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `permissions`

INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('1', 'admin', 'all_access', 'وصول كامل للنظام');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('2', 'college_admin', 'manage_college', 'إدارة الكلية');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('3', 'college_admin', 'view_reports', 'عرض التقارير');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('4', 'registrar', 'manage_students', 'إدارة الطلاب');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('5', 'registrar', 'manage_grades', 'إدارة الدرجات');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('6', 'registrar', 'issue_certificates', 'إصدار الشهادات');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('7', 'instructor', 'view_students', 'عرض الطلاب');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('8', 'instructor', 'enter_grades', 'إدخال الدرجات');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('9', 'student', 'view_grades', 'عرض الدرجات');
INSERT INTO `permissions` (`id`, `role`, `permission_name`, `description`) VALUES ('10', 'student', 'request_certificates', 'طلب الشهادات');

-- --------------------------------------------------------
-- Table structure for table `semester_calibrations`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `semester_calibrations`;
CREATE TABLE `semester_calibrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `semester_id` int(11) NOT NULL,
  `target_mean` decimal(5,2) NOT NULL,
  `target_std` decimal(5,2) NOT NULL,
  `calibrated_by` int(11) NOT NULL,
  `calibrated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_semester_calibration` (`semester_id`),
  KEY `calibrated_by` (`calibrated_by`),
  CONSTRAINT `semester_calibrations_ibfk_1` FOREIGN KEY (`semester_id`) REFERENCES `semesters` (`id`) ON DELETE CASCADE,
  CONSTRAINT `semester_calibrations_ibfk_2` FOREIGN KEY (`calibrated_by`) REFERENCES `users` (`id`) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
-- Table structure for table `semester_gpas`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `semester_gpas`;
CREATE TABLE `semester_gpas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `semester_id` int(11) NOT NULL,
  `total_credit_hours` decimal(5,2) NOT NULL,
  `total_points` decimal(10,2) NOT NULL,
  `gpa` decimal(4,2) NOT NULL,
  `calculated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_student_semester_gpa` (`student_id`,`semester_id`),
  KEY `semester_id` (`semester_id`),
  CONSTRAINT `semester_gpas_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `semester_gpas_ibfk_2` FOREIGN KEY (`semester_id`) REFERENCES `semesters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `semester_gpas`

INSERT INTO `semester_gpas` (`id`, `student_id`, `semester_id`, `total_credit_hours`, `total_points`, `gpa`, `calculated_at`) VALUES ('4', '6', '3', '16.00', '64.00', '4.00', '2025-11-19 22:39:00');
INSERT INTO `semester_gpas` (`id`, `student_id`, `semester_id`, `total_credit_hours`, `total_points`, `gpa`, `calculated_at`) VALUES ('8', '7', '3', '13.00', '39.50', '3.04', '2025-11-19 22:39:00');
INSERT INTO `semester_gpas` (`id`, `student_id`, `semester_id`, `total_credit_hours`, `total_points`, `gpa`, `calculated_at`) VALUES ('16', '8', '3', '16.00', '33.00', '2.06', '2025-11-19 22:39:00');
INSERT INTO `semester_gpas` (`id`, `student_id`, `semester_id`, `total_credit_hours`, `total_points`, `gpa`, `calculated_at`) VALUES ('17', '9', '3', '18.00', '44.00', '2.44', '2025-11-19 22:39:00');

-- --------------------------------------------------------
-- Table structure for table `semesters`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `semesters`;
CREATE TABLE `semesters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `major_id` int(11) NOT NULL,
  `semester_number` int(11) NOT NULL,
  `academic_year` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_semester` (`major_id`,`semester_number`,`academic_year`),
  CONSTRAINT `semesters_ibfk_1` FOREIGN KEY (`major_id`) REFERENCES `majors` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `semesters`

INSERT INTO `semesters` (`id`, `major_id`, `semester_number`, `academic_year`, `start_date`, `end_date`, `is_active`, `created_at`, `updated_at`) VALUES ('3', '9', '1', '2024-2025', '2025-11-15', '2025-02-15', '1', '2025-11-16 07:54:23', '2025-11-16 07:54:23');

-- --------------------------------------------------------
-- Table structure for table `student_courses`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `student_courses`;
CREATE TABLE `student_courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `semester_id` int(11) NOT NULL,
  `registration_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_student_course_semester` (`student_id`,`course_id`,`semester_id`),
  KEY `course_id` (`course_id`),
  KEY `semester_id` (`semester_id`),
  CONSTRAINT `student_courses_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `student_courses_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `student_courses_ibfk_3` FOREIGN KEY (`semester_id`) REFERENCES `semesters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `student_courses`

INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('3', '6', '3', '3', '2025-11-17', '2025-11-17 08:23:34');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('4', '7', '3', '3', '2025-11-17', '2025-11-17 10:18:34');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('5', '6', '22', '3', '2025-11-17', '2025-11-17 21:05:14');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('6', '7', '22', '3', '2025-11-17', '2025-11-17 21:05:14');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('7', '6', '21', '3', '2025-11-17', '2025-11-17 21:08:45');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('8', '7', '21', '3', '2025-11-17', '2025-11-17 21:08:45');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('9', '6', '17', '3', '2025-11-17', '2025-11-17 21:09:34');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('10', '7', '17', '3', '2025-11-17', '2025-11-17 21:09:34');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('11', '6', '18', '3', '2025-11-17', '2025-11-17 21:12:06');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('12', '7', '18', '3', '2025-11-17', '2025-11-17 21:12:06');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('13', '6', '19', '3', '2025-11-17', '2025-11-17 21:12:35');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('14', '7', '19', '3', '2025-11-17', '2025-11-17 21:12:35');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('15', '6', '20', '3', '2025-11-17', '2025-11-17 21:13:31');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('16', '7', '20', '3', '2025-11-17', '2025-11-17 21:13:31');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('17', '6', '23', '3', '2025-11-17', '2025-11-17 21:14:15');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('18', '7', '23', '3', '2025-11-17', '2025-11-17 21:14:15');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('19', '8', '22', '3', '2025-11-17', '2025-11-17 21:29:00');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('20', '9', '22', '3', '2025-11-17', '2025-11-17 21:29:00');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('21', '8', '3', '3', '2025-11-17', '2025-11-17 21:29:26');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('22', '9', '3', '3', '2025-11-17', '2025-11-17 21:29:26');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('23', '8', '21', '3', '2025-11-17', '2025-11-17 21:29:49');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('24', '9', '21', '3', '2025-11-17', '2025-11-17 21:29:49');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('25', '8', '17', '3', '2025-11-17', '2025-11-17 21:32:33');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('26', '9', '17', '3', '2025-11-17', '2025-11-17 21:32:33');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('27', '8', '19', '3', '2025-11-17', '2025-11-17 21:32:58');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('28', '9', '19', '3', '2025-11-17', '2025-11-17 21:32:58');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('29', '8', '20', '3', '2025-11-17', '2025-11-17 21:34:37');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('30', '9', '20', '3', '2025-11-17', '2025-11-17 21:34:37');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('31', '8', '23', '3', '2025-11-17', '2025-11-17 21:34:57');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('32', '9', '23', '3', '2025-11-17', '2025-11-17 21:34:57');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('33', '8', '18', '3', '2025-11-17', '2025-11-17 21:37:39');
INSERT INTO `student_courses` (`id`, `student_id`, `course_id`, `semester_id`, `registration_date`, `created_at`) VALUES ('34', '9', '18', '3', '2025-11-17', '2025-11-17 21:37:39');

-- --------------------------------------------------------
-- Table structure for table `students`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `students`;
CREATE TABLE `students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `college_id` int(11) NOT NULL,
  `major_id` int(11) NOT NULL,
  `student_number` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `national_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_name_ar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name_en` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `enrollment_date` date NOT NULL,
  `graduation_date` date DEFAULT NULL,
  `status` enum('active','graduated','suspended','withdrawn') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `student_number` (`student_number`),
  UNIQUE KEY `national_id` (`national_id`),
  KEY `college_id` (`college_id`),
  KEY `major_id` (`major_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `students_ibfk_1` FOREIGN KEY (`college_id`) REFERENCES `colleges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `students_ibfk_2` FOREIGN KEY (`major_id`) REFERENCES `majors` (`id`) ON DELETE CASCADE,
  CONSTRAINT `students_ibfk_3` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `students`

INSERT INTO `students` (`id`, `college_id`, `major_id`, `student_number`, `national_id`, `full_name_ar`, `full_name_en`, `email`, `phone`, `address`, `enrollment_date`, `graduation_date`, `status`, `user_id`, `created_at`, `updated_at`) VALUES ('6', '6', '9', '24001', '77799882', 'هاشم جمال خالد محمد', 'Hashim Gamal Khalid Mohammed', '', '', NULL, '2025-11-16', NULL, 'active', NULL, '2025-11-16 08:09:24', '2025-11-16 08:09:24');
INSERT INTO `students` (`id`, `college_id`, `major_id`, `student_number`, `national_id`, `full_name_ar`, `full_name_en`, `email`, `phone`, `address`, `enrollment_date`, `graduation_date`, `status`, `user_id`, `created_at`, `updated_at`) VALUES ('7', '6', '9', '25005', '899774', 'ابوبكر محمد عبدالصادق', 'abubaker ', 'gffd@gmail.com', '7664447448', NULL, '2025-11-17', NULL, 'active', '13', '2025-11-17 10:17:55', '2025-11-17 10:17:55');
INSERT INTO `students` (`id`, `college_id`, `major_id`, `student_number`, `national_id`, `full_name_ar`, `full_name_en`, `email`, `phone`, `address`, `enrollment_date`, `graduation_date`, `status`, `user_id`, `created_at`, `updated_at`) VALUES ('8', '6', '9', '25023', '54883', 'جمال قاسم ضوى البيت', 'Gamal', '', '', NULL, '2025-11-17', NULL, 'active', '14', '2025-11-17 21:27:01', '2025-11-17 21:27:01');
INSERT INTO `students` (`id`, `college_id`, `major_id`, `student_number`, `national_id`, `full_name_ar`, `full_name_en`, `email`, `phone`, `address`, `enrollment_date`, `graduation_date`, `status`, `user_id`, `created_at`, `updated_at`) VALUES ('9', '6', '9', '25033', '6987', 'على موسى محمد', 'ِِAli', '', '', NULL, '2025-11-17', NULL, 'active', '15', '2025-11-17 21:28:21', '2025-11-17 21:28:21');

-- --------------------------------------------------------
-- Table structure for table `users`
-- --------------------------------------------------------

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `college_id` int(11) NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name_ar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name_en` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role` enum('admin','college_admin','registrar','instructor','student') COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `college_id` (`college_id`),
  CONSTRAINT `users_ibfk_1` FOREIGN KEY (`college_id`) REFERENCES `colleges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `users`

INSERT INTO `users` (`id`, `college_id`, `username`, `password`, `full_name_ar`, `full_name_en`, `email`, `role`, `is_active`, `created_at`, `updated_at`) VALUES ('12', '6', 'admin', '$2y$10$BW2nyL.5d1SswZSZjSQnj.f16dBBGTSvdtLDOxCvQrxdaa/GqGRjW', 'مدير النظام', NULL, NULL, 'admin', '1', '2025-11-16 19:31:50', '2025-11-16 19:31:50');
INSERT INTO `users` (`id`, `college_id`, `username`, `password`, `full_name_ar`, `full_name_en`, `email`, `role`, `is_active`, `created_at`, `updated_at`) VALUES ('13', '6', 'STU25005', '$2y$10$O/xfMwm3vUkTwDdbfrTv4.l7wq8dIuqP3AXGpxRcet41Tt77.Xx1a', 'ابوبكر محمد عبدالصادق', 'abubaker ', 'gffd@gmail.com', 'student', '1', '2025-11-17 10:17:55', '2025-11-17 10:17:55');
INSERT INTO `users` (`id`, `college_id`, `username`, `password`, `full_name_ar`, `full_name_en`, `email`, `role`, `is_active`, `created_at`, `updated_at`) VALUES ('14', '6', 'STU25023', '$2y$10$1CmpHEerAI3tskOt6KFfR.pFKP9U0d2kJ3dzvU4NXfcLIzQpBZpoG', 'جمال قاسم ضوى البيت', 'Gamal', '', 'student', '1', '2025-11-17 21:27:01', '2025-11-17 21:27:01');
INSERT INTO `users` (`id`, `college_id`, `username`, `password`, `full_name_ar`, `full_name_en`, `email`, `role`, `is_active`, `created_at`, `updated_at`) VALUES ('15', '6', 'STU25033', '$2y$10$48kkc6ex66nOj816mBE2M.7Vn6ieQs06p.VyVHokh2LtelHgS1Ova', 'على موسى محمد', 'ِِAli', '', 'student', '1', '2025-11-17 21:28:21', '2025-11-17 21:28:21');

COMMIT;
