<?php
/**
 * إدخال 8 فصول تجريبية لتخصص تقنية المعلومات
 * Add 8 Test Semesters for Information Technology Major
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Auth.php';

$auth = new Auth();
if (!$auth->isLoggedIn() || (!$auth->hasRole('admin') && !$auth->hasRole('college_admin'))) {
    die('ليس لديك صلاحية للوصول إلى هذه الصفحة');
}

$db = Database::getInstance();
$message = '';

// البحث عن تخصص تقنية المعلومات
$it_major = $db->fetchOne(
    "SELECT * FROM majors WHERE name_ar LIKE '%تقنية المعلومات%' OR name_ar LIKE '%تكنولوجيا المعلومات%' OR name_en LIKE '%Information Technology%' OR name_en LIKE '%IT%' LIMIT 1"
);

if (!$it_major) {
    // إنشاء تخصص تقنية المعلومات إذا لم يكن موجوداً
    // أولاً نحتاج كلية - نبحث عن كلية أو نستخدم الأولى
    $college = $db->fetchOne("SELECT * FROM colleges LIMIT 1");
    
    if (!$college) {
        die('لا توجد كلية في النظام. يجب إنشاء كلية أولاً.');
    }
    
    // إنشاء التخصص
    $db->query(
        "INSERT INTO majors (college_id, name_ar, name_en, code) VALUES (?, ?, ?, ?)",
        [$college['id'], 'تقنية المعلومات', 'Information Technology', 'IT']
    );
    
    $it_major = $db->fetchOne(
        "SELECT * FROM majors WHERE name_ar = ?",
        ['تقنية المعلومات']
    );
}

if (!$it_major) {
    die('فشل إنشاء أو العثور على تخصص تقنية المعلومات');
}

// معالجة إدخال الفصول
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_semesters') {
    try {
        $db->getConnection()->beginTransaction();
        
        $semesters_data = [
            ['semester_number' => 1, 'academic_year' => '2020-2021', 'start_date' => '2020-09-01', 'end_date' => '2021-01-31'],
            ['semester_number' => 2, 'academic_year' => '2020-2021', 'start_date' => '2021-02-01', 'end_date' => '2021-06-30'],
            ['semester_number' => 3, 'academic_year' => '2021-2022', 'start_date' => '2021-09-01', 'end_date' => '2022-01-31'],
            ['semester_number' => 4, 'academic_year' => '2021-2022', 'start_date' => '2022-02-01', 'end_date' => '2022-06-30'],
            ['semester_number' => 5, 'academic_year' => '2022-2023', 'start_date' => '2022-09-01', 'end_date' => '2023-01-31'],
            ['semester_number' => 6, 'academic_year' => '2022-2023', 'start_date' => '2023-02-01', 'end_date' => '2023-06-30'],
            ['semester_number' => 7, 'academic_year' => '2023-2024', 'start_date' => '2023-09-01', 'end_date' => '2024-01-31'],
            ['semester_number' => 8, 'academic_year' => '2023-2024', 'start_date' => '2024-02-01', 'end_date' => '2024-06-30'],
        ];
        
        $added_count = 0;
        $skipped_count = 0;
        
        foreach ($semesters_data as $sem_data) {
            // التحقق من وجود الفصل
            $existing = $db->fetchOne(
                "SELECT * FROM semesters 
                 WHERE major_id = ? AND semester_number = ? AND academic_year = ?",
                [$it_major['id'], $sem_data['semester_number'], $sem_data['academic_year']]
            );
            
            if ($existing) {
                $skipped_count++;
                continue;
            }
            
            // إضافة الفصل
            $db->query(
                "INSERT INTO semesters (major_id, semester_number, academic_year, start_date, end_date, is_active)
                 VALUES (?, ?, ?, ?, ?, 1)",
                [
                    $it_major['id'],
                    $sem_data['semester_number'],
                    $sem_data['academic_year'],
                    $sem_data['start_date'],
                    $sem_data['end_date']
                ]
            );
            
            $added_count++;
        }
        
        $db->getConnection()->commit();
        
        $message = '<div class="alert alert-success">✓ تم إضافة ' . $added_count . ' فصل دراسي بنجاح';
        if ($skipped_count > 0) {
            $message .= ' (تم تخطي ' . $skipped_count . ' فصل موجود مسبقاً)';
        }
        $message .= '</div>';
        
    } catch (Exception $e) {
        $db->getConnection()->rollBack();
        $message = '<div class="alert alert-error">✗ خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
        error_log("Error adding semesters: " . $e->getMessage());
    }
}

// جلب الفصول الموجودة
$existing_semesters = $db->fetchAll(
    "SELECT * FROM semesters WHERE major_id = ? ORDER BY academic_year, semester_number",
    [$it_major['id']]
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدخال فصول تجريبية - تقنية المعلومات</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .info-box {
            background: #e3f2fd;
            border-right: 5px solid #2196F3;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        .semesters-list {
            margin-top: 20px;
        }
        .semester-item {
            padding: 10px;
            margin: 5px 0;
            background: #f9f9f9;
            border-right: 3px solid #667eea;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h2>إدخال 8 فصول تجريبية لتخصص تقنية المعلومات</h2>
            <a href="semesters.php" class="btn btn-secondary">العودة للفصول الدراسية</a>
        </div>
        
        <?php echo $message; ?>
        
        <div class="info-box">
            <strong>📋 معلومات التخصص:</strong>
            <p>التخصص: <?php echo htmlspecialchars($it_major['name_ar']); ?> (<?php echo htmlspecialchars($it_major['code']); ?>)</p>
            <p>الكلية: <?php 
                $college = $db->fetchOne("SELECT name_ar FROM colleges WHERE id = ?", [$it_major['college_id']]);
                echo htmlspecialchars($college['name_ar'] ?? 'غير محدد');
            ?></p>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3>الفصول التي سيتم إضافتها:</h3>
            </div>
            <div style="padding: 20px;">
                <ol style="margin-right: 20px;">
                    <li>فصل 1 - 2020-2021</li>
                    <li>فصل 2 - 2020-2021</li>
                    <li>فصل 3 - 2021-2022</li>
                    <li>فصل 4 - 2021-2022</li>
                    <li>فصل 5 - 2022-2023</li>
                    <li>فصل 6 - 2022-2023</li>
                    <li>فصل 7 - 2023-2024</li>
                    <li>فصل 8 - 2023-2024</li>
                </ol>
                
                <form method="POST" style="margin-top: 20px;">
                    <input type="hidden" name="action" value="add_semesters">
                    <button type="submit" class="btn btn-primary" style="padding: 12px 30px; font-size: 16px;">
                        ✅ إضافة الفصول التجريبية
                    </button>
                </form>
            </div>
        </div>
        
        <?php if (!empty($existing_semesters)): ?>
            <div class="card semesters-list">
                <div class="card-header">
                    <h3>الفصول الموجودة حالياً:</h3>
                </div>
                <div style="padding: 20px;">
                    <?php foreach ($existing_semesters as $sem): ?>
                        <div class="semester-item">
                            <strong>فصل <?php echo $sem['semester_number']; ?></strong> - 
                            <?php echo htmlspecialchars($sem['academic_year']); ?> - 
                            الحالة: <?php echo (isset($sem['is_active']) && $sem['is_active']) ? 'نشط' : 'غير نشط'; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>

