# دليل تحميل البيانات التجريبية

## الطريقة الأولى: استخدام السكريبت (موصى به)

قم بتشغيل السكريبت التالي من سطر الأوامر:

```bash
php load_sample_data.php
```

أو من المتصفح:
```
http://localhost/GUNS/load_sample_data.php
```

## الطريقة الثانية: استخدام MySQL مباشرة

```bash
mysql -u root -p university_results < database/sample_data.sql
```

أو من phpMyAdmin:
1. افتح phpMyAdmin
2. اختر قاعدة البيانات `university_results`
3. اضغط على تبويب "استيراد" (Import)
4. اختر ملف `database/sample_data.sql`
5. اضغط "تنفيذ" (Go)

## البيانات المتضمنة

### المستخدمون
- **admin** / admin123 - مدير عام
- **college_admin1** / admin123 - مدير كلية الهندسة
- **college_admin2** / admin123 - مدير كلية العلوم
- **registrar1** / admin123 - مسجل كلية الهندسة
- **registrar2** / admin123 - مسجل كلية العلوم
- **instructor1** / admin123 - أستاذ
- **instructor2** / admin123 - أستاذة
- **STU20231001** / admin123 - طالب (محمد أحمد)
- **STU20231002** / admin123 - طالبة (فاطمة سعيد)
- **STU20231003** / admin123 - طالب (خالد عبدالله)
- **STU20231004** / admin123 - طالبة (نورا حسن)

### التخصصات
- هندسة الحاسوب (CE) - كلية الهندسة
- هندسة البرمجيات (SE) - كلية الهندسة
- هندسة الشبكات (NE) - كلية الهندسة
- علوم الحاسوب (CS) - كلية العلوم
- الرياضيات (MATH) - كلية العلوم
- الفيزياء (PHY) - كلية العلوم
- اللغة العربية (AR) - كلية الآداب
- اللغة الإنجليزية (EN) - كلية الآداب
- المحاسبة (ACC) - كلية التجارة
- إدارة الأعمال (BA) - كلية التجارة

### الفصول الدراسية
- فصول دراسية متعددة لكل تخصص
- بعض الفصول نشطة وبعضها منتهية

### المواد الدراسية
- مواد لكل فصل دراسي
- مواد إجبارية واختيارية
- ساعات معتمدة مختلفة

### الطلاب
- 8 طلاب في تخصصات مختلفة
- بيانات كاملة لكل طالب

### الدرجات
- درجات للطلاب في مواد مختلفة
- درجات في فصول متعددة
- معدلات فصولية وتراكمية

### الرسوم
- رسوم دراسية لكل فصل
- حالات مختلفة: مسدد، جزئي، غير مسدد

### طلبات الشهادات
- طلبات شهادات مختلفة
- حالات مختلفة: معلق، موافق عليه

## ملاحظات مهمة

1. **كلمات المرور**: جميع كلمات المرور هي `admin123` (يجب تغييرها في الإنتاج)
2. **المعدلات**: سيتم حسابها تلقائياً عند الوصول لصفحات الطلاب
3. **التكرار**: يمكن تشغيل السكريبت عدة مرات دون مشاكل (سيتم تجاهل البيانات المكررة)

## بعد التحميل

1. سجل دخول كمدير عام واختبر النظام
2. سجل دخول كطالب واختبر عرض الدرجات
3. سجل دخول كمسجل واختبر إدخال الدرجات
4. جرب طلب شهادة كطالب
5. جرب الموافقة على طلب شهادة كمسجل

## استكشاف الأخطاء

إذا واجهت مشاكل:
1. تأكد من تشغيل `schema.sql` أولاً
2. تحقق من إعدادات الاتصال في `config/database.php`
3. تأكد من أن قاعدة البيانات موجودة
4. راجع رسائل الخطأ في السكريبت

