# نظام نتائج الجامعة
## University Results System

نظام شامل لإدارة نتائج الطلاب في الجامعة مع دعم متعدد الكليات والتخصصات والفصول الدراسية.

## المميزات الرئيسية

### 1. إدارة الكليات والتخصصات
- إدارة متعددة الكليات
- كل كلية تحتوي على تخصصات متعددة
- كل تخصص يحتوي على فصول دراسية قابلة للتخصيص

### 2. نظام الفصول الدراسية
- فصل كل فصل دراسي بشكل منفصل
- ربط الفصول بالسنوات الدراسية (كل سنتين في سنة دراسية)
- إدارة المواد الدراسية لكل فصل

### 3. حساب المعدلات
- **المعدل الفصلي**: يحسب لكل فصل دراسي على حدة
  - الصيغة: مجموع (عدد الساعات × النقاط) / مجموع الساعات
- **المعدل التراكمي**: يحسب لجميع الفصول الدراسية
  - نفس الصيغة ولكن لجميع الفصول

### 4. نظام الدرجات
- A: 80-100 → 4 نقاط
- B+: 70-79 → 3.5 نقاط
- B: 65-69 → 3 نقاط
- C: 55-64 → 2 نقاط
- D: 50-54 → 1 نقطة
- F: أقل من 50 → 0 نقاط

### 5. الأمان والصلاحيات
- **عزل الكليات**: كل مستخدم لا يستطيع الوصول إلا لكلية واحدة
- **نظام الصلاحيات**:
  - Admin: وصول كامل
  - College Admin: إدارة الكلية
  - Registrar: إدارة الطلاب والدرجات
  - Instructor: إدخال الدرجات
  - Student: عرض الدرجات وطلب الشهادات

### 6. نظام الشهادات
- أنواع الشهادات:
  - شهادة تفاصيل
  - شهادة جامعية
  - كشف درجات
  - شهادة قيد
  - شهادة تخرج
- التحقق من سداد الرسوم قبل إصدار الشهادات
- التقديم الإلكتروني للشهادات

### 7. إدارة الرسوم
- تتبع الرسوم الدراسية لكل فصل
- التحقق من السداد قبل إصدار الشهادات

## متطلبات التشغيل

- PHP 7.4 أو أحدث
- MySQL 5.7 أو أحدث
- Apache مع mod_rewrite
- PDO extension

## التثبيت

### 1. رفع الملفات
قم برفع جميع الملفات إلى مجلد الويب الخاص بك (مثل `www/GUNS`)

### 2. إنشاء قاعدة البيانات
```bash
mysql -u root -p < database/schema.sql
```

أو قم بتشغيل ملف `database/schema.sql` من phpMyAdmin

### 3. إعداد الاتصال بقاعدة البيانات
قم بتعديل ملف `config/database.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('DB_NAME', 'university_results');
```

### 4. إعدادات الأمان
- تأكد من أن مجلدات `uploads/` و `certificates/` قابلة للكتابة
- قم بتغيير كلمة مرور المستخدم الافتراضي بعد أول تسجيل دخول

### 5. تسجيل الدخول الافتراضي
- **اسم المستخدم**: admin
- **كلمة المرور**: admin123

**⚠️ مهم**: قم بتغيير كلمة المرور فوراً بعد أول تسجيل دخول!

## هيكل المشروع

```
GUNS/
├── assets/
│   └── css/
│       └── style.css
├── classes/
│   ├── Auth.php
│   ├── CertificateGenerator.php
│   └── GradeCalculator.php
├── config/
│   ├── config.php
│   └── database.php
├── database/
│   └── schema.sql
├── includes/
│   ├── footer.php
│   └── header.php
├── certificates/ (سيتم إنشاؤه تلقائياً)
├── uploads/ (سيتم إنشاؤه تلقائياً)
├── .htaccess
├── certificate_requests.php
├── colleges.php
├── courses.php
├── dashboard.php
├── grades.php
├── index.php
├── logout.php
├── majors.php
├── register_courses.php
├── semesters.php
├── student_certificates.php
├── student_details.php
├── student_grades.php
├── students.php
└── view_certificate.php
```

## الاستخدام

### للمدير العام (Admin)
1. إدارة جميع الكليات
2. إنشاء مستخدمين جدد
3. الوصول لجميع البيانات

### لمدير الكلية (College Admin)
1. إدارة التخصصات والفصول في الكلية
2. إدارة الطلاب والمواد
3. الموافقة على طلبات الشهادات

### للمسجل (Registrar)
1. إضافة الطلاب
2. تسجيل الطلاب في المواد
3. إدخال الدرجات
4. إصدار الشهادات

### للأستاذ (Instructor)
1. عرض قوائم الطلاب
2. إدخال الدرجات

### للطالب (Student)
1. عرض الدرجات والمعدلات
2. طلب الشهادات عبر الإنترنت
3. عرض الشهادات الصادرة

## الأمان

- جميع كلمات المرور مشفرة باستخدام bcrypt
- حماية من SQL Injection باستخدام Prepared Statements
- عزل البيانات بين الكليات
- حماية من XSS
- جلسات آمنة مع timeout تلقائي

## الدعم

للمساعدة والدعم، يرجى التواصل مع فريق التطوير.

## الترخيص

هذا المشروع مخصص للاستخدام الداخلي في الجامعة.

