# حل سريع لمشكلة كلمة مرور MySQL

## المشكلة الحالية
```
Access denied for user 'root'@'localhost' (using password: YES)
```
هذا يعني أن كلمة المرور `'root'` غير صحيحة.

## الحل السريع (3 خطوات)

### الخطوة 1: اختبار كلمات المرور
افتح في المتصفح:
```
http://localhost/GUNS/test_mysql_connection.php
```

هذا السكريبت سيجرب كلمات المرور الشائعة ويحدّث الملف تلقائياً إذا وجد كلمة صحيحة.

---

### الخطوة 2: إذا لم ينجح - إعادة تعيين كلمة المرور

#### الطريقة الأسهل: من AppServ Control Panel
1. افتح **AppServ Control Panel**
2. ابحث عن خيار **"MySQL Password"** أو **"Change Password"**
3. عيّن كلمة مرور جديدة: `root`
4. أعد تشغيل MySQL

#### أو استخدم السكريبت:
افتح:
```
http://localhost/GUNS/reset_mysql_password.php
```

---

### الخطوة 3: تحديث ملف الإعدادات

بعد معرفة كلمة المرور الصحيحة، افتح `config/database.php` وحدّث السطر 22:

```php
define('DB_PASS', 'root');  // أو الكلمة التي عيّنتها
```

---

## اختبار النجاح

بعد التحديث، اختبر:
```
http://localhost/GUNS/test_student_registration.php
```

يجب أن ترى "✓ الاتصال بقاعدة البيانات نجح!"

---

## إذا استمرت المشكلة

1. **تحقق من أن MySQL يعمل:**
   - افتح AppServ Control Panel
   - تأكد من أن MySQL يعمل (Status: Running)

2. **جرب phpMyAdmin:**
   - افتح: http://localhost/phpmyadmin
   - جرب تسجيل الدخول بكلمات مرور مختلفة
   - الكلمة التي تنجح هي الصحيحة

3. **إعادة تعيين يدوي:**
   - اتبع التعليمات في `RESET_MYSQL_PASSWORD_GUIDE.md`

---

## الملفات المساعدة

- `test_mysql_connection.php` - اختبار تلقائي وتحديث الملف
- `reset_mysql_password.php` - واجهة إعادة التعيين
- `reset_mysql_password.ps1` - سكريبت PowerShell تلقائي
- `RESET_MYSQL_PASSWORD_GUIDE.md` - دليل شامل

