# دليل التثبيت - نظام نتائج الجامعة

## الخطوات الأساسية

### 1. إعداد قاعدة البيانات

قم بتشغيل ملف SQL لإنشاء قاعدة البيانات:

```bash
mysql -u root -p < database/schema.sql
```

أو من phpMyAdmin:
1. افتح phpMyAdmin
2. أنشئ قاعدة بيانات جديدة باسم `university_results`
3. استورد ملف `database/schema.sql`

### 2. إعداد الاتصال

قم بتعديل ملف `config/database.php`:

```php
define('DB_HOST', 'localhost');      // عنوان قاعدة البيانات
define('DB_USER', 'root');            // اسم المستخدم
define('DB_PASS', '');                // كلمة المرور
define('DB_NAME', 'university_results'); // اسم قاعدة البيانات
```

### 3. الصلاحيات

تأكد من أن المجلدات التالية قابلة للكتابة:
- `certificates/`
- `uploads/`

في Linux/Mac:
```bash
chmod 777 certificates uploads
```

### 4. تسجيل الدخول الأول

- **اسم المستخدم**: `admin`
- **كلمة المرور**: `admin123`

⚠️ **مهم جداً**: قم بتغيير كلمة المرور فوراً بعد أول تسجيل دخول!

### 5. إعداد Apache

تأكد من تفعيل `mod_rewrite` في Apache.

في `httpd.conf`:
```apache
LoadModule rewrite_module modules/mod_rewrite.so
```

## التحقق من التثبيت

1. افتح المتصفح وانتقل إلى: `http://localhost/GUNS`
2. يجب أن تظهر صفحة تسجيل الدخول
3. سجل دخول باستخدام البيانات الافتراضية
4. يجب أن تظهر لوحة التحكم

## المشاكل الشائعة

### خطأ في الاتصال بقاعدة البيانات
- تحقق من بيانات الاتصال في `config/database.php`
- تأكد من أن MySQL يعمل
- تأكد من أن قاعدة البيانات موجودة

### صفحة بيضاء
- تحقق من سجلات الأخطاء في PHP
- تأكد من أن PHP version 7.4 أو أحدث
- تحقق من تفعيل PDO extension

### مشاكل في الصلاحيات
- تأكد من أن المجلدات قابلة للكتابة
- تحقق من صلاحيات الملفات

## الخطوات التالية

بعد التثبيت الناجح:

1. **إنشاء الكليات**: من لوحة التحكم → إدارة الكليات
2. **إضافة التخصصات**: لكل كلية
3. **إنشاء الفصول الدراسية**: لكل تخصص
4. **إضافة المواد**: لكل فصل
5. **إضافة الطلاب**: مع إنشاء حسابات تلقائية
6. **تسجيل الطلاب في المواد**
7. **إدخال الدرجات**
8. **إدارة الرسوم**
9. **إصدار الشهادات**

## الأمان

- قم بتغيير كلمة مرور المدير فوراً
- استخدم HTTPS في الإنتاج
- قم بتحديث صلاحيات قاعدة البيانات
- راجع ملف `.htaccess` للتأكد من الحماية

