# دليل إدخال الدرجات - نظام نتائج الجامعة

## 📋 خطوات إدخال الدرجات الأصلية

### الطريقة 1: إدخال الدرجات (مبسط) - **موصى به**

1. **من لوحة التحكم**، اضغط على **"إدخال الدرجات (مبسط)"** أو افتح الرابط:
   ```
   enter_grades_simple.php
   ```

2. **اختر الفصل الدراسي**:
   - من القائمة المنسدلة، اختر الفصل الدراسي المطلوب
   - مثال: "فصل 1 - 2024-2025 (تقنية المعلومات)"

3. **اختر المادة**:
   - بعد اختيار الفصل، ستظهر قائمة بالمواد
   - اختر المادة التي تريد إدخال درجاتها
   - مثال: "IT001 - تقنية المعلومات_1 (3 ساعات)"

4. **أدخل درجات الطلاب**:
   - ستظهر قائمة بجميع الطلاب المسجلين في المادة
   - أدخل الدرجة لكل طالب (من 0 إلى 100)
   - اضغط **"حفظ"** بجانب كل طالب
   - سيتم حساب التقدير الحرفي والنقاط تلقائياً

5. **التحقق من الدرجات**:
   - بعد الحفظ، ستظهر التقدير الحرفي (A, B+, B, C, D, F)
   - ستظهر النقاط (4.0, 3.5, 3.0, 2.0, 1.0, 0.0)
   - الحالة ستتحول من "⚠ لم يتم" إلى "✓ تم"

---

### الطريقة 2: إدخال الدرجات (العادية)

1. **من لوحة التحكم**، اضغط على **"إدخال الدرجات"** أو افتح:
   ```
   grades.php
   ```

2. **اختر المادة والفصل**:
   - اختر المادة من القائمة
   - اختر الفصل الدراسي

3. **أدخل الدرجات**:
   - ستظهر قائمة الطلاب
   - أدخل الدرجات وحفظها

---

## 📊 نظام الدرجات

| الدرجة | التقدير | النقاط |
|--------|---------|--------|
| 80 - 100 | A | 4.0 |
| 70 - 79 | B+ | 3.5 |
| 65 - 69 | B | 3.0 |
| 55 - 64 | C | 2.0 |
| 50 - 54 | D | 1.0 |
| أقل من 50 | F | 0.0 |

---

## ✅ بعد إدخال الدرجات

بعد إدخال جميع الدرجات الأصلية:

1. **عرض النتائج الأصلية**:
   - اذهب إلى **"استخراج النتائج"** (`semester_results.php`)
   - اختر الكلية، التخصص، الفصل الدراسي، والسنة
   - اضغط على **"النتائج الأصلية (قبل المعالجة)"**
   - ستظهر جميع الدرجات الأصلية

2. **معايرة الدرجات**:
   - من نفس صفحة النتائج، اضغط على **"النتائج بعد المعايرة (ثوراندويك)"**
   - ستظهر الدرجات المعايرة تلقائياً
   - يمكنك تعديل معاملات المعايرة (المتوسط المستهدف والانحراف المعياري)
   - اضغط **"حفظ الدرجات المعايرة"** لحفظها في قاعدة البيانات

---

## ⚠️ ملاحظات مهمة

1. **يجب تسجيل الطلاب في المادة أولاً**:
   - إذا لم تظهر قائمة الطلاب، يجب تسجيلهم في المادة من صفحة "تسجيل طلاب"

2. **يجب إضافة المواد أولاً**:
   - إذا لم تظهر المواد، يجب إضافتها من صفحة "إدارة المواد"

3. **الدرجات الأصلية مطلوبة**:
   - لا يمكن معايرة الدرجات بدون وجود درجات أصلية
   - يجب إدخال جميع الدرجات الأصلية أولاً

4. **تحديث المعدلات**:
   - بعد إدخال أو تعديل أي درجة، يتم تحديث المعدل الفصلي والتراكمي تلقائياً

---

## 🔗 روابط سريعة

- **إدخال الدرجات (مبسط)**: `enter_grades_simple.php`
- **إدخال الدرجات (عادي)**: `grades.php`
- **استخراج النتائج**: `semester_results.php`
- **إدارة المواد**: `courses.php`
- **تسجيل طلاب**: `register_students_to_course.php`

---

## 💡 نصائح

- استخدم **"إدخال الدرجات (مبسط)"** لأنها أسهل وأسرع
- يمكنك إدخال الدرجات بشكل تدريجي (مادة تلو الأخرى)
- بعد إدخال جميع الدرجات، يمكنك عرض النتائج الأصلية والمعايرة
- احفظ الدرجات المعايرة بعد التأكد من المعاملات المناسبة

