# حل مشكلة "Forbidden - You don't have permission to access this resource"

## المشكلة
عند محاولة الوصول إلى الملفات، تظهر رسالة:
```
Forbidden
You don't have permission to access this resource.
```

## الحلول

### الحل 1: التحقق من أن Apache يعمل
1. افتح **AppServ Control Panel**
2. تأكد من أن **Apache** يعمل (Status: Running)
3. إذا لم يكن يعمل، اضغط **Start**

### الحل 2: التحقق من ملف .htaccess
تم تحديث ملف `.htaccess` للسماح بملفات الاختبار. إذا استمرت المشكلة:

1. افتح ملف `.htaccess`
2. تأكد من وجود السطور التالية في البداية:
```apache
# السماح بملفات الاختبار والمساعدات
RewriteCond %{REQUEST_FILENAME} -f
RewriteCond %{REQUEST_URI} \.(php|html|css|js|png|jpg|gif|ico|pdf)$ [NC]
RewriteRule ^ - [L]
```

### الحل 3: تعطيل .htaccess مؤقتاً (للاختبار فقط)
إذا استمرت المشكلة، يمكنك تعطيل `.htaccess` مؤقتاً:

1. أعد تسمية `.htaccess` إلى `.htaccess.backup`
2. جرّب الوصول للملفات مرة أخرى
3. إذا نجح، المشكلة في `.htaccess` - أعد التسمية وأصلح القواعد

### الحل 4: التحقق من إعدادات Apache
1. افتح ملف `httpd.conf` في AppServ (عادة في `C:\AppServ\Apache\conf\`)
2. تأكد من وجود:
```apache
LoadModule rewrite_module modules/mod_rewrite.so
```
3. تأكد من أن `AllowOverride` مضبوط على `All`:
```apache
<Directory "C:/AppServ/www">
    Options Indexes FollowSymLinks
    AllowOverride All
    Require all granted
</Directory>
```

### الحل 5: التحقق من الصلاحيات (Windows)
في Windows، عادة لا توجد مشاكل في الصلاحيات. لكن تأكد من:
1. أن المجلد `C:\AppServ\www\GUNS` قابل للقراءة
2. أن Apache لديه صلاحيات الوصول للمجلد

### الحل 6: اختبار بسيط
افتح في المتصفح:
```
http://localhost/GUNS/test.php
```

إذا ظهرت صفحة اختبار PHP، فالمشكلة في `.htaccess` أو ملف معين.
إذا لم تظهر، فالمشكلة في إعدادات Apache.

### الحل 7: الوصول المباشر للملفات
جرب الوصول للملفات مباشرة بدون `.htaccess`:
```
http://localhost/GUNS/find_mysql_password.php
http://localhost/GUNS/test_student_registration.php
```

### الحل 8: إعادة تشغيل Apache
1. افتح **AppServ Control Panel**
2. اضغط **Stop** على Apache
3. انتظر ثانيتين
4. اضغط **Start** مرة أخرى

## ملفات الاختبار المتاحة

بعد حل المشكلة، يمكنك استخدام:

1. **test.php** - اختبار بسيط لعمل PHP
   ```
   http://localhost/GUNS/test.php
   ```

2. **find_mysql_password.php** - للعثور على كلمة مرور MySQL
   ```
   http://localhost/GUNS/find_mysql_password.php
   ```

3. **test_student_registration.php** - اختبار شامل
   ```
   http://localhost/GUNS/test_student_registration.php
   ```

4. **test_connection.php** - اختبار الاتصال
   ```
   http://localhost/GUNS/test_connection.php
   ```

## ملاحظات مهمة

- **لا تحذف `.htaccess`** - إنه مهم للأمان
- إذا كنت في بيئة إنتاج، تأكد من إزالة ملفات الاختبار بعد الانتهاء
- ملفات الاختبار آمنة للاستخدام في بيئة التطوير

## إذا استمرت المشكلة

1. تحقق من سجلات Apache في `C:\AppServ\Apache\logs\error.log`
2. تحقق من سجلات PHP في `logs/php-error.log`
3. تأكد من أن AppServ مثبت بشكل صحيح

